/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.findPass;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.base.permission.IUserFindPass;
import com.kingdee.eas.base.permission.client.AbstractFindPassCheckVCodeUI;
import com.kingdee.eas.base.permission.client.findPass.AbstractUserFindPassStep;
import com.kingdee.eas.base.permission.client.findPass.ClientIpUtils;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class CheckVCodeStep
extends AbstractUserFindPassStep {
    private static final long serialVersionUID = -3282769697515428292L;
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static final String FINDPASSRESOURCE = "com.kingdee.eas.base.permission.PermissionFindPassResource";
    IUserFindPass userFindPass = null;
    private boolean isOnLine = true;
    private boolean isPhone;
    private KDLabel tip;
    private KDLabel txtPhoneOrEmail;
    private KDTextField inputVcode;
    private KDTextField inputPhoneOrEmail;
    private KDLabel txtVCode;
    private ResourceBundleHelper resHelper = new ResourceBundleHelper(AbstractFindPassCheckVCodeUI.class.getName());
    private KDLabel offineTip;
    private KDLabel labelGetCode;
    private KDLabel labelQrcode;
    private KDLabel phoneOrEmailError;
    private KDLabel txtVcodeTip;

    public CheckVCodeStep(String dataCenter, String local, String userNumber) {
        super(dataCenter, local, userNumber);
        this.tip = new KDLabel();
        this.txtPhoneOrEmail = new KDLabel();
        this.inputPhoneOrEmail = new KDTextField();
        this.inputVcode = new KDTextField();
        this.txtVCode = new KDLabel();
        this.labelQrcode = new KDLabel();
        this.offineTip = new KDLabel();
        this.labelGetCode = new KDLabel();
        this.phoneOrEmailError = new KDLabel();
        this.txtVcodeTip = new KDLabel();
        this.tip.setName("tip");
        this.txtPhoneOrEmail.setName("txtPhoneOrEmail");
        this.inputPhoneOrEmail.setName("inputPhoneOrEmail");
        this.inputVcode.setName("inputVcode");
        this.txtVCode.setName("txtVCode");
        this.labelQrcode.setName("labelQrcode");
        this.offineTip.setName("offineTip");
        this.labelGetCode.setName("labelGetCode");
        this.phoneOrEmailError.setName("phoneOrEmailError");
        this.txtVcodeTip.setName("txtVcodeTip");
        this.setToolTipText(this.resHelper.getString("this.toolTipText"));
        this.tip.setText(this.resHelper.getString("tip.text"));
        this.txtPhoneOrEmail.setText(this.resHelper.getString("txtPhoneOrEmail.text"));
        this.txtVCode.setText(this.resHelper.getString("txtVCode.text"));
        this.offineTip.setText(this.resHelper.getString("offineTip.text"));
        this.labelGetCode.setText(this.resHelper.getString("labelGetCode.text"));
        this.phoneOrEmailError.setVisible(false);
        this.txtVcodeTip.setVisible(false);
        this.initUIContentLayout();
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 560, 338));
        this.setLayout(null);
        this.tip.setBounds(new Rectangle(10, 10, 304, 19));
        this.add((Component)this.tip, null);
        this.txtPhoneOrEmail.setBounds(new Rectangle(10, 40, 112, 19));
        this.add((Component)this.txtPhoneOrEmail, null);
        this.inputPhoneOrEmail.setBounds(new Rectangle(128, 40, 138, 19));
        this.add((Component)this.inputPhoneOrEmail, null);
        this.inputVcode.setBounds(new Rectangle(128, 80, 138, 19));
        this.add((Component)this.inputVcode, null);
        this.txtVCode.setBounds(new Rectangle(10, 80, 112, 19));
        this.add((Component)this.txtVCode, null);
        this.labelQrcode.setBounds(new Rectangle(350, 167, 163, 158));
        this.add((Component)this.labelQrcode, null);
        this.offineTip.setBounds(new Rectangle(314, 138, 235, 19));
        this.add((Component)this.offineTip, null);
        this.labelGetCode.setBounds(new Rectangle(281, 40, 99, 19));
        this.add((Component)this.labelGetCode, null);
        this.phoneOrEmailError.setBounds(new Rectangle(128, 59, 230, 19));
        this.add((Component)this.phoneOrEmailError, null);
        this.txtVcodeTip.setBounds(new Rectangle(128, 106, 335, 19));
        this.add((Component)this.txtVcodeTip, null);
    }

    @Override
    public IWizardStep outThisStep(boolean isOppose) {
        String vcode;
        String phoneOrEmail = this.inputPhoneOrEmail.getText();
        if (StringUtils.isEmpty((String)phoneOrEmail)) {
            this.setPhoneOrEmailError(EASResource.getString((String)FINDPASSRESOURCE, (String)"FINDPASS_PHONR_OR_EMAIL_NOTEMPTY"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)(vcode = this.inputVcode.getText()))) {
            this.txtVcodeTip.setText(EASResource.getString((String)FINDPASSRESOURCE, (String)"FINDPASS_VCODE_NOTEMPTY"));
            this.txtVcodeTip.setForeground(Color.RED);
            this.txtVcodeTip.setVisible(true);
            SysUtil.abort();
        }
        IUserFindPass userFindPass = (IUserFindPass)RPCEngineFactory.getEngine((String)UIConfig.getUrl()).createObject("com.kingdee.eas.base.permission.app.UserFindPass", IUserFindPass.class);
        try {
            this.isPhone = phoneOrEmail.indexOf("@") < 0;
            this.userFindPassParam.setVcode(vcode);
            this.userFindPassParam.setUsePhone(this.isPhone);
            this.userFindPassParam.setOffineLine(this.isOnLine);
            if (this.isPhone) {
                this.userFindPassParam.setPhone(phoneOrEmail);
                this.userFindPassParam.setEmail(null);
            } else {
                this.userFindPassParam.setEmail(phoneOrEmail);
                this.userFindPassParam.setPhone(null);
            }
            String ut = userFindPass.verifyVCode(this.userFindPassParam);
            this.userFindPassParam.setUt(ut);
            this.txtVcodeTip.setVisible(false);
        }
        catch (Exception e) {
            this.setVCodeError(e.getMessage());
            SysUtil.abort();
        }
        return null;
    }

    @Override
    public void initStep(WizardDialog.StepsManager manager) {
        manager.getWizardDialog().setTitle(EASResource.getString((String)FINDPASSRESOURCE, (String)"FINDPASS_ACCOUNT_CHECK"));
        manager.setFinishEnabled(false);
        this.labelGetCode.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent paramMouseEvent) {
                CheckVCodeStep.this.sendVCode();
            }
        });
        this.userFindPass = (IUserFindPass)RPCEngineFactory.getEngine((String)UIConfig.getUrl()).createObject("com.kingdee.eas.base.permission.app.UserFindPass", IUserFindPass.class);
        this.resetUIState();
    }

    @Override
    public void destroy(boolean isFinished) {
        this.resetUIState();
    }

    private void resetUIState() {
        this.txtVcodeTip.setVisible(false);
        this.phoneOrEmailError.setVisible(false);
        this.offineTip.setVisible(false);
        this.offineTip.setForeground(Color.BLUE);
    }

    private void sendVCode() {
        String phoneOrEmail = this.inputPhoneOrEmail.getText();
        try {
            if (StringUtils.isEmpty((String)phoneOrEmail)) {
                this.setPhoneOrEmailError(EASResource.getString((String)FINDPASSRESOURCE, (String)"FINDPASS_PHONR_OR_EMAIL_NOTEMPTY"));
                return;
            }
            this.isPhone = phoneOrEmail.indexOf("@") < 0;
            String clientIP = ClientIpUtils.getClientIP();
            if (StringUtils.isEmpty((String)clientIP)) {
                clientIP = "127.0.0.1";
            }
            try {
                JSONObject result = this.userFindPass.sendVCode(this.dataCenter, this.local, this.userNumber, phoneOrEmail, clientIP);
                if (result != null && result.getInteger("errcode") == 0) {
                    this.isOnLine = true;
                    this.startTimer(JSONObject.parseObject((String)result.getString("data")).getInteger("resend_in"));
                    this.labelQrcode.setVisible(false);
                    this.offineTip.setVisible(false);
                    this.clearPhoneOrEmailError();
                } else {
                    if ("l1".equalsIgnoreCase(this.local)) {
                        this.setPhoneOrEmailError(result.getString(EasCloud.DESCRIPTION));
                    } else {
                        this.setPhoneOrEmailError(result.getString(EasCloud.DESCRIPTION_CN));
                    }
                    if (this.isPhone && result.getInteger("errcode") == 1507) {
                        this.initOfffineActiveModel();
                    }
                }
            }
            catch (Exception e) {
                if (this.isPhone && e.getCause() instanceof IOException) {
                    this.initOfffineActiveModel();
                }
                throw e;
            }
        }
        catch (Exception e) {
            this.setPhoneOrEmailError(e.getMessage());
        }
    }

    private void initOfffineActiveModel() throws Exception {
        this.isOnLine = false;
        this.inputPhoneOrEmail.setEnabled(false);
        this.labelGetCode.setEnabled(false);
        this.labelQrcode.setVisible(true);
        this.offineTip.setVisible(true);
        this.labelQrcode.setIcon((Icon)new ImageIcon(this.userFindPass.generatorOfflineQrcode(this.dataCenter, this.local, this.userNumber)));
    }

    private void setPhoneOrEmailError(String error) {
        this.phoneOrEmailError.setText(error);
        this.phoneOrEmailError.setForeground(Color.RED);
        this.phoneOrEmailError.setVisible(true);
        this.clearVCodeError();
    }

    private void clearPhoneOrEmailError() {
        this.phoneOrEmailError.setText("");
        this.phoneOrEmailError.setVisible(false);
    }

    private void setVCodeError(String error) {
        this.txtVcodeTip.setText(error);
        this.txtVcodeTip.setForeground(Color.RED);
        this.txtVcodeTip.setVisible(true);
        this.clearPhoneOrEmailError();
    }

    private void clearVCodeError() {
        this.txtVcodeTip.setText("");
        this.txtVcodeTip.setVisible(false);
    }

    private void startTimer(int reGetTime) {
        this.labelGetCode.setEnabled(false);
        SendTimerTask task = new SendTimerTask(reGetTime);
        Thread thread = new Thread(task);
        thread.start();
    }

    private class SendTimerTask
    implements Runnable {
        private int reGetTime;

        public SendTimerTask(int reGetTime) {
            this.reGetTime = reGetTime;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(1000L);
                    if (this.reGetTime == 0) {
                        CheckVCodeStep.this.labelGetCode.setText(EASResource.getString((String)CheckVCodeStep.RESOURCE, (String)"reGet"));
                        CheckVCodeStep.this.labelGetCode.setEnabled(true);
                        break;
                    }
                    --this.reGetTime;
                    CheckVCodeStep.this.labelGetCode.setText(EASResource.getString((String)CheckVCodeStep.RESOURCE, (String)"reGetCodeTime", (Object[])new Object[]{this.reGetTime}));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

