/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.AgentUserManagerFacadeFactory;
import com.kingdee.eas.base.permission.IAgentUserManagerFacade;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class AgentUserHelper {
    private static Logger logger = Logger.getLogger(AgentUserHelper.class);

    public static void swithAgent2NomalUser(List agentUserNumber) throws BOSException, EASBizException {
        if (agentUserNumber == null || agentUserNumber.isEmpty()) {
            logger.info((Object)"agentUserNumber is null || empty!");
            return;
        }
        IAgentUserManagerFacade iAgentUserManager = AgentUserManagerFacadeFactory.getRemoteInstance();
        iAgentUserManager.switchNormalUser(agentUserNumber);
    }

    public static void swithAgent2NomalUser(PersonInfo personInfo) throws BOSException, EASBizException {
        ArrayList<String> userNumberList = new ArrayList<String>();
        userNumberList.add(personInfo.getNumber());
        AgentUserHelper.swithAgent2NomalUser(userNumberList);
    }

    public static void swithAgent2NomalUser(PersonCollection personInfoCol) throws BOSException, EASBizException {
        List userNumberList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)personInfoCol, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                PersonInfo personInfo = (PersonInfo)obj;
                return personInfo.getNumber();
            }
        });
        AgentUserHelper.swithAgent2NomalUser(userNumberList);
    }

    public static FilterInfo findPersonRange() throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        List numberList = AgentUserHelper.getNumberList();
        if (numberList == null || numberList.isEmpty()) {
            return null;
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)ToolUtils.aryToStr(numberList, false), CompareType.INCLUDE));
        return filterInfo;
    }

    public static List getNumberList() throws BOSException, EASBizException {
        IAgentUserManagerFacade iAgentUserManager = AgentUserManagerFacadeFactory.getRemoteInstance();
        UserCollection userCol = iAgentUserManager.findAllAgentUserCollection();
        return ToolUtils.transCol2ListByPeroperty((IObjectCollection)userCol, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                UserInfo userInfo = (UserInfo)obj;
                return userInfo.getNumber();
            }
        });
    }
}

