/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ICloudRegistSrv;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.file.cloudRegist.DefaultUserEnum;
import com.kingdee.eas.base.permission.util.cloud.SynUserToCloudHelper;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CloudUserExportHelper {
    private String exportFilePath;
    private int dataRowStartIndex = 2;
    private int dataRowCount = 0;
    private int groupColumnStartIndex = 0;
    private static String RESOURCE_NAME = "com.kingdee.eas.base.permission.PermissionResource";

    public CloudUserExportHelper(String exportFilePath) {
        this.exportFilePath = exportFilePath;
    }

    public void execute() throws IOException, LicenseException, BOSException, SQLException {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet();
        this.fillHeader(sheet);
        this.fillData(sheet);
        this.writeToFile((Workbook)workbook);
    }

    public void execute(List<CloudUserInfo> data) throws IOException, LicenseException, BOSException, SQLException {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet();
        this.fillHeader(sheet);
        this.fillData(sheet, data);
        this.writeToFile((Workbook)workbook);
    }

    private void fillHeader(Sheet wsheet) {
        int columnIndex = this.fillUserInfoHeader(wsheet);
        this.fillLicenseGroupHeader(wsheet, columnIndex);
    }

    private int fillUserInfoHeader(Sheet wsheet) {
        List<Map<String, Object>> columnModel = this.getColumnModel();
        Row firstRow = wsheet.getRow(0);
        if (firstRow == null) {
            firstRow = wsheet.createRow(0);
        }
        Cell cell = null;
        CellRangeAddress region = null;
        Workbook workbook = wsheet.getWorkbook();
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.PALE_BLUE.getIndex());
        int index = 0;
        for (Map<String, Object> item : columnModel) {
            cell = firstRow.createCell(index);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(item.get("name").toString());
            region = new CellRangeAddress(0, 1, index, index);
            wsheet.addMergedRegion(region);
            Integer width = (Integer)item.get("width");
            if (width != null) {
                wsheet.setColumnWidth(index, width.intValue());
            }
            RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)wsheet);
            RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)wsheet);
            RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)wsheet);
            RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)wsheet);
            ++index;
        }
        return index;
    }

    private void fillLicenseGroupHeader(Sheet wsheet, int columnIndex) {
        int index;
        Row secondRow;
        List<Map<String, Object>> licenseGroup = this.getLicenseGroup();
        Row firstRow = wsheet.getRow(0);
        if (firstRow == null) {
            firstRow = wsheet.createRow(0);
        }
        if ((secondRow = wsheet.getRow(1)) == null) {
            secondRow = wsheet.createRow(1);
        }
        Cell cell = null;
        CellStyle cellStyle = wsheet.getWorkbook().createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.YELLOW.getIndex());
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        this.groupColumnStartIndex = index = columnIndex;
        for (Map<String, Object> item : licenseGroup) {
            cell = firstRow.createCell(index);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(item.get("number").toString());
            cell = secondRow.createCell(index);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(item.get("name").toString());
            Integer width = (Integer)item.get("width");
            if (width != null) {
                wsheet.setColumnWidth(index, width.intValue());
            }
            ++index;
        }
    }

    private void fillData(Sheet wsheet, List<CloudUserInfo> data) throws LicenseException, BOSException, SQLException {
        if (data == null) {
            data = SynUserToCloudHelper.assembleCloudUserInfo(null);
        }
        List<String> cloudUserDatas = this.getCloudUserDatas();
        Map<String, Map<String, String>> userDatas = SynUserToCloudHelper.convetToUserDatas(data);
        List<Map<String, String>> noCloudUserData = this.getNoCloudUserData(userDatas, cloudUserDatas);
        this.fillUserData(noCloudUserData);
        this.fillDataToExcel(wsheet, noCloudUserData);
        this.setLicenseGroupValidation(wsheet);
    }

    private void fillData(Sheet wsheet) throws LicenseException, BOSException, SQLException {
        this.fillData(wsheet, null);
    }

    private List<String> getCloudUserDatas() throws LicenseException {
        ICloudRegistSrv cloudRegistSrv = CloudRegistSrvAgentFactory.getRemoteInstance();
        int page = 0;
        int rows = 500;
        String cloudUserString = null;
        JSONArray datas = new JSONArray();
        while (!StringUtils.isEmpty((String)(cloudUserString = cloudRegistSrv.getCloudRegistUser(page * 500, rows)))) {
            datas.addAll((Collection)JSONArray.parseArray((String)cloudUserString));
            ++page;
        }
        ArrayList<String> userNumbers = new ArrayList<String>();
        JSONObject object = null;
        int size = datas.size();
        for (int i = 0; i < size; ++i) {
            object = datas.getJSONObject(i);
            userNumbers.add(object.getString("erpNumber"));
        }
        return userNumbers;
    }

    private Map<String, Map<String, String>> getDBUserDatas() throws BOSException, SQLException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        viewInfo.setSelector(sic);
        IQueryExecutor executor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.base.permission.app", "UserListQuery"));
        executor.setObjectView(viewInfo);
        IRowSet rowSet = executor.executeQuery();
        HashMap<String, Map<String, String>> users = new HashMap<String, Map<String, String>>(rowSet.size());
        String userNumber = null;
        HashMap<String, String> item = null;
        while (rowSet.next()) {
            userNumber = rowSet.getString("number");
            if (this.isDefaultUser(userNumber)) continue;
            item = new HashMap<String, String>();
            item.put("userNumber", userNumber);
            item.put("userName", rowSet.getString("name"));
            item.put("personNumber", rowSet.getString("person.number"));
            item.put("deptName", rowSet.getString("CU.name"));
            users.put(userNumber, item);
        }
        return users;
    }

    private boolean isDefaultUser(String userNumber) {
        if (StringUtils.isEmpty((String)userNumber)) {
            return false;
        }
        for (DefaultUserEnum def : DefaultUserEnum.values()) {
            if (!userNumber.equals(def.name())) continue;
            return true;
        }
        return false;
    }

    private List<Map<String, String>> getNoCloudUserData(Map<String, Map<String, String>> userDatas, List<String> cloudUserDatas) {
        ArrayList<Map<String, String>> noCloudUserData = new ArrayList<Map<String, String>>();
        Set<String> userNumbers = userDatas.keySet();
        for (String userNumber : userNumbers) {
            if (cloudUserDatas.contains(userNumber)) continue;
            noCloudUserData.add(userDatas.get(userNumber));
        }
        return noCloudUserData;
    }

    private void fillUserData(List<Map<String, String>> userDatas) throws BOSException, SQLException {
        int rows = 100;
        int totalPage = userDatas.size() / rows + 1;
        for (int page = 0; page < totalPage; ++page) {
            this.fillUserData(userDatas, page, rows);
        }
    }

    private void fillUserData(List<Map<String, String>> userDatas, int page, int rows) throws BOSException, SQLException {
        Map<String, String> item = null;
        String personNumber = null;
        HashSet<String> personNumbers = new HashSet<String>();
        int start = page * rows;
        int end = start + rows;
        if (end > userDatas.size()) {
            end = userDatas.size();
        }
        for (int i = start; i < end; ++i) {
            item = userDatas.get(i);
            personNumber = item.get("personNumber");
            if (StringUtils.isEmpty((String)personNumber)) continue;
            personNumbers.add(personNumber);
        }
        Map<String, Map<String, Object>> persons = this.getPersonInfos(personNumbers);
        Map<String, Object> personInfo = null;
        for (int i = start; i < end; ++i) {
            Date birthday;
            item = userDatas.get(i);
            personNumber = item.get("personNumber");
            if (StringUtils.isEmpty((String)personNumber) || null == (personInfo = persons.get(personNumber))) continue;
            Genders gender = (Genders)personInfo.get("gender");
            if (gender != null) {
                item.put("gender", gender.getAlias());
            }
            if ((birthday = (Date)personInfo.get("birthday")) != null) {
                item.put("birthday", DateTimeUtils.format((java.util.Date)birthday, (String)"yyyy-MM-dd"));
            }
            item.put("idCardNO", (String)personInfo.get("idCardNO"));
            item.put("email", (String)personInfo.get("email"));
            item.put("phone", (String)personInfo.get("cell"));
            item.put("position", (String)personInfo.get("position"));
            item.put("cloudUuId", (String)personInfo.get("cloudUuId"));
            item.put("status", (String)personInfo.get("status"));
            item.put("is_delete", (String)personInfo.get("is_delete"));
        }
    }

    private Map<String, Map<String, Object>> getPersonInfos(Set<String> personNumbers) throws BOSException, SQLException {
        IRowSet rowSet = SynUserToCloudHelper.getPersonInfo(personNumbers);
        HashMap<String, Map<String, Object>> persons = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> personInfo = null;
        String personNumber = null;
        while (rowSet.next()) {
            personNumber = rowSet.getString("pnumber");
            personInfo = new HashMap<String, Object>();
            personInfo.put("number", personNumber);
            personInfo.put("gender", Genders.getEnum((int)rowSet.getInt("gender")));
            personInfo.put("idCardNO", rowSet.getString("idCardNO"));
            personInfo.put("birthday", rowSet.getDate("birthday"));
            personInfo.put("email", rowSet.getString("email"));
            personInfo.put("cell", rowSet.getString("cell"));
            personInfo.put("position", rowSet.getString("posName"));
            personInfo.put("deptName", rowSet.getString("dept"));
            personInfo.put("cloudUuId", "");
            int is_delete = rowSet.getInt("FIsDelete");
            personInfo.put("is_delete", is_delete == 1 ? EASResource.getString((String)RESOURCE_NAME, (String)"yes") : EASResource.getString((String)RESOURCE_NAME, (String)"no"));
            int isForbidden = rowSet.getInt("FForbidden");
            personInfo.put("status", isForbidden == 0 ? EASResource.getString((String)RESOURCE_NAME, (String)"no") : EASResource.getString((String)RESOURCE_NAME, (String)"yes"));
            persons.put(personNumber, personInfo);
        }
        return persons;
    }

    private void fillDataToExcel(Sheet wsheet, List<Map<String, String>> noCloudUserData) {
        Row row = null;
        Cell cell = null;
        Workbook workbook = wsheet.getWorkbook();
        CellStyle cellStyle = workbook.createCellStyle();
        DataFormat fmt = workbook.createDataFormat();
        cellStyle.setDataFormat(fmt.getFormat("@"));
        int index = 0;
        List<Map<String, Object>> columnModel = this.getColumnModel();
        columnModel.addAll(this.getLicenseGroup());
        for (Map<String, String> item : noCloudUserData) {
            row = wsheet.createRow(this.dataRowStartIndex + index);
            item.put("index", String.valueOf(index + 1));
            int columnIndex = 0;
            String columnNumber = null;
            for (Map<String, Object> column : columnModel) {
                columnNumber = (String)column.get("number");
                cell = row.createCell(columnIndex++);
                cell.setCellValue(item.get(columnNumber));
                cell.setCellStyle(cellStyle);
            }
            ++index;
            ++this.dataRowCount;
        }
    }

    private void setLicenseGroupValidation(Sheet sheet) {
        String[] validation = new String[]{EASResource.getString((String)RESOURCE_NAME, (String)"yes"), EASResource.getString((String)RESOURCE_NAME, (String)"no")};
        int firstRow = this.dataRowStartIndex;
        int endRow = firstRow + this.dataRowCount;
        int firstCol = this.groupColumnStartIndex;
        int endCol = firstCol + this.getLicenseGroup().size();
        this.setExcelValidation(sheet, validation, firstRow, endRow, firstCol, endCol);
    }

    private void setExcelValidation(Sheet sheet, String[] textlist, int firstRow, int endRow, int firstCol, int endCol) {
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
    }

    private void writeToFile(Workbook workbook) throws IOException {
        File file = new File(this.exportFilePath);
        FileOutputStream fileOut = new FileOutputStream(file);
        workbook.write((OutputStream)fileOut);
        fileOut.close();
    }

    private List<Map<String, Object>> getColumnModel() {
        ArrayList<Map<String, Object>> columnModel = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("number", "index");
        item.put("name", EASResource.getString((String)RESOURCE_NAME, (String)"index"));
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "personNumber");
        item.put("name", EASResource.getString((String)RESOURCE_NAME, (String)"person_number"));
        item.put("width", 3000);
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "userName");
        item.put("name", "*" + EASResource.getString((String)RESOURCE_NAME, (String)"user_name"));
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "gender");
        item.put("name", EASResource.getString((String)RESOURCE_NAME, (String)"gender"));
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "birthday");
        item.put("name", EASResource.getString((String)RESOURCE_NAME, (String)"birthday"));
        item.put("width", 4000);
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "idCardNO");
        item.put("name", EASResource.getString((String)RESOURCE_NAME, (String)"id_card_NO"));
        item.put("width", 5000);
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "phone");
        item.put("name", "*" + EASResource.getString((String)RESOURCE_NAME, (String)"phone"));
        item.put("width", 4000);
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "email");
        item.put("name", EASResource.getString((String)RESOURCE_NAME, (String)"email"));
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "deptName");
        item.put("name", EASResource.getString((String)RESOURCE_NAME, (String)"dept_name"));
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "position");
        item.put("name", EASResource.getString((String)RESOURCE_NAME, (String)"position"));
        item.put("width", 5000);
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "userNumber");
        item.put("name", "*" + EASResource.getString((String)RESOURCE_NAME, (String)"user_number"));
        item.put("width", 4000);
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "cloudUuId");
        item.put("name", EASResource.getString((String)RESOURCE_NAME, (String)"CLOUD_ID"));
        item.put("width", 5000);
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "status");
        item.put("name", EASResource.getString((String)RESOURCE_NAME, (String)"is_forbid"));
        item.put("width", 4000);
        columnModel.add(item);
        item = new HashMap();
        item.put("number", "is_delete");
        item.put("name", EASResource.getString((String)RESOURCE_NAME, (String)"is_delete"));
        item.put("width", 4000);
        columnModel.add(item);
        return columnModel;
    }

    private List<Map<String, Object>> getLicenseGroup() {
        ArrayList<Map<String, Object>> group = new ArrayList<Map<String, Object>>();
        int defaultWidth = 5000;
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("number", "PRF");
        item.put("name", EASResource.getString((String)RESOURCE_NAME, (String)"PROFESSIONAL_APP"));
        item.put("width", defaultWidth);
        group.add(item);
        item = new HashMap();
        item.put("number", "SYS");
        item.put("name", EASResource.getString((String)RESOURCE_NAME, (String)"PLATFORM_APP"));
        item.put("width", defaultWidth);
        group.add(item);
        item = new HashMap();
        item.put("number", "SLF");
        item.put("name", EASResource.getString((String)RESOURCE_NAME, (String)"FULL_STAFF_APP"));
        item.put("width", defaultWidth);
        group.add(item);
        return group;
    }
}

