/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IPermissionManager;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionManagerFactory;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.client.helper.PermissionOrgF7Factory;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.NewOUUnionF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PermissionUIHelper {
    private static Logger logger = Logger.getLogger((String)PermissionUIHelper.class.getName());

    public static Map getCurrentUserOrgs(OrgRangeType orgRangeType) throws BOSException, EASBizException {
        IPermissionManager iPermissionManager = PermissionManagerFactory.getRemoteInstance();
        Map map = iPermissionManager.getUserOrgs(null, ToolUtils.getCurrentUserPK(), orgRangeType);
        return map;
    }

    public static Map getUserOrgs(Set selectedOrgs, OrgRangeType orgRangeType) throws EASBizException, BOSException {
        Map map = PermissionUIHelper.getCurrentUserOrgs(orgRangeType);
        Iterator iterator = selectedOrgs.iterator();
        while (iterator.hasNext()) {
            map.put((String)iterator.next(), Boolean.FALSE);
        }
        return map;
    }

    public static FullOrgUnitInfo[] getOrgs(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof OrgUnitInfo) {
            return new FullOrgUnitInfo[]{((OrgUnitInfo)object).castToFullOrgUnitInfo()};
        }
        if (object instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] orgUnitInfos = (OrgUnitInfo[])object;
            FullOrgUnitInfo[] fullOrgUnitInfos = new FullOrgUnitInfo[orgUnitInfos.length];
            int length = orgUnitInfos.length;
            for (int i = 0; i < length; ++i) {
                fullOrgUnitInfos[i] = orgUnitInfos[i].castToFullOrgUnitInfo();
            }
            return fullOrgUnitInfos;
        }
        throw new IllegalArgumentException("object is " + object);
    }

    public static boolean existOrg(KDTable tblBizOrgRange, IObjectPK targetPK) {
        int count = tblBizOrgRange.getRowCount();
        for (int i = 0; i < count; ++i) {
            ObjectUuidPK orgPK = new ObjectUuidPK(((FullOrgUnitInfo)tblBizOrgRange.getRow(i).getCell("org").getValue()).getId());
            if (targetPK == null || !targetPK.equals((Object)orgPK)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCanBeDefOrg(FullOrgUnitInfo fullOrgUnitInfo) {
        return ToolUtils.isCanBeDefOrg(fullOrgUnitInfo);
    }

    public static Set getSelectedBizOrgRanges(KDTable tblBizOrgRange) {
        HashSet<String> currentOrgs = new HashSet<String>();
        int size = tblBizOrgRange.getRowCount();
        for (int i = 0; i < size; ++i) {
            FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)tblBizOrgRange.getRow(i).getCell("org").getValue();
            currentOrgs.add(fullOrgUnitInfo.getId().toString());
        }
        return currentOrgs;
    }

    public static Set getSelectedBizOrgRanges(KDTable tblBizOrgRange, String orgIdName) {
        HashSet<String> currentOrgs = new HashSet<String>();
        int size = tblBizOrgRange.getRowCount();
        for (int i = 0; i < size; ++i) {
            Object obj = tblBizOrgRange.getRow(i).getCell(orgIdName).getValue();
            if (obj instanceof FullOrgUnitInfo) {
                FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)obj;
                currentOrgs.add(fullOrgUnitInfo.getId().toString());
                continue;
            }
            currentOrgs.add(StringUtils.cnulls((Object)obj));
        }
        return currentOrgs;
    }

    public static Set getSelectedBizDataRanges(KDTable tblBizOrgRange, String orgIdName) {
        HashSet<String> currentOrgs = new HashSet<String>();
        int size = tblBizOrgRange.getRowCount();
        for (int i = 0; i < size; ++i) {
            Object obj = tblBizOrgRange.getRow(i).getCell(orgIdName).getValue();
            currentOrgs.add(StringUtils.cnulls((Object)obj));
        }
        return currentOrgs;
    }

    public static List getUserCuIdList() throws EASBizException, BOSException {
        return PermissionRangeHelper.getCUOrgRange(null);
    }

    public static FullOrgUnitCollection findOrgRange(IObjectPK userPK, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        IPermissionManager permissionManager = PermissionManagerFactory.getRemoteInstance();
        return permissionManager.findOrgRange(userPK, orgRangeType);
    }

    public static OrgStructureCollection getOrgStructre(List orgIdList) throws BOSException {
        OrgStructureCollection orgStructureCol = new OrgStructureCollection();
        if (orgIdList == null || orgIdList.isEmpty()) {
            return orgStructureCol;
        }
        IOrgStructure iOrgStructure = OrgStructureFactory.getRemoteInstance();
        return iOrgStructure.getOrgStructureCollection("select id,tree.id,tree.startDate,tree.endDate,unit.id,unit.isUnion where unit.id in(" + ToolUtils.aryToStr(orgIdList, true) + ")");
    }

    public static OrgStructureCollection getUnionOrgStructre(List orgIdList) throws BOSException {
        OrgStructureCollection orgStructureCol = new OrgStructureCollection();
        if (orgIdList == null || orgIdList.isEmpty()) {
            return orgStructureCol;
        }
        IOrgStructure iOrgStructure = OrgStructureFactory.getRemoteInstance();
        return iOrgStructure.getOrgStructureCollection("select id,tree.id,tree.startDate,tree.endDate,unit.id where unit.id in(" + ToolUtils.aryToStr(orgIdList, true) + ") and unit.isunion = 1");
    }

    public static FullOrgUnitInfo[] getAdminOrgRangeByUserSelect(IUIObject _uiObject, Set alreadySelectOrgSet) throws EASBizException, UIException, BOSException, Exception {
        return PermissionUIHelper.getOrgRangeByUserSelect(new OrgViewType[]{OrgViewType.ADMIN}, _uiObject, alreadySelectOrgSet);
    }

    public static FullOrgUnitInfo[] getCtrlUnitOrgRangeByUserSelect(IUIObject _uiObject, Set alreadySelectOrgSet) throws EASBizException, UIException, BOSException, Exception {
        return PermissionUIHelper.getOrgRangeByUserSelect(new OrgViewType[]{OrgViewType.CTRLUNIT}, _uiObject, alreadySelectOrgSet);
    }

    public static FullOrgUnitInfo[] getBizOrgRangeByUserSelect(IUIObject _uiObject, Set alreadySelectOrgSet) throws EASBizException, UIException, BOSException, Exception {
        IObjectPK currentUserPK = ToolUtils.getCurrentUserPK();
        String bizUserCUOrgRangeSql = PermissionRangeHelper.getBizUserCUOrgRangeSQL(null, currentUserPK);
        boolean isAdmin = Administrator.isCUAdmin(null, currentUserPK);
        NewOUUnionF7 orgF7 = PermissionOrgF7Factory.getNewOUUnionF7(_uiObject, alreadySelectOrgSet, "00000000-0000-0000-0000-000000000000CCE7AED4", bizUserCUOrgRangeSql, isAdmin, bizUserCUOrgRangeSql);
        FullOrgUnitInfo[] fullOrgUnitInfos = null;
        orgF7.setNeedAddSealUp(true);
        orgF7.show();
        if (!orgF7.isCanceled()) {
            fullOrgUnitInfos = ToolUtils.transFromOrgUnitInfo((OrgUnitInfo[])orgF7.getData());
        }
        return fullOrgUnitInfos;
    }

    public static FullOrgUnitInfo[] getOrgRangeByUserSelect(OrgViewType[] orgViewTypes, IUIObject _uiObject, Set alreadySelectOrgSet) throws EASBizException, BOSException, Exception {
        FullOrgUnitInfo[] fullOrgUnitInfos = null;
        NewOrgF7 orgF7 = PermissionOrgF7Factory.getNewOrgF7(_uiObject, orgViewTypes, true, ToolUtils.getCurrentCUPK().toString());
        if (alreadySelectOrgSet != null && !alreadySelectOrgSet.isEmpty()) {
            orgF7.setSelectedOrgIds(alreadySelectOrgSet);
        }
        orgF7.setNeedAddSealUp(true);
        orgF7.setNeedAddVirtual(true);
        orgF7.show();
        if (!orgF7.isCanceled()) {
            fullOrgUnitInfos = ToolUtils.transFromOrgUnitInfo((OrgUnitInfo[])orgF7.getData());
        }
        return fullOrgUnitInfos;
    }

    public static List getOrgStructureByCUList(String cuIdList) throws BOSException {
        return PermissionUtils.getOrgStructureByCUList(null, cuIdList);
    }

    public static String getOrgStructureByCUSQL(String cuIdSQL) throws BOSException {
        return PermissionUtils.getOrgStructureByCUSQL(null, cuIdSQL);
    }

    public static List getSubOrgIds(String orgIdList) throws Exception {
        return PermissionUtils.getSubOrgIds(null, orgIdList);
    }

    public static String getSubOrgIdsBySQL(String orgIdSQL) throws Exception {
        return PermissionUtils.getSubOrgIdsBySQL(null, orgIdSQL);
    }

    public static FullOrgUnitInfo[] getDifferentRoots(String idList) throws Exception {
        return PermissionUtils.getDifferentRoots(null, idList);
    }

    public static List getAllCU() throws EASBizException, BOSException {
        return PermissionUtils.getAllCU(null);
    }
}

