/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.client.helper.PermissionUIHelper;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UnionOrgHelper {
    private Map unionOrgMap = new HashMap();
    private static final Logger logger = Logger.getLogger((String)UnionOrgHelper.class.getName());

    public void init(List orgIdList) throws BOSException {
        this.unionOrgMap.clear();
        OrgStructureCollection orgStructCol = PermissionUIHelper.getUnionOrgStructre(orgIdList);
        OrgStructureCollection unionOrgCol = new OrgStructureCollection();
        if (orgStructCol != null) {
            for (int i = 0; i < orgStructCol.size(); ++i) {
                FullOrgUnitInfo fullOrgUnitInfo = orgStructCol.get(i).getUnit();
                if (fullOrgUnitInfo == null || !fullOrgUnitInfo.isIsUnion()) continue;
                unionOrgCol.add(orgStructCol.get(i));
            }
        }
        this.addOrgStructCol(unionOrgCol);
    }

    public void init(OrgRangeCollection orgRangeCol) throws BOSException {
        if (orgRangeCol == null || orgRangeCol.isEmpty()) {
            this.unionOrgMap.clear();
            return;
        }
        List idList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)orgRangeCol, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                OrgRangeInfo orgRangeInfo = (OrgRangeInfo)obj;
                if (orgRangeInfo == null || orgRangeInfo.getOrg() == null || orgRangeInfo.getOrg().getId() == null) {
                    return null;
                }
                if (orgRangeInfo.getOrg().isIsUnion()) {
                    return orgRangeInfo.getOrg().getId().toString();
                }
                return null;
            }
        });
        this.init(idList);
    }

    public void init(FullOrgUnitInfo[] fullOrgUnitInfos) throws BOSException {
        if (fullOrgUnitInfos == null || fullOrgUnitInfos.length == 0) {
            this.unionOrgMap.clear();
            return;
        }
        ArrayList<String> orgIdList = new ArrayList<String>();
        int size = fullOrgUnitInfos.length;
        for (int i = 0; i < size; ++i) {
            if (!fullOrgUnitInfos[i].isIsUnion()) continue;
            orgIdList.add(fullOrgUnitInfos[i].getId().toString());
        }
        this.init(orgIdList);
    }

    private void addOrgStructCol(OrgStructureCollection orgStructCol) {
        DateFormat format = BOSLocaleUtil.getDateFormat();
        if (orgStructCol == null) {
            return;
        }
        int size = orgStructCol.size();
        for (int i = 0; i < size; ++i) {
            OrgStructureInfo orgInfo = orgStructCol.get(i);
            if (orgInfo.getId() == null || this.unionOrgMap.containsKey(orgInfo.getId().toString())) continue;
            OrgTreeInfo orgTreeInfo = orgInfo.getTree();
            String startDate = "";
            if (orgTreeInfo.getStartDate() != null) {
                startDate = StringUtils.cnulls((String)format.format(orgTreeInfo.getStartDate()));
            }
            String tempSeperator = "~";
            if (StringUtils.isEmpty((String)startDate)) {
                tempSeperator = "";
            }
            String endDate = "";
            if (orgTreeInfo.getEndDate() != null) {
                endDate = StringUtils.cnulls((String)format.format(orgTreeInfo.getEndDate()));
            }
            String allDate = startDate;
            if (!StringUtils.isEmpty((String)endDate)) {
                allDate = allDate + tempSeperator + endDate;
            }
            this.unionOrgMap.put(orgInfo.getUnit().getId().toString(), allDate);
        }
    }

    public String getDateViewByOrgId(String orgId) throws BOSException {
        try {
            if (orgId == null) {
                return "";
            }
            if (this.unionOrgMap.containsKey(orgId)) {
                return this.retString(orgId);
            }
            IFullOrgUnit iFullorgUnit = FullOrgUnitFactory.getRemoteInstance();
            FullOrgUnitInfo fullOrgUnitInfo = iFullorgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
            if (fullOrgUnitInfo != null && fullOrgUnitInfo.isIsUnion()) {
                ArrayList<String> orgList = new ArrayList<String>();
                orgList.add(orgId);
                OrgStructureCollection orgStructCol = PermissionUIHelper.getOrgStructre(orgList);
                this.addOrgStructCol(orgStructCol);
                return this.retString(orgId);
            }
            return "";
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public String getDateViewByOrgId(FullOrgUnitInfo fullOrgUnitInfo) throws BOSException {
        if (fullOrgUnitInfo == null) {
            return "";
        }
        String orgId = fullOrgUnitInfo.getId().toString();
        if (this.unionOrgMap.containsKey(orgId)) {
            return this.retString(orgId);
        }
        if (fullOrgUnitInfo.isIsUnion()) {
            ArrayList<String> orgList = new ArrayList<String>();
            orgList.add(orgId);
            OrgStructureCollection orgStructCol = PermissionUIHelper.getOrgStructre(orgList);
            this.addOrgStructCol(orgStructCol);
            return this.retString(orgId);
        }
        return "";
    }

    private String retString(String orgId) {
        String retStr = StringUtils.cnulls(this.unionOrgMap.get(orgId));
        if (!StringUtils.isEmpty((String)retStr)) {
            return "(" + retStr + ")";
        }
        return retStr;
    }

    public void destroyUnionOrgMap() {
        this.unionOrgMap.clear();
    }
}

