/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.machine;

import com.kingdee.eas.base.permission.client.machine.IHardwareInfoCollector;
import com.kingdee.eas.util.client.EASResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public abstract class AbstractHardwareInfoCollector
implements IHardwareInfoCollector {
    private static String RESOURCE_NAME = "com.kingdee.eas.base.permission.PermissionResource";

    @Override
    public String getMACAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            StringBuilder sb = new StringBuilder();
            TreeSet<String> tmpMacList = new TreeSet<String>();
            while (en.hasMoreElements()) {
                NetworkInterface iface = en.nextElement();
                List<InterfaceAddress> addrs = iface.getInterfaceAddresses();
                for (InterfaceAddress addr : addrs) {
                    byte[] mac;
                    InetAddress ip = addr.getAddress();
                    NetworkInterface network = NetworkInterface.getByInetAddress(ip);
                    if (network == null || (mac = network.getHardwareAddress()) == null) continue;
                    sb.delete(0, sb.length());
                    for (int i = 0; i < mac.length; ++i) {
                        sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                    }
                    if (sb.toString().trim().length() <= 0) continue;
                    tmpMacList.add(sb.toString());
                }
            }
            StringBuilder rs = new StringBuilder();
            Iterator ite = tmpMacList.iterator();
            while (ite.hasNext()) {
                rs.append(((String)ite.next()).toString()).append("#");
            }
            return rs.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(EASResource.getString((String)RESOURCE_NAME, (String)"COMPUTE_MAC_ADDRESS"));
        }
    }

    public List<String> runNative(String cmdToRun) {
        String[] cmdToRunWithArgs = cmdToRun.split(" ");
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmdToRunWithArgs);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
        ArrayList<String> sa = new ArrayList<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset()));
            while ((line = reader.readLine()) != null) {
                sa.add(line);
            }
            p.waitFor();
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        return sa;
    }
}

