/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.machine;

import com.kingdee.bos.util.MD5Util;
import com.kingdee.eas.base.permission.client.machine.AbstractHardwareInfoCollector;
import com.kingdee.eas.base.permission.client.machine.IHardwareInfoCollector;
import com.kingdee.eas.util.client.EASResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Pattern;

public class LinuxHardwareInfoCollector
extends AbstractHardwareInfoCollector
implements IHardwareInfoCollector {
    private static String RESOURCE_NAME = "com.kingdee.eas.base.permission.PermissionResource";

    @Override
    public String getHardDriverID() {
        Process process = null;
        BufferedReader bufferedReader = null;
        StringBuffer buffer = new StringBuffer();
        try {
            process = Runtime.getRuntime().exec("udevadm info --query=all --name=/dev/sda | grep ID_SERIAL");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(EASResource.getString((String)RESOURCE_NAME, (String)"COMPUTE_DISK_INFO"));
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            bufferedReader = null;
            process = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCPUID() {
        String cpuid;
        block14: {
            cpuid = null;
            try {
                boolean procInfo = false;
                String marker = "Processor Information";
                for (String checkLine : this.runNative("dmidecode -t 4")) {
                    if (!procInfo && checkLine.contains(marker)) {
                        marker = "ID:";
                        procInfo = true;
                        continue;
                    }
                    if (!procInfo || !checkLine.contains(marker)) continue;
                    cpuid = checkLine.split(marker)[1].trim();
                    break;
                }
                marker = "eax=";
                for (String checkLine : this.runNative("cpuid -1r")) {
                    if (!checkLine.contains(marker) || !checkLine.trim().startsWith("0x00000001")) continue;
                    String eax = "";
                    String edx = "";
                    for (String register : Pattern.compile("\\s+").split(checkLine)) {
                        if (register.startsWith("eax=")) {
                            eax = this.removeMatchingString(register, "eax=0x");
                            continue;
                        }
                        if (!register.startsWith("edx=")) continue;
                        edx = this.removeMatchingString(register, "edx=0x");
                    }
                    cpuid = edx + eax;
                    break;
                }
                if (cpuid != null) break block14;
                try (BufferedReader read = null;){
                    File file = new File("/proc/cpuinfo");
                    read = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
                    StringBuilder sb = new StringBuilder();
                    String line = null;
                    while ((line = read.readLine()) != null) {
                        sb.append(line);
                    }
                    cpuid = MD5Util.getMD5String((String)sb.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cpuid;
    }

    public String removeMatchingString(String original, String toRemove) {
        if (original == null || original.isEmpty() || toRemove == null || toRemove.isEmpty()) {
            return original;
        }
        int matchIndex = original.indexOf(toRemove, 0);
        if (matchIndex == -1) {
            return original;
        }
        StringBuilder buffer = new StringBuilder(original.length() - toRemove.length());
        int currIndex = 0;
        do {
            buffer.append(original.substring(currIndex, matchIndex));
        } while ((matchIndex = original.indexOf(toRemove, currIndex = matchIndex + toRemove.length())) != -1);
        buffer.append(original.substring(currIndex));
        return buffer.toString();
    }
}

