/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.AuthorizeTypeEnum;
import com.kingdee.eas.base.permission.IDSecondAuthorizeFactory;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.PasswordInputUI;
import com.kingdee.eas.base.permission.client.plugin.IIdentityAuthorize;
import com.kingdee.eas.base.permission.client.plugin.IIdentityCAAuthorize;
import com.kingdee.eas.base.permission.client.plugin.IdentityAuthorizeFactory;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class IDSecondAuthorizeHelper {
    private static Logger logger = Logger.getLogger(IDSecondAuthorizeHelper.class);
    private static IDSecondAuthorizeHelper innerHelper = null;
    private Map uiContext;

    private IDSecondAuthorizeHelper() {
    }

    public static IDSecondAuthorizeHelper getHelper() {
        if (innerHelper == null) {
            innerHelper = new IDSecondAuthorizeHelper();
        }
        return innerHelper;
    }

    public AuthorizeTypeEnum IDAuthorize(String permItemName) throws EASBizException, BOSException {
        if (!PermissionCommonUtil.isIDAuthorizeEnabled(null)) {
            return null;
        }
        if (this.uiContext == null) {
            this.uiContext = new HashMap();
            this.uiContext.put("PERMISSIONITEM", permItemName);
        } else {
            this.uiContext.put("PERMISSIONITEM", permItemName);
        }
        AuthorizeTypeEnum authorizeType = IDSecondAuthorizeFactory.getRemoteInstance().getAuthorizeType(permItemName);
        this.IDAuthorize(authorizeType);
        return authorizeType;
    }

    public AuthorizeTypeEnum IDAuthorize(IMetaDataPK uiPK, IMetaDataPK actionPK) throws EASBizException, BOSException {
        if (!PermissionCommonUtil.isIDAuthorizeEnabled(null)) {
            return null;
        }
        if (this.uiContext != null) {
            this.uiContext.put("ACTION.PK", actionPK);
        }
        AuthorizeTypeEnum authorizeType = IDSecondAuthorizeFactory.getRemoteInstance().getAuthorizeType(uiPK, actionPK);
        this.IDAuthorize(authorizeType);
        return authorizeType;
    }

    public void setUIContext(Map uiContext) {
        this.uiContext = uiContext;
    }

    private boolean isCAAuthorize(AuthorizeTypeEnum authorizeType) {
        IIdentityAuthorize iIdentity = IdentityAuthorizeFactory.getInstance(authorizeType);
        return IIdentityCAAuthorize.class.isAssignableFrom(iIdentity.getClass());
    }

    public void IDAuthorize(AuthorizeTypeEnum authorizeType) throws PermissionException {
        block7: {
            IIdentityAuthorize iIdentity = IdentityAuthorizeFactory.getInstance(authorizeType);
            logger.error((Object)("enter to authorize...authorizeType is: " + (Object)((Object)authorizeType) + ", iIdentity is:" + iIdentity));
            try {
                if (this.isCAAuthorize(authorizeType)) {
                    logger.error((Object)"enter to authorize...it's CAAuthorize ");
                    boolean result = false;
                    try {
                        result = ((IIdentityCAAuthorize)iIdentity).checkIdentity(ComponentUtil.getOwnerWindow(null), ToolUtils.getCurrentUserPK(), this.uiContext, authorizeType);
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                        if (e instanceof AbortException) {
                            throw (AbortException)e;
                        }
                        ExceptionHandler.handle((Throwable)e);
                    }
                    if (!result) {
                        throw new PermissionException(PermissionException.ID_AUTHORIZE_FAIL, new Object[]{PermissionCommonUtil.getAuthorizeDiscription(authorizeType)});
                    }
                    break block7;
                }
                logger.error((Object)"enter to authorize...it's not CAAuthorize");
                iIdentity.checkIdentity(ComponentUtil.getOwnerWindow(null), ToolUtils.getCurrentUserPK());
            }
            catch (PermissionException ex) {
                throw new PermissionException(PermissionException.ID_AUTHORIZE_FAIL, new Object[]{PermissionCommonUtil.getAuthorizeDiscription(authorizeType)});
            }
        }
    }

    public static void checkPasswordWhenRelogin() throws PermissionException {
        LoginAuthorWayEnum loginWay;
        UserInfo currentUser = SysContext.getSysContext().getCurrentUserInfo();
        if (currentUser == null) {
            SysUtil.abort();
        }
        if (LoginAuthorWayEnum.NORMAL.equals((Object)(loginWay = currentUser.getLoginAuthorWay())) || LoginAuthorWayEnum.DYNAMIC.equals((Object)loginWay)) {
            IDSecondAuthorizeHelper.checkPasswordWhenRelogin(currentUser, loginWay);
        } else if (LoginAuthorWayEnum.USBKEY.equals((Object)loginWay)) {
            IDSecondAuthorizeHelper.checkUsbPasswordWhenRelogin(currentUser);
        }
    }

    private static void checkPasswordWhenRelogin(UserInfo currentUser, LoginAuthorWayEnum loginWay) throws PermissionException {
        try {
            PasswordInputUI passwordInputUI = new PasswordInputUI(SystemEntry.instance.getOwnerFrame());
            passwordInputUI.setLoginWay(loginWay);
            passwordInputUI.show();
            if (!passwordInputUI.isLoginSuccessful()) {
                throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            SysUtil.abort();
        }
    }

    private static void checkUsbPasswordWhenRelogin(UserInfo currentUser) throws PermissionException {
        IDSecondAuthorizeHelper.getHelper().IDAuthorize(AuthorizeTypeEnum.usbAuth);
    }

    private static boolean needPasswordWhenRelogin() {
        String needPassword = null;
        try {
            needPassword = ParamManager.getParamValue(null, null, (String)"NeedPasswordRelogin");
        }
        catch (Exception e1) {
            logger.error((Object)"checkPasswordWhenRelogin", (Throwable)e1);
            return true;
        }
        return "true".equalsIgnoreCase(needPassword);
    }
}

