/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.AuthenModeFactory;
import com.kingdee.eas.base.permission.AuthenModeTypeEnum;
import com.kingdee.eas.base.permission.AuthorizeTypeEnum;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.IAuthenMode;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionManagerFactory;
import com.kingdee.eas.base.permission.client.UserListUIHelper;
import com.kingdee.eas.base.permission.client.util.CAIdentityAuthorize;
import com.kingdee.eas.base.permission.client.util.IDSecondAuthorizeHelper;
import com.kingdee.eas.base.permission.util.FunctionPermissionFilter;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public final class PermissionHelper {
    private static Logger logger = Logger.getLogger(PermissionHelper.class);
    private static Set functionSet = new HashSet();
    private static Map fieldMap = new HashMap();
    private static Map secondAuthorizeTypeMap = new HashMap();
    private static final FieldPermission FIELDPERMISSION_EMPTY = new FieldPermission();
    public static final String PERMISSION_RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    private PermissionHelper() {
    }

    public static void checkFunctionPermission(IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiMedataPK, ItemAction action, String permItemName, boolean orgExtFromCtx, Map uiContext) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)permItemName)) {
            PermissionHelper.checkFunctionPermission(userPK, orgPK, permItemName, orgExtFromCtx, uiContext);
        } else {
            PermissionHelper.checkFunctionPermission(userPK, orgPK, uiMedataPK, action, orgExtFromCtx, uiContext);
        }
    }

    private static void checkFunctionPermission(IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiMedataPK, ItemAction action, boolean orgExtFromCtx, Map uiContext) throws EASBizException, BOSException {
        if (uiMedataPK == null || action == null) {
            return;
        }
        if (userPK == null) {
            userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        }
        IMetaDataPK actionPK = null;
        if (action != null) {
            actionPK = PermissionHelper.getActionPK(action);
        }
        if (actionPK == null) {
            return;
        }
        IDSecondAuthorizeHelper idHelper = IDSecondAuthorizeHelper.getHelper();
        idHelper.setUIContext(uiContext);
        AuthorizeTypeEnum authorizeType = idHelper.IDAuthorize(uiMedataPK, actionPK);
        secondAuthorizeTypeMap.put(StringUtils.cnulls((Object)uiMedataPK) + StringUtils.cnulls((Object)actionPK), authorizeType);
        String keyStr = null;
        String bizDataId = null;
        if (action != null && action.toString().contains("$ActionEdit") && uiContext != null && uiContext.get("selectIds") != null && uiContext.get("selectIds") instanceof List) {
            List list = (List)uiContext.get("selectIds");
            if (list.size() > 0 && list.get(0) != null) {
                bizDataId = list.get(0).toString();
                keyStr = StringUtils.cnulls((Object)orgPK) + StringUtils.cnulls((Object)uiMedataPK) + StringUtils.cnulls((Object)actionPK) + orgExtFromCtx + bizDataId;
            }
        } else {
            keyStr = StringUtils.cnulls((Object)orgPK) + StringUtils.cnulls((Object)uiMedataPK) + StringUtils.cnulls((Object)actionPK) + orgExtFromCtx;
        }
        if (PermissionHelper.isContainedInFunctionSet(keyStr)) {
            return;
        }
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        iPermission.checkFunctionPermission(userPK, orgPK, uiMedataPK, actionPK, null, orgExtFromCtx);
        if (action != null && action.toString().contains("$ActionEdit") && bizDataId != null) {
            PermissionHelper.checkDataPermission(userPK, orgPK, uiMedataPK, action, (IObjectPK)new ObjectUuidPK(bizDataId));
        }
        if (orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            functionSet.add(keyStr);
        }
    }

    public static void checkIdentity(IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiMedataPK, ItemAction action, Map uiContext) throws EASBizException, BOSException {
        if (uiMedataPK == null || action == null) {
            return;
        }
        if (userPK == null) {
            userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        }
        IMetaDataPK actionPK = null;
        if (action != null) {
            actionPK = PermissionHelper.getActionPK(action);
        }
        if (actionPK == null) {
            return;
        }
        IDSecondAuthorizeHelper idHelper = IDSecondAuthorizeHelper.getHelper();
        idHelper.setUIContext(uiContext);
        AuthorizeTypeEnum authorizeType = idHelper.IDAuthorize(uiMedataPK, actionPK);
        secondAuthorizeTypeMap.put(StringUtils.cnulls((Object)uiMedataPK) + StringUtils.cnulls((Object)actionPK), authorizeType);
    }

    public static void signature(IMetaDataPK uiMedataPK, ItemAction action, String permItemName, final Map uiContext) throws EASBizException, BOSException {
        AuthorizeTypeEnum authorizeType = null;
        if (!StringUtils.isEmpty((String)permItemName)) {
            authorizeType = (AuthorizeTypeEnum)((Object)secondAuthorizeTypeMap.get(permItemName));
        } else {
            if (uiMedataPK == null || action == null) {
                logger.debug((Object)"uiMedataPK or action is null.");
                return;
            }
            IMetaDataPK actionPK = null;
            if (action != null) {
                actionPK = PermissionHelper.getActionPK(action);
            }
            if (actionPK == null) {
                logger.debug((Object)"actionPK is null.");
                return;
            }
            authorizeType = (AuthorizeTypeEnum)((Object)secondAuthorizeTypeMap.get(StringUtils.cnulls((Object)uiMedataPK) + StringUtils.cnulls((Object)actionPK)));
        }
        if (authorizeType != null) {
            logger.debug((Object)("authorizeType=" + authorizeType.getAlias()));
        } else {
            logger.debug((Object)"authorizeType is null.");
        }
        if (authorizeType != null && (20 == authorizeType.getValue() || 21 == authorizeType.getValue())) {
            if (action.getActionEvent() != null && "com.kingdee.eas.framework.client.AbstractListUI$ActionAddNew".equals(action.getActionEvent().getActionCommand())) {
                logger.info((Object)"Action event is ActionAddNew, return.");
                return;
            }
            ExecutorService executor = Executors.newCachedThreadPool();
            Future<String> future = executor.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    String result = null;
                    try {
                        CAIdentityAuthorize.saveSignature(ComponentUtil.getOwnerWindow(null), ToolUtils.getCurrentUserPK(), uiContext);
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                        result = e.getMessage();
                    }
                    return result;
                }
            });
            executor.shutdown();
            try {
                String result = future.get();
                if (result != null) {
                    MsgBox.showError((String)result);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    private static void checkFunctionPermission(IObjectPK userPK, IObjectPK orgPK, String permItemName, boolean orgExtFromCtx, Map uiContext) throws EASBizException, BOSException {
        if (permItemName == null) {
            return;
        }
        if (userPK == null) {
            userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        }
        IDSecondAuthorizeHelper idHelper = IDSecondAuthorizeHelper.getHelper();
        idHelper.setUIContext(uiContext);
        AuthorizeTypeEnum authorizeType = idHelper.IDAuthorize(permItemName);
        secondAuthorizeTypeMap.put(permItemName, authorizeType);
        String keyStr = StringUtils.cnulls((Object)orgPK) + StringUtils.cnulls((String)permItemName) + orgExtFromCtx;
        if (PermissionHelper.isContainedInFunctionSet(keyStr)) {
            return;
        }
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        iPermission.checkFunctionPermission(userPK, orgPK, null, null, permItemName, orgExtFromCtx);
        if (orgPK != null && !StringUtils.isEmpty((String)orgPK.toString())) {
            functionSet.add(keyStr);
        }
    }

    private static void checkFunctionPermission(IObjectPK userPK, IObjectPK orgPK, String permItemName, boolean orgExtFromCtx) throws EASBizException, BOSException {
        PermissionHelper.checkFunctionPermission(userPK, orgPK, permItemName, orgExtFromCtx, null);
    }

    public static void checkFunctionPermission(IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiMedataPK, ItemAction action) throws EASBizException, BOSException {
        PermissionHelper.checkFunctionPermission(userPK, orgPK, uiMedataPK, action, true);
    }

    public static void checkFunctionPermission(IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiMedataPK, ItemAction action, String permItemName, boolean orgExtFromCtx) throws EASBizException, BOSException {
        PermissionHelper.checkFunctionPermission(userPK, orgPK, uiMedataPK, action, permItemName, orgExtFromCtx, null);
    }

    private static void checkFunctionPermission(IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiMedataPK, ItemAction action, boolean orgExtFromCtx) throws EASBizException, BOSException {
        PermissionHelper.checkFunctionPermission(userPK, orgPK, uiMedataPK, action, orgExtFromCtx, null);
    }

    private static boolean isContainedInFunctionSet(String keyStr) {
        if (FunctionPermissionFilter.getFilter().isCanIgnore(keyStr)) {
            return true;
        }
        return functionSet.contains(keyStr);
    }

    public static void checkFunctionPermission(IObjectPK userPK, IObjectPK orgPK, String permItemName) throws EASBizException, BOSException {
        PermissionHelper.checkFunctionPermission(userPK, orgPK, permItemName, true);
    }

    public static void checkDataPermission(IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiMedataPK, ItemAction action, IObjectPK bizDataPK) throws EASBizException, BOSException {
        if (uiMedataPK == null || action == null) {
            return;
        }
        if (userPK == null) {
            userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        }
        IMetaDataPK actionPK = null;
        if (action != null) {
            actionPK = PermissionHelper.getActionPK(action);
        }
        if (actionPK == null) {
            return;
        }
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        iPermission.checkDataPermission(userPK, orgPK, uiMedataPK, actionPK, bizDataPK);
    }

    public static void checkDataPermission(IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiMedataPK, ItemAction action, IObjectValue bizData) throws EASBizException, BOSException {
        if (uiMedataPK == null || action == null) {
            return;
        }
        if (userPK == null) {
            userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        }
        IMetaDataPK actionPK = null;
        if (action != null) {
            actionPK = PermissionHelper.getActionPK(action);
        }
        if (actionPK == null) {
            return;
        }
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        iPermission.checkDataPermission(userPK, orgPK, uiMedataPK, actionPK, bizData);
    }

    public static Map getAuthorizedOrgs(IObjectPK ctrlUnitPK, IObjectPK userPK, OrgType orgType, IMetaDataPK uiMedataPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        assert (userPK != null && ctrlUnitPK != null);
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        Map result = iPermission.getAuthorizedOrgs(ctrlUnitPK, userPK, orgType, uiMedataPK, actionPK);
        endTime = lowTimer.msValue();
        logger.info((Object)("getAuthorizedOrgs  " + (endTime - beginTime)));
        return result;
    }

    public static Map getAuthorizedOrgs(IObjectPK ctrlUnitPK, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, IMetaDataPK uiMedataPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        assert (userPK != null && ctrlUnitPK != null);
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        Map result = iPermission.getAuthorizedOrgs(ctrlUnitPK, userPK, orgType, orgTreePK, uiMedataPK, actionPK);
        return result;
    }

    public static Map getAuthorizedOrg(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        FullOrgUnitCollection collection = iPermission.getAuthorizedOrg(userPK, orgType, orgTreePK, uiPK, actionPK);
        return PermissionHelper.transformToMap(collection);
    }

    public static Map getAuthorizedOrg(IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, String permItemName) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        FullOrgUnitCollection collection = iPermission.getAuthorizedOrg(userPK, orgType, orgTreePK, permItemName);
        return PermissionHelper.transformToMap(collection);
    }

    public static Map getAuthorizedOrgOfIncludeSubCU(IObjectPK ctrlUnitPK, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        FullOrgUnitCollection collection = iPermission.getAuthorizedOrgOfIncludeSubCU(ctrlUnitPK, userPK, orgType, orgTreePK, uiPK, actionPK);
        return PermissionHelper.transformToMap(collection);
    }

    public static Map getAuthorizedOrgOfIncludeSubCU(IObjectPK ctrlUnitPK, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, String permItemName) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        FullOrgUnitCollection collection = iPermission.getAuthorizedOrgOfIncludeSubCU(ctrlUnitPK, userPK, orgType, orgTreePK, permItemName);
        return PermissionHelper.transformToMap(collection);
    }

    public static Map getAuthorizedOrgOfCU(IObjectPK ctrlUnitPK, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        FullOrgUnitCollection collection = iPermission.getAuthorizedOrgOfCU(ctrlUnitPK, userPK, orgType, orgTreePK, uiPK, actionPK);
        return PermissionHelper.transformToMap(collection);
    }

    public static Map getAuthorizedOrgOfCU(IObjectPK ctrlUnitPK, IObjectPK userPK, OrgType orgType, IObjectPK orgTreePK, String permItemName) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        FullOrgUnitCollection collection = iPermission.getAuthorizedOrgOfCU(ctrlUnitPK, userPK, orgType, orgTreePK, permItemName);
        return PermissionHelper.transformToMap(collection);
    }

    private static Map transformToMap(FullOrgUnitCollection collection) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            result.put(collection.get(i).getId().toString(), Boolean.FALSE);
        }
        return result;
    }

    private static IMetaDataPK getActionPK(ItemAction action) {
        assert (action != null);
        String actionName = action.getActionName();
        if (StringUtils.isEmpty((String)actionName) && (actionName = action.getClass().getName()).indexOf("$") >= 0) {
            actionName = actionName.substring(actionName.indexOf("$") + 1);
        }
        return new MetaDataPK(actionName);
    }

    public static FieldPermission getFieldPermission(BOSObjectType bizObjectType, IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        String keyStr = StringUtils.cnulls((Object)bizObjectType) + StringUtils.cnulls((Object)orgPK);
        FieldPermission retFieldPermission = null;
        if (fieldMap.containsKey(keyStr)) {
            retFieldPermission = (FieldPermission)fieldMap.get(keyStr);
        } else {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            FieldPermission fieldPermission = iPermission.getFieldPermission(bizObjectType, userPK, orgPK);
            retFieldPermission = PermissionHelper.insertCache(keyStr, fieldPermission);
        }
        return (FieldPermission)retFieldPermission.clone();
    }

    private static FieldPermission insertCache(String keyStr, FieldPermission fieldPermission) {
        if (fieldPermission == null || fieldPermission.isEmpty()) {
            fieldMap.put(keyStr, FIELDPERMISSION_EMPTY);
        } else {
            fieldMap.put(keyStr, fieldPermission);
        }
        return (FieldPermission)fieldMap.get(keyStr);
    }

    public static FieldPermission getQueryFieldPermission(IMetaDataPK queryPK, IObjectPK userPK, IObjectPK orgPK) throws BOSException, EASBizException {
        String keyStr = StringUtils.cnulls((Object)queryPK) + StringUtils.cnulls((Object)orgPK);
        FieldPermission retFieldPermission = null;
        if (fieldMap.containsKey(keyStr)) {
            retFieldPermission = (FieldPermission)fieldMap.get(keyStr);
        } else {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            FieldPermission fieldPermission = iPermission.getQueryFieldPermission(queryPK, userPK, orgPK);
            retFieldPermission = PermissionHelper.insertCache(keyStr, fieldPermission);
        }
        return (FieldPermission)retFieldPermission.clone();
    }

    public static Map getQueryFieldPermission(IMetaDataPK queryPK, IObjectPK userPK, List orgIdStrList) throws BOSException, EASBizException {
        HashMap<String, FieldPermission> retMap = new HashMap<String, FieldPermission>();
        ArrayList<String> notCacheOrgList = new ArrayList<String>();
        for (int i = 0; i < orgIdStrList.size(); ++i) {
            String orgIdStr = (String)orgIdStrList.get(i);
            String keyStr = StringUtils.cnulls((Object)queryPK) + StringUtils.cnulls((String)orgIdStr);
            if (fieldMap.containsKey(keyStr)) {
                retMap.put(StringUtils.cnulls((String)orgIdStr), (FieldPermission)fieldMap.get(keyStr));
                continue;
            }
            notCacheOrgList.add(orgIdStr);
        }
        if (notCacheOrgList != null && !notCacheOrgList.isEmpty()) {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            Map fieldPermissionMap = iPermission.getQueryFieldPermission(queryPK, userPK, notCacheOrgList);
            retMap.putAll(fieldPermissionMap);
            Set keySet = fieldPermissionMap.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                String orgIdStr = StringUtils.cnulls((String)it.next().toString());
                fieldMap.put(StringUtils.cnulls((Object)queryPK) + orgIdStr, (FieldPermission)fieldPermissionMap.get(orgIdStr));
            }
        }
        return retMap;
    }

    public static void cleanCache() {
        logger.info((Object)"..... clean permission cache!");
        functionSet.clear();
        fieldMap.clear();
        UserListUIHelper.clearCache();
    }

    public static boolean isAuthenticateAdminEnabled() {
        try {
            IAuthenMode iAuthenMode = AuthenModeFactory.getRemoteInstance();
            return iAuthenMode.isEnabledAuthenticadeAdmin();
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Deprecated
    public static void alertNeedAuthen(Component owner, String userNames) throws BOSException {
        String msg;
        boolean isEnabledAuthen = AuthenModeFactory.getRemoteInstance().isEnabled(AuthenModeTypeEnum.UserPermChangeAuthen);
        if (isEnabledAuthen && MsgBox.showConfirm2((Component)owner, (String)(msg = MessageFormat.format(EASResource.getString((String)PERMISSION_RESOURCE, (String)"ROLE_WILL_NEED_AUTHEN"), userNames))) == 2) {
            SysUtil.abort();
        }
    }

    public static void alertNeedAuthen(Component owner, List roleIdList) throws Exception {
        String msg;
        boolean isIncludeAuthenPerms;
        String roleIdsStr = ToolUtils.aryToStr(roleIdList);
        boolean isEnabledAuthen = AuthenModeFactory.getRemoteInstance().isEnabled(AuthenModeTypeEnum.UserPermChangeAuthen);
        if (isEnabledAuthen && (isIncludeAuthenPerms = PermissionManagerFactory.getRemoteInstance().isRoleIncludeAuthenPerms(roleIdsStr)) && MsgBox.showConfirm2((Component)owner, (String)(msg = MessageFormat.format(EASResource.getString((String)PERMISSION_RESOURCE, (String)"ROLE_WILL_NEED_AUTHEN"), null))) == 2) {
            SysUtil.abort();
        }
    }

    public static void alertRoleNeedAuthen(Component owner, List<String> accOrgIdList, List accRoleIdList, List<String> grantOrgIdList, List grantRoleIdList) {
        String msg;
        boolean isEnabledAuthen = false;
        try {
            if (PermissionHelper.isNotEmptyCollection(accRoleIdList) && PermissionHelper.isNotEmptyCollection(accOrgIdList)) {
                boolean bl = isEnabledAuthen = isEnabledAuthen || AuthenModeFactory.getRemoteInstance().isEnableRoleAuthen(accRoleIdList, accOrgIdList);
            }
            if (PermissionHelper.isNotEmptyCollection(grantRoleIdList) && PermissionHelper.isNotEmptyCollection(grantOrgIdList)) {
                isEnabledAuthen = isEnabledAuthen || AuthenModeFactory.getRemoteInstance().isEnableRoleAuthen(grantRoleIdList, grantOrgIdList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (isEnabledAuthen && MsgBox.showConfirm2((Component)owner, (String)(msg = EASResource.getString((String)PERMISSION_RESOURCE, (String)"ROLE_WILL_NEED_AUTHEN"))) == 2) {
            SysUtil.abort();
        }
    }

    public static void alertPermNeedAuthen(Component owner, List<String> accOrgIdList, List<String> accPermIdList, List<String> grantOrgIdList, List<String> grantPermIdList) {
        String msg;
        boolean isEnabledAuthen = false;
        try {
            if (PermissionHelper.isNotEmptyCollection(accPermIdList) && PermissionHelper.isNotEmptyCollection(accOrgIdList)) {
                boolean bl = isEnabledAuthen = isEnabledAuthen || AuthenModeFactory.getRemoteInstance().isEnablePermAuthen(accPermIdList, accOrgIdList);
            }
            if (PermissionHelper.isNotEmptyCollection(grantPermIdList) && PermissionHelper.isNotEmptyCollection(grantOrgIdList)) {
                isEnabledAuthen = isEnabledAuthen || AuthenModeFactory.getRemoteInstance().isEnablePermAuthen(grantPermIdList, grantOrgIdList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (isEnabledAuthen && MsgBox.showConfirm2((Component)owner, (String)(msg = EASResource.getString((String)PERMISSION_RESOURCE, (String)"USER_WILL_NEED_AUTHEN"))) == 2) {
            SysUtil.abort();
        }
    }

    private static boolean isNotEmptyCollection(Collection collection) {
        return collection != null && !collection.isEmpty();
    }

    public static List<String> getPkIds(List objs) {
        ArrayList<String> pks = new ArrayList<String>();
        for (Object obj : objs) {
            if (obj instanceof ObjectBaseInfo) {
                ObjectBaseInfo info = (ObjectBaseInfo)obj;
                pks.add(info.getId().toString());
                continue;
            }
            pks.add(obj.toString());
        }
        return pks;
    }
}

