/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IRule;
import com.kingdee.eas.base.permission.LeftBracketToken;
import com.kingdee.eas.base.permission.LogicToken;
import com.kingdee.eas.base.permission.RightBracketToken;
import com.kingdee.eas.base.permission.RuleCollection;
import com.kingdee.eas.base.permission.RuleFactory;
import com.kingdee.eas.base.permission.RuleInfo;
import com.kingdee.eas.base.permission.RuleUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;

public class RuleSelectUtils {
    public static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    public static final int RULE_INDEX = 0;
    public static final int LEFT_BRACKET_INDEX = 1;
    public static final int RULE_NUMBER = 2;
    public static final int RULE_NAME = 3;
    public static final int RIGHT_BRACKET_INDEX = 4;
    public static final int LOGIC_INDEX = 5;
    private KDTable kdTable = null;

    public RuleSelectUtils(KDTable kdTable) {
        this.kdTable = kdTable;
    }

    private void initTable() {
        this.kdTable.checkParsed();
        KDComboBox leftComboBox = new KDComboBox(RuleUtil.addObjectToArray(LeftBracketToken.getEnumList().toArray(), null));
        KDTDefaultCellEditor leftBracketEditor = new KDTDefaultCellEditor((JComboBox)leftComboBox);
        this.kdTable.getColumn("leftBracket").setEditor((ICellEditor)leftBracketEditor);
        KDComboBox rightComboBox = new KDComboBox(RuleUtil.addObjectToArray(RightBracketToken.getEnumList().toArray(), null));
        KDTDefaultCellEditor rightBracketEditor = new KDTDefaultCellEditor((JComboBox)rightComboBox);
        this.kdTable.getColumn("rightBracket").setEditor((ICellEditor)rightBracketEditor);
        KDComboBox logicComboBox = new KDComboBox(RuleUtil.addObjectToArray(LogicToken.getEnumList().toArray(), null));
        KDTDefaultCellEditor logicEditor = new KDTDefaultCellEditor((JComboBox)logicComboBox);
        this.kdTable.getColumn("logic").setEditor((ICellEditor)logicEditor);
        this.kdTable.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
    }

    private RuleCollection getRules(String ruleStructure) throws BOSException {
        HashSet<String> ruleIDs = new HashSet<String>();
        String[] temps = StringUtils.split((String)ruleStructure, (String)" ");
        if (temps != null) {
            int length = temps.length;
            for (int i = 0; i < length; ++i) {
                if (!RuleUtil.isRuleID(temps[i])) continue;
                ruleIDs.add(temps[i]);
            }
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (ruleIDs.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", ruleIDs, CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            IRule iRule = RuleFactory.getRemoteInstance();
            return iRule.getRuleCollection(entityViewInfo);
        }
        return null;
    }

    public void loadRules(String ruleStructure) throws Exception, ParserException, BOSException {
        this.initTable();
        this.kdTable.removeRows();
        ArrayList ruleRows = this.getRuleRows(ruleStructure);
        int size = ruleRows.size();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdTable.addRow();
            Object[] ruleRow = (Object[])ruleRows.get(i);
            if (ruleRow[0] == null && i != 0) {
                this.kdTable.getMergeManager().mergeBlock(i, 0, i, 5);
                row.getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                row.getCell(0).setValue((Object)EASResource.getString((String)RESOURCE, (String)"entryRuleSep"));
                continue;
            }
            row.getCell(0).setValue(ruleRow[0]);
            row.getCell(1).setValue(ruleRow[1]);
            row.getCell(2).setValue(ruleRow[2]);
            row.getCell(3).setValue(ruleRow[3]);
            row.getCell(4).setValue(ruleRow[4]);
            row.getCell(5).setValue(ruleRow[5]);
        }
    }

    private ArrayList getRuleRows(String ruleStructure) throws EASBizException, ParserException, BOSException {
        RuleCollection ruleCollection = this.getRules(ruleStructure);
        ArrayList<Object[]> ruleRows = new ArrayList<Object[]>();
        String[] strs = StringUtils.split((String)ruleStructure, (String)" ");
        int nearlyRuleIDEndPos = 0;
        for (String str : strs) {
            if (!RuleUtil.isRuleID(str)) continue;
            String ruleID = str;
            RuleInfo ruleInfo = ruleCollection.get(BOSUuid.read((String)ruleID));
            Object[] ruleRow = new Object[6];
            ruleRow[0] = ruleInfo;
            ruleRow[2] = ruleInfo.getNumber();
            ruleRow[3] = ruleInfo.getName();
            ruleRow[1] = this.getLeftBracket(ruleStructure, ruleID, nearlyRuleIDEndPos);
            ruleRow[4] = this.getRightBracket(ruleStructure, ruleID, nearlyRuleIDEndPos);
            ruleRow[5] = this.getLogic(ruleStructure, ruleID, nearlyRuleIDEndPos);
            ruleRows.add(ruleRow);
            nearlyRuleIDEndPos = ruleStructure.indexOf(ruleID, nearlyRuleIDEndPos) + ruleID.length();
        }
        return ruleRows;
    }

    private LeftBracketToken getLeftBracket(String ruleStructure, String ruleID, int nearlyRuleIDEndPos) {
        int beginIndex = ruleStructure.indexOf(ruleID, nearlyRuleIDEndPos);
        String str = ruleStructure.substring(nearlyRuleIDEndPos, beginIndex);
        for (String temp : StringUtils.split((String)str, (String)" ")) {
            if (LeftBracketToken.getEnum(temp) == null) continue;
            return LeftBracketToken.getEnum(temp);
        }
        return null;
    }

    private RightBracketToken getRightBracket(String ruleStructure, String ruleID, int nearlyRuleIDEndPos) {
        String str = ruleStructure.substring(nearlyRuleIDEndPos);
        int beginIndex = str.indexOf(ruleID) + ruleID.length();
        int endIndex = -1;
        str = str.substring(beginIndex);
        for (String temp : StringUtils.split((String)str, (String)" ")) {
            if (!RuleUtil.isRuleID(temp)) continue;
            endIndex = str.indexOf(temp);
            break;
        }
        str = str.substring(0, endIndex == -1 ? str.length() : endIndex);
        for (String temp : StringUtils.split((String)str, (String)" ")) {
            if (RightBracketToken.getEnum(temp) == null) continue;
            return RightBracketToken.getEnum(temp);
        }
        return null;
    }

    private LogicToken getLogic(String ruleStructure, String ruleID, int nearlyRuleIDEndPos) {
        String str = ruleStructure.substring(nearlyRuleIDEndPos);
        int beginIndex = str.indexOf(ruleID) + ruleID.length();
        int endIndex = -1;
        str = str.substring(beginIndex);
        for (String temp : StringUtils.split((String)str, (String)" ")) {
            if (!RuleUtil.isRuleID(temp)) continue;
            endIndex = str.indexOf(temp);
            break;
        }
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        str = str.substring(0, endIndex == -1 ? str.length() - 1 : endIndex);
        for (String temp : StringUtils.split((String)str, (String)" ")) {
            if (LogicToken.getEnum(temp) == null) continue;
            return LogicToken.getEnum(temp);
        }
        return null;
    }
}

