/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermissionManager;
import com.kingdee.eas.base.permission.IUserOrgPerm;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionManagerFactory;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermFactory;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.client.UserBatchUI;
import com.kingdee.eas.base.permission.client.tree.IAccreditTreeBuilder;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.util.LowTimer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class TreeHelper {
    private static final Logger logger = CoreUIObject.getLogger(UserBatchUI.class);
    private IAccreditTreeBuilder builder = null;
    private KDTreeNode branch = null;
    private IObjectPK curUserPK;
    private IObjectPK curOrgPK;
    private UserOrgPermCollection uopsCopy = null;
    public static final int AUTHORIZATION_INDEX = 0;
    public static final int NORMAL_INDEX = 1;
    public static final int FORBIDDEN_INDEX = 2;
    protected KDTree treeAuthorizedPerm;
    protected KDTree treeNormalPerm;
    protected KDTree treeForbiddenPerm;
    protected KDTree treeSourcePerm;

    private IUserOrgPerm getBizInterface() throws BOSException {
        return UserOrgPermFactory.getRemoteInstance();
    }

    public void buildSourceTree(KDTree treeSourcePerm) throws Exception {
        this.buildSourceTreeByParam(treeSourcePerm, null);
    }

    public void buildSourceTreeByParam(KDTree treeSourcePerm, PermItemCollection permItemCol) throws Exception {
        UserOrgPermCollection userOrgPerms = null;
        if (permItemCol != null) {
            userOrgPerms = new UserOrgPermCollection();
            int size = permItemCol.size();
            for (int i = 0; i < size; ++i) {
                UserOrgPermInfo userOrgPermInfo = new UserOrgPermInfo();
                userOrgPermInfo.setPermItem(permItemCol.get(i));
                userOrgPerms.add(userOrgPermInfo);
            }
        } else {
            userOrgPerms = this.getBizInterface().getSourcePerms(this.curUserPK, this.curOrgPK);
        }
        if (userOrgPerms != null) {
            logger.info((Object)("........ size is:" + userOrgPerms.size()));
        }
        KDTreeNode root = this.builder.buildTreeRoot(this.branch, (IObjectCollection)userOrgPerms);
        ((DefaultTreeModel)treeSourcePerm.getModel()).setRoot((TreeNode)root);
        this.decorateSourceTree(treeSourcePerm);
    }

    public void buildSourceTree(KDTree treeSourcePerm, UserOrgPermCollection userOrgPerms) throws Exception {
        KDTreeNode root = this.builder.buildTreeRoot(this.branch, (IObjectCollection)userOrgPerms);
        ((DefaultTreeModel)treeSourcePerm.getModel()).setRoot((TreeNode)root);
        this.decorateSourceTree(treeSourcePerm);
    }

    public void buildTargetTree(IObjectPK targetUserPK) throws Exception {
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        IUserOrgPerm iUserOrgPerm = UserOrgPermFactory.getRemoteInstance();
        UserOrgPermCollection userOrgPerms = iUserOrgPerm.getTargetPerms(this.curUserPK, targetUserPK, this.curOrgPK);
        endTime = lowTimer.msValue();
        logger.debug((Object)("getTargetPerms()  " + (endTime - beginTime)));
        beginTime = lowTimer.msValue();
        this.uopsCopy = (UserOrgPermCollection)((Object)userOrgPerms.clone());
        endTime = lowTimer.msValue();
        logger.debug((Object)("userOrgPerms.clone()  " + (endTime - beginTime)));
        ArrayList list = PermissionCommonUtil.assortPerms(userOrgPerms);
        this.buildAuthorizationTree((UserOrgPermCollection)((Object)list.get(0)));
        this.buildNormalTree((UserOrgPermCollection)((Object)list.get(1)));
        this.buildForbiddenTree((UserOrgPermCollection)((Object)list.get(2)));
    }

    private void buildAuthorizationTree(UserOrgPermCollection userOrgPerms) throws Exception {
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        KDTreeNode root = this.builder.buildTreeRoot(this.branch, (IObjectCollection)userOrgPerms);
        ((DefaultTreeModel)this.treeAuthorizedPerm.getModel()).setRoot((TreeNode)root);
        endTime = lowTimer.msValue();
        logger.debug((Object)("buildAuthorizationTree()  " + (endTime - beginTime)));
    }

    private void buildNormalTree(UserOrgPermCollection userOrgPerms) throws Exception {
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        KDTreeNode root = this.builder.buildTreeRoot(this.branch, (IObjectCollection)userOrgPerms);
        ((DefaultTreeModel)this.treeNormalPerm.getModel()).setRoot((TreeNode)root);
        this.builder.setDataRuleIcon(root);
        endTime = lowTimer.msValue();
        logger.debug((Object)("buildNormalTree()  " + (endTime - beginTime)));
    }

    private void buildForbiddenTree(UserOrgPermCollection userOrgPerms) throws Exception {
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        KDTreeNode root = this.builder.buildTreeRoot(this.branch, (IObjectCollection)userOrgPerms);
        ((DefaultTreeModel)this.treeForbiddenPerm.getModel()).setRoot((TreeNode)root);
        this.builder.setForbiddenIcon(root);
        endTime = lowTimer.msValue();
        logger.debug((Object)("buildForbiddenTree()  " + (endTime - beginTime)));
    }

    public TreeHelper(IObjectPK userPK, IObjectPK orgPK, IAccreditTreeBuilder builder) throws Exception {
        this.builder = builder;
        try {
            this.branch = builder.createTreeBranch();
            this.curUserPK = userPK;
            this.curOrgPK = orgPK;
            this.treeAuthorizedPerm = new KDTree();
            this.treeAuthorizedPerm.setName("treeAuthorizedPerm");
            this.treeNormalPerm = new KDTree();
            this.treeNormalPerm.setName("treeNormalPerm");
            this.treeForbiddenPerm = new KDTree();
            this.treeForbiddenPerm.setName("treeForbiddenPerm");
            this.treeSourcePerm = new KDTree();
            this.treeSourcePerm.setName("treeSourcePerm");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
    }

    private void decorateSourceTree(KDTree treeSourcePerm) throws EASBizException, BOSException {
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        if (treeSourcePerm != null && treeSourcePerm.getModel() != null && treeSourcePerm.getModel().getRoot() != null) {
            try {
                IPermissionManager iPermissionManager = PermissionManagerFactory.getRemoteInstance();
                UserOrgPermCollection uops = (UserOrgPermCollection)iPermissionManager.getAllPerms(this.curUserPK, this.curOrgPK);
                HashSet<BOSUuid> setUOPs = new HashSet<BOSUuid>();
                int size = uops.size();
                for (int i = 0; i < size; ++i) {
                    setUOPs.add(uops.get(i).getPermItem().getId());
                }
                Enumeration enumeration = ((KDTreeNode)treeSourcePerm.getModel().getRoot()).breadthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    UserOrgPermInfo uop;
                    KDTreeNode node = (KDTreeNode)enumeration.nextElement();
                    this.builder.setDefaultIcon(node);
                    if (node.isLeaf() && !setUOPs.contains((uop = (UserOrgPermInfo)node.getUserObject()).getPermItem().getId())) continue;
                }
                treeSourcePerm.repaint();
                endTime = lowTimer.msValue();
                logger.debug((Object)("decorateSourceTree()  " + (endTime - beginTime)));
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
    }

    public void setIcon2Tree(KDTreeNode tree, int iconType) {
        if (0 != iconType) {
            if (1 == iconType) {
                this.builder.setDataRuleIcon(tree);
            } else if (2 == iconType) {
                this.builder.setForbiddenIcon(tree);
            } else {
                throw new IllegalArgumentException("error iconType ! iconType is :" + iconType);
            }
        }
    }

    public KDTree getTreeAuthorizedPerm() {
        return this.treeAuthorizedPerm;
    }

    public KDTree getTreeForbiddenPerm() {
        return this.treeForbiddenPerm;
    }

    public KDTree getTreeNormalPerm() {
        return this.treeNormalPerm;
    }

    public KDTree getTreeSourcePerm() {
        return this.treeSourcePerm;
    }
}

