/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.numbersign.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.orm.trace.compatible.ProxyObjectFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.INumberSign;
import com.kingdee.eas.base.permission.NumberSignCollection;
import com.kingdee.eas.base.permission.NumberSignException;
import com.kingdee.eas.base.permission.NumberSignFactory;
import com.kingdee.eas.base.permission.NumberSignInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.numbersign.BatchSignInfo;
import com.kingdee.eas.base.permission.numbersign.NumberImageSignService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;

public class WebSignFacade {
    private Context ctx;
    private static final Logger logger = CoreUIObject.getLogger(WebSignFacade.class);

    public WebSignFacade(Context ctx) {
        this.ctx = ctx;
    }

    public String verifyCert(String certContent) {
        logger.info((Object)(" begin verify cert : param is:" + certContent));
        NumberImageSignService numberService = new NumberImageSignService();
        try {
            numberService.checkCurUserRight(this.ctx, certContent);
            logger.info((Object)"begin verify cert ok!");
            return Boolean.TRUE.toString();
        }
        catch (NumberSignException e) {
            logger.error((Object)"error", (Throwable)((Object)e));
            logger.info((Object)"begin verify cert fail!");
            return Boolean.FALSE.toString();
        }
    }

    public String getProtectedData(String signIdStr, String boId) {
        try {
            logger.info((Object)("getProtectedData begin ,param is:" + boId));
            if (boId == null || StringUtils.isEmpty((String)boId)) {
                throw new IllegalArgumentException("boid is null");
            }
            String[] boIdAry = boId.split(";");
            String[] signIdStrAry = signIdStr.split(";");
            NumberImageSignService numberService = new NumberImageSignService();
            if (boIdAry.length == 1) {
                IObjectValue obInfo = ProxyObjectFactory.getLocalInstance((Context)this.ctx).getValue(BOSUuid.read((String)boId).getType(), (IObjectPK)new ObjectStringPK(boId));
                return numberService.getProtectInfo(this.ctx, obInfo);
            }
            String oqlStr = "select id where id in (" + ToolUtils.aryToStr((String[])boIdAry) + ")";
            IObjectCollection iOC = ProxyObjectFactory.getLocalInstance((Context)this.ctx).getCollection(BOSUuid.read((String)boIdAry[0]).getType(), oqlStr);
            HashMap<String, IObjectValue> valueMap = new HashMap<String, IObjectValue>();
            for (int i = 0; i < iOC.size(); ++i) {
                IObjectValue iVo = iOC.getObject(i);
                valueMap.put(iVo.get(iVo.getPKField()).toString(), iVo);
            }
            String batchProtectedDataInfoStr = "";
            ArrayList<BatchSignInfo> batchSignList = new ArrayList<BatchSignInfo>();
            for (int i = 0; i < boIdAry.length; ++i) {
                BatchSignInfo batchSignInfo = new BatchSignInfo();
                IObjectValue iVo = (IObjectValue)valueMap.get(boIdAry[i]);
                batchSignInfo.setIVo(iVo);
                NumberSignInfo numberInfo = new NumberSignInfo();
                numberInfo.setId(BOSUuid.read((String)signIdStrAry[i]));
                batchSignInfo.setNumberSignInfo(numberInfo);
                batchSignList.add(batchSignInfo);
                batchProtectedDataInfoStr = batchProtectedDataInfoStr + numberService.getProtectInfo(this.ctx, iVo);
            }
            String retStr = numberService.getBatchProtectInfo(this.ctx, batchSignList);
            logger.info((Object)("getProtectedData begin ,res:" + retStr));
            return retStr;
        }
        catch (BOSException e) {
            logger.error((Object)"error", (Throwable)e);
            return "";
        }
        catch (UuidException e) {
            logger.error((Object)"error", (Throwable)e);
            return "";
        }
        catch (EASBizException e) {
            logger.error((Object)"error", (Throwable)e);
            return "";
        }
    }

    public String getNewSignId(String boId) {
        if (StringUtils.isEmpty((String)boId)) {
            throw new IllegalArgumentException("boId is not right , is null or empty!");
        }
        String[] boIdAry = boId.split(";");
        String retSignIdStr = "";
        for (int i = 0; i < boIdAry.length; ++i) {
            String newSignId = BOSUuid.create((BOSObjectType)new NumberSignInfo().getBOSType()).toString();
            retSignIdStr = retSignIdStr + ";" + newSignId;
        }
        if (retSignIdStr.startsWith(";")) {
            retSignIdStr = retSignIdStr.substring(1);
        }
        return retSignIdStr;
    }

    public String saveDigitalSign(String signId, String boid, String signPicStr, String flowInstanceId, String activeInstanceId, String taskId, String longnumber) {
        logger.info((Object)(" saveDigitalSign begin ,signId is:" + signId + " boId is:" + boid + " signPicStr is:" + signPicStr));
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        String[] signIdAry = signId.split(";");
        String[] boIdAry = boid.split(";");
        String[] signPicStrAry = signPicStr.split(";");
        String[] flowInstanceIdAry = flowInstanceId.split(";");
        String[] activeInstanceIdAry = activeInstanceId.split(";");
        String[] taskIdAry = taskId.split(";");
        String[] longnumberAry = longnumber.split(";");
        NumberSignCollection numberCol = new NumberSignCollection();
        BASE64Decoder base = new BASE64Decoder();
        for (int i = 0; i < signIdAry.length; ++i) {
            NumberSignInfo numberInfo = new NumberSignInfo();
            numberInfo.setBoId(boIdAry[i]);
            numberInfo.setId(BOSUuid.read((String)signIdAry[i]));
            numberInfo.setFlowInstanceId(flowInstanceIdAry[i]);
            numberInfo.setActiveInstanceId(activeInstanceIdAry[i]);
            numberInfo.setTaskId(taskIdAry[i]);
            numberInfo.setLongnumber(longnumberAry[i]);
            if (userInfo != null) {
                numberInfo.setUserId(userInfo);
            }
            try {
                numberInfo.setSignInfo(base.decodeBuffer(signPicStrAry[i]));
            }
            catch (Exception e) {
                logger.error((Object)"permission error!", (Throwable)e);
                return Boolean.FALSE.toString();
            }
            numberCol.add(numberInfo);
        }
        try {
            INumberSign iNumberSign = this.ctx == null ? NumberSignFactory.getRemoteInstance() : NumberSignFactory.getLocalInstance(this.ctx);
            iNumberSign.addnew(numberCol);
            logger.info((Object)" saveDigitalSign ok!");
        }
        catch (EASBizException e) {
            logger.error((Object)"error!", (Throwable)e);
            return Boolean.FALSE.toString();
        }
        catch (BOSException e) {
            logger.error((Object)"error!", (Throwable)e);
            return Boolean.FALSE.toString();
        }
        return Boolean.TRUE.toString();
    }
}

