/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.service.helper;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.eas.base.permission.IServerConfigFileCache;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.ServerConfigFileFactory;
import com.kingdee.eas.base.permission.UsbKeyException;
import com.kingdee.eas.base.permission.service.helper.UsbKeyCtxHelper;
import com.kingdee.eas.base.permission.service.helper.UsbKeyProxy;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class UsbKeyPermissionServiceHelper {
    private Logger logger = Logger.getLogger(UsbKeyPermissionServiceHelper.class);

    public void checkUsbKeyPermission() throws PermissionException {
        this.checkUsbKeyPermission(null);
    }

    public void checkUsbKeyPermission(Context ctx) throws PermissionException {
        String userId = "";
        userId = ctx != null ? ctx.getCaller().toString() : ToolUtils.getCurrentUserPK().toString();
        this.checkUsbKeyPermission(ctx, userId);
    }

    public void checkUsbKeyPermission(Context ctx, String userId) throws PermissionException {
        if (UsbKeyCtxHelper.isNeedUsbKeyPerm()) {
            return;
        }
        String serverStr = this.readFileContentFromServer(ctx);
        if (StringUtils.isEmpty((String)serverStr)) {
            return;
        }
        this.compareContent2UsbKey(userId, serverStr);
    }

    public void compareContent2UsbKey(String userId, String serverStr) throws PermissionException {
        String oldServerStr = "";
        String oldServerEncrptStr = "";
        int readSize = 0;
        try {
            oldServerStr = CryptoTean.decrypt((String)"", (String)serverStr);
            oldServerEncrptStr = CryptoTean.encrypt((String)"", (String)(userId + oldServerStr));
            readSize = oldServerEncrptStr.length();
        }
        catch (CryptException e1) {
            this.logger.error((Object)"", (Throwable)e1);
            throw new UsbKeyException(UsbKeyException.USBKEY_CHECKPERM_FAIL);
        }
        UsbKeyProxy usbKeyProxy = new UsbKeyProxy();
        String usbContent = usbKeyProxy.read(readSize);
        if (usbContent == null) {
            this.logger.error((Object)"usb content is null!");
            throw new UsbKeyException(UsbKeyException.USBKEY_CHECKPERM_FAIL);
        }
        if (!oldServerEncrptStr.equals(usbContent)) {
            this.logger.error((Object)("usbKey and oldServerEncrptStr is not same! oldServerEncrptStr is:" + oldServerEncrptStr + "   usbContent is:" + usbContent));
            throw new UsbKeyException(UsbKeyException.USBKEY_CHECKPERM_FAIL);
        }
    }

    private String readFileContentFromServer(Context ctx) {
        String retStr = null;
        try {
            IServerConfigFileCache iServerConfig = null;
            iServerConfig = ctx == null ? ServerConfigFileFactory.getRemoteInstance() : ServerConfigFileFactory.getLocalInstance(ctx);
            retStr = iServerConfig.getConfigFileContent();
        }
        catch (EASBizException se) {
            this.logger.error((Object)"ServerConfigFileFactory\u3000call fail!", (Throwable)se);
        }
        return retStr;
    }
}

