/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util;

import com.kingdee.eas.base.permission.util.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class AbstractExcel2007Writer {
    private SpreadsheetWriter sw;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String fileName) throws Exception {
        FileOutputStream os = null;
        Writer fw = null;
        FileOutputStream out = null;
        try {
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFSheet sheet = wb.createSheet("sheet1");
            String sheetRef = sheet.getPackagePart().getPartName().getName();
            os = new FileOutputStream("template.xlsx");
            wb.write((OutputStream)os);
            os.close();
            File tmp = File.createTempFile("sheet", ".xml");
            fw = new FileWriter(tmp);
            this.sw = new SpreadsheetWriter(fw);
            this.generate();
            fw.close();
            File templateFile = new File("template.xlsx");
            out = new FileOutputStream(fileName);
            AbstractExcel2007Writer.substitute(templateFile, tmp, sheetRef.substring(1), out);
            out.close();
            System.gc();
            if (templateFile.isFile() && templateFile.exists()) {
                templateFile.delete();
            }
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (fw != null) {
                fw.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public abstract void generate() throws Exception;

    public void beginSheet() throws IOException {
        this.sw.beginSheet();
    }

    public void insertRow(int rowNum) throws IOException {
        this.sw.insertRow(rowNum);
    }

    public void createCell(int columnIndex, String value) throws IOException {
        this.sw.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, double value) throws IOException {
        this.sw.createCell(columnIndex, value, -1);
    }

    public void endRow() throws IOException {
        this.sw.endRow();
    }

    public void endSheet() throws IOException {
        this.sw.endSheet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void substitute(File zipfile, File tmpfile, String entry, OutputStream out) throws IOException {
        ZipOutputStream zos = null;
        InputStream is = null;
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipfile);
            zos = new ZipOutputStream(out);
            Enumeration<? extends ZipEntry> en = zip.entries();
            while (en.hasMoreElements()) {
                ZipEntry ze = en.nextElement();
                if (ze.getName().equals(entry)) continue;
                zos.putNextEntry(new ZipEntry(ze.getName()));
                is = zip.getInputStream(ze);
                AbstractExcel2007Writer.copyStream(is, zos);
                is.close();
            }
            zos.putNextEntry(new ZipEntry(entry));
            is = new FileInputStream(tmpfile);
            AbstractExcel2007Writer.copyStream(is, zos);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (zos != null) {
                zos.close();
            }
            if (zip != null) {
                zip.close();
            }
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] chunk = new byte[1024];
        while ((count = in.read(chunk)) >= 0) {
            out.write(chunk, 0, count);
        }
    }

    public static class SpreadsheetWriter {
        private final Writer _out;
        private int _rownum;
        private static String LINE_SEPARATOR = System.getProperty("line.separator");

        public SpreadsheetWriter(Writer out) {
            this._out = out;
        }

        public void beginSheet() throws IOException {
            this._out.write("<?xml version=\"1.0\" encoding=\"GB2312\"?><worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\">");
            this._out.write("<sheetData>" + LINE_SEPARATOR);
        }

        public void endSheet() throws IOException {
            this._out.write("</sheetData>");
            this._out.write("</worksheet>");
        }

        public void insertRow(int rownum) throws IOException {
            this._out.write("<row r=\"" + (rownum + 1) + "\">" + LINE_SEPARATOR);
            this._rownum = rownum;
        }

        public void endRow() throws IOException {
            this._out.write("</row>" + LINE_SEPARATOR);
        }

        public void createCell(int columnIndex, String value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"inlineStr\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            this._out.write("<is><t>" + XMLEncoder.encode(value) + "</t></is>");
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, String value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, double value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"n\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            this._out.write("<v>" + value + "</v>");
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, double value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, Calendar value, int styleIndex) throws IOException {
            this.createCell(columnIndex, DateUtil.getExcelDate((Calendar)value, (boolean)false), styleIndex);
        }
    }
}

