/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util;

import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.IUserInfoCheckStrategy;
import com.kingdee.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GroupLicModeUserCheckStrategy
implements IUserInfoCheckStrategy {
    @Override
    public boolean check(UserInfo user) throws UserException {
        if (!this.checkMobilePhone(user)) {
            throw new UserException(UserException.MOBILE_ERROR);
        }
        if (!StringUtils.isEmpty((String)user.getEmail()) && !this.checkMailAddress(user)) {
            throw new UserException(UserException.EMAIL_ERROR);
        }
        return true;
    }

    protected boolean checkMobilePhone(UserInfo user) throws UserException {
        if (StringUtils.isEmpty((String)user.getCell())) {
            return true;
        }
        Pattern p = Pattern.compile("^[1]\\d{10}$");
        Matcher m = p.matcher(user.getCell());
        return m.matches();
    }

    protected boolean checkMailAddress(UserInfo user) {
        Pattern p = Pattern.compile("\\w+@(\\w+.)+[a-z]{2,3}");
        Matcher m = p.matcher(user.getEmail());
        return m.matches();
    }
}

