/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class PermissionRangeHelper {
    public static List getCUOrgRange(Context ctx) throws BOSException, EASBizException {
        if (ctx != null) {
            return PermissionRangeHelper.getBizUserCUOrgRange(ctx, ctx.getCaller());
        }
        return PermissionRangeHelper.getBizUserCUOrgRange(ctx, ToolUtils.getCurrentUserPK());
    }

    public static List getTopCUOrgRange(Context ctx) throws BOSException, EASBizException {
        if (ctx != null) {
            return PermissionRangeHelper.getTopBizUserCUOrgRange(ctx, ctx.getCaller());
        }
        return PermissionRangeHelper.getTopBizUserCUOrgRange(ctx, ToolUtils.getCurrentUserPK());
    }

    public static String getCUOrgRangeSQL(Context ctx) throws BOSException, EASBizException {
        if (ctx != null) {
            return PermissionRangeHelper.getBizUserCUOrgRangeSQL(ctx, ctx.getCaller());
        }
        return PermissionRangeHelper.getBizUserCUOrgRangeSQL(ctx, ToolUtils.getCurrentUserPK());
    }

    public static List getBizUserCUOrgRange(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        List orgIdList = PermissionRangeHelper.getUserOrgId(ctx, userPK, OrgRangeType.BIZ_ORG_TYPE);
        if (orgIdList == null || orgIdList.size() == 0) {
            return new ArrayList();
        }
        if (Administrator.isCUAdmin(ctx, userPK)) {
            return orgIdList;
        }
        IFullOrgUnit iFullOrgUnit = null;
        iFullOrgUnit = ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)ctx);
        String oql = "select id,CU.id where id in (" + ToolUtils.aryToStr(orgIdList, true) + ")";
        FullOrgUnitCollection fullOrgUnitClo = iFullOrgUnit.getFullOrgUnitCollection(oql);
        ArrayList cuIdList = new ArrayList();
        if (fullOrgUnitClo == null || fullOrgUnitClo.isEmpty()) {
            return cuIdList;
        }
        return ToolUtils.transCol2ListByPeroperty((IObjectCollection)fullOrgUnitClo, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)obj;
                if (orgInfo.getCU() != null && orgInfo.getCU().getId() != null) {
                    return orgInfo.getCU().getId().toString();
                }
                return null;
            }
        });
    }

    public static List getTopBizUserCUOrgRange(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        String cuRangeSql = null;
        IFullOrgUnit iFullOrgUnit = null;
        if (ctx != null) {
            cuRangeSql = PermissionRangeHelper.getBizUserCUOrgRangeSQL(ctx, ctx.getCaller());
            iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        } else {
            cuRangeSql = PermissionRangeHelper.getBizUserCUOrgRangeSQL(ctx, ToolUtils.getCurrentUserPK());
            iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        }
        String oql = "select id,longNumber,CU.id where id in (" + cuRangeSql + ") and (parent not in (" + cuRangeSql + ") or parent is null) order by longNumber";
        FullOrgUnitCollection col = iFullOrgUnit.getFullOrgUnitCollection(oql);
        ArrayList cuIdList = new ArrayList();
        if (col == null || col.isEmpty()) {
            return cuIdList;
        }
        Object[] infos = col.toArray();
        block0: for (int i = 0; i < infos.length; ++i) {
            String longNumber = ((FullOrgUnitInfo)infos[i]).getLongNumber();
            for (int j = 0; j < i; ++j) {
                if (!longNumber.startsWith(((FullOrgUnitInfo)infos[j]).getLongNumber() + "!")) continue;
                col.remove((FullOrgUnitInfo)infos[i]);
                continue block0;
            }
        }
        return ToolUtils.transCol2ListByPeroperty((IObjectCollection)col, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)obj;
                if (orgInfo.getCU() != null && orgInfo.getCU().getId() != null) {
                    return orgInfo.getCU().getId().toString();
                }
                return null;
            }
        });
    }

    public static String getBizUserCUOrgRangeSQL(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        if (Administrator.isCUAdmin(ctx, userPK)) {
            sb.append("select FOrgID from t_pm_orgrange where fuserid = '").append(userPK.toString()).append("'");
            sb.append(" and FType = ").append(OrgRangeType.BIZ_ORG_TYPE.getValue());
        } else if (Administrator.isBizAdmin(ctx, userPK)) {
            sb.append("select FOrgID from t_pm_orgrange where fuserid = '").append(userPK.toString()).append("'");
            sb.append(" and FType = ").append(OrgRangeType.MANAGE_ORG_TYPE.getValue());
        }
        return sb.toString();
    }

    public static String getUserOrgIdRangeSQL(Context ctx, IObjectPK userPK, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("select forgid from t_pm_orgrange where fuserid = '").append(userPK.toString()).append("'");
        if (orgRangeType != null) {
            sb.append(" and ftype = ").append(orgRangeType.getValue());
        }
        return sb.toString();
    }

    public static boolean inCUOrgRange(Context ctx, IObjectPK userPK, String cuID) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        if (Administrator.isCUAdmin(ctx, userPK)) {
            IOrgRange iOrgRange = null;
            iOrgRange = ctx == null ? OrgRangeFactory.getRemoteInstance() : OrgRangeFactory.getLocalInstance(ctx);
            sb.append("select id where user = '").append(userPK.toString()).append("'");
            sb.append(" and type = ").append(OrgRangeType.BIZ_ORG_TYPE.getValue());
            sb.append(" and org.id = '").append(cuID).append("'");
            return iOrgRange.exists(sb.toString());
        }
        IFullOrgUnit iFullOrgUnit = null;
        iFullOrgUnit = ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)ctx);
        sb.append("select id where id in (");
        sb.append("select FOrgID from t_pm_orgrange where FUserID = '").append(userPK.toString()).append("'");
        sb.append(" and FType = ").append(OrgRangeType.BIZ_ORG_TYPE.getValue());
        sb.append(") and CU.id = '").append(cuID).append("'");
        return iFullOrgUnit.exists(sb.toString());
    }

    public static boolean hasCUOrgRange(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        IOrgRange iOrgRange = null;
        iOrgRange = ctx == null ? OrgRangeFactory.getRemoteInstance() : OrgRangeFactory.getLocalInstance(ctx);
        if (Administrator.isCUAdmin(ctx, userPK)) {
            sb.append("select id where user = '").append(userPK.toString()).append("'");
            sb.append(" and type = ").append(OrgRangeType.BIZ_ORG_TYPE.getValue());
            return iOrgRange.exists(sb.toString());
        }
        sb.append("select id where user = '").append(userPK.toString()).append("'");
        sb.append(" and type = ").append(OrgRangeType.MANAGE_ORG_TYPE.getValue());
        return iOrgRange.exists(sb.toString());
    }

    public static String getOrgListSQL(IObjectPK userPK, String roleID) {
        StringBuffer sb = new StringBuffer();
        if (userPK != null && !StringUtils.isEmpty((String)roleID)) {
            sb.append("select FOrgID from T_PM_GrantUserRoleOrg Where FRoleID = '").append(roleID).append("'");
            sb.append(" and FUserID = '").append(userPK.toString()).append("'");
        }
        return sb.toString();
    }

    public static List getCUOrgRange(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        return PermissionRangeHelper.getUserOrgId(ctx, userPK, OrgRangeType.BIZ_ORG_TYPE);
    }

    public static OrgRangeCollection getUserOrgRange(Context ctx, IObjectPK userPK, OrgRangeType orgType) throws BOSException, EASBizException {
        IOrgRange iOrgRange = null;
        iOrgRange = ctx == null ? OrgRangeFactory.getRemoteInstance() : OrgRangeFactory.getLocalInstance(ctx);
        return iOrgRange.findFullOrgCol(userPK, orgType);
    }

    public static List getUserOrgId(Context ctx, IObjectPK userPK, OrgRangeType orgType) throws BOSException, EASBizException {
        IOrgRange iOrgRange = null;
        iOrgRange = ctx == null ? OrgRangeFactory.getRemoteInstance() : OrgRangeFactory.getLocalInstance(ctx);
        return iOrgRange.getOrgIdByUserAndType(userPK, orgType);
    }

    public static FullOrgUnitCollection getUserOrgCol(Context ctx, IObjectPK userPK, OrgRangeType orgType) throws BOSException, EASBizException {
        OrgRangeCollection fullOrgRangeCol = PermissionRangeHelper.getUserOrgRange(ctx, userPK, orgType);
        FullOrgUnitCollection fullOrgUnit = new FullOrgUnitCollection();
        if (fullOrgRangeCol == null || fullOrgRangeCol.isEmpty()) {
            return fullOrgUnit;
        }
        int size = fullOrgRangeCol.size();
        for (int i = 0; i < size; ++i) {
            fullOrgUnit.add(fullOrgRangeCol.get(i).getOrg());
        }
        return fullOrgUnit;
    }

    public static List getManagedCUIDList(Context ctx, IObjectPK userPK) throws EASBizException, BOSException {
        if (Administrator.isAdmin(ctx, userPK)) {
            return PermissionRangeHelper.getUserOrgId(ctx, userPK, OrgRangeType.BIZ_ORG_TYPE);
        }
        if (Administrator.isBizAdmin(ctx, userPK)) {
            return PermissionRangeHelper.getUserOrgId(ctx, userPK, OrgRangeType.MANAGE_ORG_TYPE);
        }
        return new ArrayList();
    }

    public static String getManagedCuIdSQL(Context ctx, IObjectPK userPK) throws EASBizException, BOSException {
        if (Administrator.isAdmin(ctx, userPK)) {
            return PermissionRangeHelper.getUserOrgIdRangeSQL(ctx, userPK, OrgRangeType.BIZ_ORG_TYPE);
        }
        if (Administrator.isBizAdmin(ctx, userPK)) {
            return PermissionRangeHelper.getUserOrgIdRangeSQL(ctx, userPK, OrgRangeType.MANAGE_ORG_TYPE);
        }
        return "''";
    }

    public static String getUnionSQLByUserPKAndTreePK(IObjectPK userPK, IObjectPK treeID) throws BOSException {
        if (userPK == null || treeID == null) {
            throw new BOSException("userPK or treeID cannot be null.");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT unit.fid ").append("FROM T_PM_ORGRANGE range ").append("INNER JOIN T_ORG_BASEUNIT unit ON unit.fid = range.forgid ").append("INNER JOIN T_ORG_STRUCTURE structure ON structure.funitid = range.forgid ").append("WHERE unit.fisunion = 1 AND range.fuserid = '").append(userPK).append("' AND range.ftype = ").append(10).append(" AND Structure.FTreeId = '").append(treeID).append("'");
        return sql.toString();
    }
}

