/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.file;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.license.file.regist.RegistDBException;
import com.kingdee.eas.base.permission.util.LogUtil;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.permission.util.cloud.ExportAllUserHelper;
import com.kingdee.eas.base.permission.util.file.DerbyDB;
import com.kingdee.eas.base.permission.util.file.SyncResultInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Logger;

public class LicenseSyncResultDB {
    private static Logger logger = Logger.getLogger(LicenseSyncResultDB.class);
    private Connection derbyConn = null;
    private static volatile LicenseSyncResultDB licenseSyncResultDB = null;
    private static final String createSQL = "create table syncresult (id varchar(44),number varchar(44),db varchar(44),time timestamp,ip varchar(40),type int,detail varchar(100),result varchar(100))";
    private static final String alterSQL = "alter table syncresult alter column ip set data type varchar(40)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LicenseSyncResultDB getInstance() {
        if (licenseSyncResultDB != null) return licenseSyncResultDB;
        Class<LicenseSyncResultDB> clazz = LicenseSyncResultDB.class;
        synchronized (LicenseSyncResultDB.class) {
            if (licenseSyncResultDB != null) return licenseSyncResultDB;
            licenseSyncResultDB = new LicenseSyncResultDB();
            // ** MonitorExit[var0] (shouldn't be in output)
            return licenseSyncResultDB;
        }
    }

    private LicenseSyncResultDB() {
        this.initDB();
    }

    public void initDB() {
        try {
            this.derbyConn = this.getConn();
            this.createDB(createSQL);
        }
        catch (Exception e) {
            logger.error((Object)"=====================LicenseSyncResultDB initial error", (Throwable)e);
        }
    }

    public void createDB(String createSQL) throws RegistDBException {
        try {
            Connection conn = this.getConn();
            Statement sta = conn.createStatement();
            logger.error((Object)"create table start");
            sta.executeUpdate(createSQL);
            conn.commit();
        }
        catch (SQLException e) {
            if (!e.getSQLState().equalsIgnoreCase("X0Y32")) {
                throw new RegistDBException("create table error !", (Throwable)e);
            }
            logger.warn((Object)"consoledb table has exist!");
        }
        try {
            Connection connx = this.getConn();
            Statement stax = connx.createStatement();
            logger.error((Object)"alter column start");
            stax.execute(alterSQL);
        }
        catch (SQLException ex) {
            logger.error((Object)("alter column failed" + ex.getMessage()));
        }
    }

    public Connection getConn() {
        if (DerbyDB.checkConnIsValid(this.derbyConn)) {
            return this.derbyConn;
        }
        String filePath = System.getProperty("EAS_HOME");
        if (!StringUtils.isEmpty((String)filePath)) {
            File file = new File(filePath);
            filePath = file.getAbsolutePath() + "/server/properties/license/syncresultdb/";
        } else {
            filePath = "W:" + File.separator + "eas" + File.separator + "Server" + File.separator + "server" + File.separator + "properties" + File.separator + "license" + File.separator + "syncresultdb" + File.separator;
        }
        try {
            logger.error((Object)LogUtil.filterLogForging("consoledb path ===" + filePath));
            return DerbyDB.getConnection(filePath);
        }
        catch (Exception e) {
            logger.error((Object)"==========================DerbyDB.getConnection failed!!!!", (Throwable)e);
            return null;
        }
    }

    public void insertDB(SyncResultInfo syncResultInfo) throws BOSException {
        String insertSQL = "INSERT INTO syncresult(id,number,db,time,ip,type,detail,result) values(?,?,?,?,?,?,?,?)";
        PreparedStatement sta = null;
        try {
            Connection conn = this.getConn();
            sta = conn.prepareStatement(insertSQL);
            sta.setString(1, syncResultInfo.getId());
            sta.setString(2, syncResultInfo.getNumber());
            sta.setString(3, syncResultInfo.getDb());
            sta.setTimestamp(4, syncResultInfo.getTime());
            sta.setString(5, syncResultInfo.getIp());
            sta.setInt(6, syncResultInfo.getType());
            sta.setString(7, syncResultInfo.getDetail());
            sta.setString(8, syncResultInfo.getResult());
            sta.executeUpdate();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sta);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSyncResultData(Map<String, DCInfo> dbMap) {
        ArrayList dataList;
        PreparedStatement sta;
        ResultSet rs;
        block6: {
            String selectSql = "SELECT id,number,db,time,ip,type,detail,result from syncresult order by time desc";
            rs = null;
            sta = null;
            dataList = new ArrayList(20);
            int extraCount = 0;
            HashSet<String> extraData = new HashSet<String>();
            try {
                Connection conn = this.getConn();
                sta = conn.prepareStatement(selectSql);
                rs = sta.executeQuery();
                while (rs.next()) {
                    String detail = rs.getString("detail");
                    String result = rs.getString("result");
                    if (extraCount < 10) {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("id", rs.getString("id"));
                        data.put("number", rs.getString("number"));
                        data.put("db", dbMap.get(rs.getString("db")) == null ? "" : dbMap.get(rs.getString("db")).getName(ContextUtils.getLocaleFromEnv().toString().toUpperCase()));
                        data.put("time", rs.getTimestamp("time"));
                        data.put("ip", rs.getString("ip"));
                        data.put("type", rs.getInt("type"));
                        data.put("detail", detail);
                        data.put("result", result);
                        dataList.add(data);
                        ++extraCount;
                        continue;
                    }
                    extraData.add(rs.getString("id"));
                    this.deleteFile(detail, result);
                }
                if (extraData.size() == 0) break block6;
                String deleteSql = "delete from syncresult where id in(" + ToolUtils.aryToStr(extraData) + ")";
                sta = conn.prepareStatement(deleteSql);
                sta.execute();
                conn.commit();
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"==========================permission.LicenseSyncResultDB.getSyncResultData.SQLException", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, sta);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)sta);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sta);
        return dataList;
    }

    private void deleteFile(String detailPath, String resultPath) {
        logger.error((Object)LogUtil.filterLogForging("deleteFile" + resultPath));
        File detailFile = new File(this.getPath("detail") + detailPath + ".csv");
        File resultFile = new File(this.getPath("result") + resultPath + ".xlsx");
        if (detailFile.exists()) {
            detailFile.delete();
        }
        if (resultFile.exists()) {
            resultFile.delete();
        }
    }

    private String getPath(String type) {
        String filePath = System.getProperty("EAS_HOME");
        if (!StringUtils.isEmpty((String)filePath)) {
            File file = new File(filePath);
            filePath = file.getAbsolutePath() + "/server/properties/license" + ("detail".equals(type) ? "/detail/" : "/result/");
        } else {
            filePath = "W:" + File.separator + "eas" + File.separator + "Server" + File.separator + "server" + File.separator + "properties" + File.separator + "license" + File.separator + ("detail".equals(type) ? "detail" : "result") + File.separator;
        }
        File file2 = new File(filePath);
        if (!file2.exists()) {
            file2.mkdir();
        }
        return filePath;
    }

    public String getSyncNumber() {
        FastDateFormat bDate = FastDateFormat.getInstance((String)"yyyyMMdd");
        long time = System.currentTimeMillis();
        String lastResNum = this.getLastResNum();
        String nowNum = bDate.format(System.currentTimeMillis());
        String newNum = "";
        newNum = lastResNum != null && lastResNum.contains(nowNum) ? nowNum + "-" + (Integer.parseInt(lastResNum.substring(nowNum.length() + 1)) + 1) + "" : nowNum + "-1";
        return newNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastResNum() {
        PreparedStatement sta;
        ResultSet rs;
        block4: {
            String string;
            rs = null;
            sta = null;
            String selectSQL = "Select number from syncresult order by time desc";
            try {
                Connection conn = this.getConn();
                sta = conn.prepareStatement(selectSQL);
                rs = sta.executeQuery();
                if (!rs.next()) break block4;
                string = rs.getString("number");
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"====================permissionLicenseSyncResultDB.getLastResNum(): ", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, sta);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)sta);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sta);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sta);
        return null;
    }

    public void addSyncResultView(Context ctx, int syncType, List synUserList, List synResult) throws BOSException {
        String syncNum = this.getSyncNumber();
        SyncResultInfo syncResultInfo = null;
        logger.error((Object)("addSyncResultView" + syncType));
        if (syncType == Integer.parseInt("0") || syncType == Integer.parseInt("2")) {
            String detailFileId = syncNum + "_detail";
            String resultFileId = syncNum + "_result";
            String detailPath = this.getPath("detail") + detailFileId + ".csv";
            ExportAllUserHelper detailExport = new ExportAllUserHelper(detailPath);
            String resultPath = this.getPath("result") + resultFileId + ".xlsx";
            logger.error((Object)resultPath);
            ExportAllUserHelper resultExport = new ExportAllUserHelper(resultPath);
            try {
                detailExport.execute(ctx, synUserList);
                logger.error((Object)"synUserExecute--");
                resultExport.synUserExecute(ctx, synUserList, synResult, true, true);
            }
            catch (Exception e) {
                logger.error((Object)"UserFacadeControllerBean._exportSyncFile.online", (Throwable)e);
            }
            syncResultInfo = new SyncResultInfo(BOSUuid.create((String)"register").toString(), syncNum, ctx.getAIS(), new Timestamp(System.currentTimeMillis()), ctx.getClientHostIP(), syncType, syncNum + "_detail", syncNum + "_result");
        } else {
            String resultFileId = syncNum + "_result";
            String resultPath = this.getPath("result") + resultFileId + ".xlsx";
            ExportAllUserHelper resultExport = new ExportAllUserHelper(resultPath);
            try {
                resultExport.synUserExecute(ctx, synUserList, null, false, true);
            }
            catch (Exception e) {
                logger.error((Object)"UserFacadeControllerBean._exportSyncFile.offline", (Throwable)e);
            }
            syncResultInfo = new SyncResultInfo(BOSUuid.create((String)"register").toString(), syncNum, ctx.getAIS(), new Timestamp(System.currentTimeMillis()), ctx.getClientHostIP(), syncType, null, syncNum + "_result");
        }
        this.insertDB(syncResultInfo);
    }

    public static void main(String[] args) {
        LicenseSyncResultDB licenseSyncResultDB = LicenseSyncResultDB.getInstance();
        System.out.println("++5+73-145+892".replaceFirst("\\+", ""));
    }
}

