/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.engine.script.beanshell;

import com.kingdee.bos.ctrl.reportone.data.engine.script.BuiltInUtil;
import com.kingdee.bos.ctrl.reportone.data.engine.script.beanshell.ScriptMaker;
import com.kingdee.bos.ctrl.reportone.data.modal.types.grouping.Grouping;
import com.kingdee.bos.ctrl.reportone.data.modal.types.grouping.GroupingUtil;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumn;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.GroupTree;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.ResultSetToTree;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.SimpleGroupTotal;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.GroupTotalDef;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.GroupTotalDefs;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.SimpleGroupsDef;
import java.sql.ResultSet;

public class ScriptsGenerator {
    public static final String generateScript(ScriptMaker helper, Object groupsDef, GroupTotalDefs gtDefs, String rsVarName, boolean outputAsRows) {
        String var_GroupDefs = null;
        if (groupsDef instanceof SimpleGroupsDef) {
            var_GroupDefs = helper.addDeclareVarScript(SimpleGroupsDef.class);
            helper.addScriptLine(var_GroupDefs + " = builtInUtil.makeSimpleGroupsDef(\"" + ((SimpleGroupsDef)groupsDef).toString() + "\");");
        } else if (groupsDef instanceof String[]) {
            var_GroupDefs = helper.makeVarName(Object.class);
            helper.addScriptLine("String[] " + var_GroupDefs + " = " + ScriptMaker.makeStringArrayStament((String[])groupsDef) + ";");
        } else if (groupsDef instanceof int[]) {
            var_GroupDefs = helper.makeVarName(Object.class);
            helper.addScriptLine("int[] " + var_GroupDefs + " = " + ScriptMaker.makeIntArrayStament((int[])groupsDef) + ";");
        } else {
            throw new UnsupportedOperationException("Unsupport. groupsDef=" + groupsDef);
        }
        String var_groupTotalDefs = helper.addDeclareVarScript(GroupTotalDefs.class);
        int levels = gtDefs.levels();
        helper.addScriptLine(var_groupTotalDefs + " = new GroupTotalDefs(" + levels + ");");
        for (int level = 0; level < levels + 1; ++level) {
            GroupTotalDef gtDef = gtDefs.getGroupTotalDef(level);
            for (int total = 0; total < gtDef.totals(); ++total) {
                helper.addScript(var_groupTotalDefs + ".getGroupTotalDef(" + level + ").addTotalDef(");
                helper.addScript("builtInUtil.makeTotalDef(\"" + BuiltInUtil.serializeTotalDef(gtDef.getTotalDef(total)) + "\")");
                helper.addScriptLine(");");
            }
        }
        helper.addScriptLine("");
        helper.addScriptLine("");
        helper.addImportClass(ResultSet.class);
        if (outputAsRows) {
            helper.addImportClass(SimpleGroupTotal.class);
            String rsVarName2 = helper.makeVarName(ResultSet.class);
            helper.addScriptLine("ResultSet " + rsVarName2 + " = SimpleGroupTotal.groupTotal(" + rsVarName + "," + var_GroupDefs + "," + var_groupTotalDefs + ",null);");
            helper.addSetDataResultScript(rsVarName2);
            return rsVarName2;
        }
        helper.addImportClass(ResultSetToTree.class);
        String varGroupTree = helper.addDeclareVarScript(GroupTree.class);
        helper.addScript(varGroupTree + " = ResultSetToTree.makeGroupTree((ResultSet)" + "result" + "," + var_GroupDefs);
        helper.addScriptLine(");");
        helper.addScriptLine(varGroupTree + ".setGroupTotalDefs(" + var_groupTotalDefs + ");");
        helper.addScriptLine("((ResultSet)" + rsVarName + ").close();");
        helper.addSetDataResultScript(varGroupTree);
        return varGroupTree;
    }

    public static final String generateByGrouping(String importQueryName, Grouping grouping, boolean onlyTreeMode) {
        OutputColumns outputColumns = grouping.getFields();
        ScriptMaker helper = new ScriptMaker();
        String varName = helper.makeVarName(Object.class);
        helper.addScriptLine("Object " + varName + " = builtInUtil.executeImport(\"" + importQueryName + "\");");
        helper.addScriptLine("");
        String varName2 = helper.addDeclareVarScript(ResultSet.class);
        helper.addScript(varName2 + " = builtInUtil.wrapResultSet(");
        helper.addScript("(ResultSet)" + varName);
        helper.addScript(",new String[]{");
        for (int i = 0; i < outputColumns.size(); ++i) {
            if (i != 0) {
                helper.addScript(",");
            }
            helper.addScript("\"" + ((OutputColumn)((Object)outputColumns.get(i))).getName() + "\"");
        }
        helper.addScript("});\n");
        helper.addScriptLine("");
        String[] groupByNames = GroupingUtil.gatherGroupByNames(grouping.getGroups());
        GroupTotalDefs gtDefs = GroupingUtil.gatherGroupTotalDefs(grouping.getGroups());
        ScriptsGenerator.generateScript(helper, groupByNames, gtDefs, varName, !onlyTreeMode);
        return helper.makeScript_imports() + "\r\n\r\n" + helper.getScript_process();
    }
}

