/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.framework.connection;

import com.kingdee.bos.ctrl.bizshare.AConnection;
import com.kingdee.bos.ctrl.bizshare.ConnectException;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import java.sql.Connection;
import java.sql.SQLException;

public class DBConnection
extends AConnection {
    private String serviceUrl;
    private String dbType;
    private String dbName;
    private String user;
    private String password;
    private Connection connection;

    public DBConnection(String dbType, String serviceUrl, String dbName, String user, String password) {
        this.dbType = dbType;
        this.serviceUrl = serviceUrl;
        this.dbName = dbName;
        this.user = user;
        this.password = password;
    }

    public String getDBType() {
        return this.dbType;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getDBName() {
        return this.dbName;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected void pureOpen() throws ConnectException {
        try {
            DBUtil.loadKSQLDriver();
            String ksqlConnectStr = this.getKSQLConnectString();
            this.connection = DBUtil.openDB((String)ksqlConnectStr, (String)this.user, (String)this.password);
        }
        catch (Exception ex) {
            throw new ConnectException((Throwable)ex);
        }
    }

    protected void pureClose() throws ConnectException {
        try {
            this.connection.close();
            this.connection = null;
        }
        catch (SQLException ex) {
            throw new ConnectException((Throwable)ex);
        }
    }

    private final String getKSQLConnectString() {
        if ("sqlserver".equals(this.dbType) || "Microsoft SQL Server".equals(this.dbType)) {
            String mssql_driver_url = "jdbc:microsoft:sqlserver://" + this.serviceUrl + ";DataBaseName=" + this.dbName;
            return "jdbc:ksql:com.microsoft.jdbc.sqlserver.SQLServerDriver:dbtype=sqlserver:" + mssql_driver_url;
        }
        return null;
    }
}

