/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.modal;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import org.apache.log4j.Logger;

public class DataConvertHelper {
    private static final Logger log = LogUtil.getPackageLogger(DataConvertHelper.class);
    private static final Byte BYTE_ZERO = new Byte(0);
    private static final Byte BYTE_ONE = new Byte(1);
    private static final Short SHORT_ZERO = new Short(0);
    private static final Short SHORT_ONE = new Short(1);
    private static final Integer INTEGER_ZERO = new Integer(0);
    private static final Integer INTEGER_ONE = new Integer(1);
    private static final Long LONG_ZERO = new Long(0L);
    private static final Long LONG_ONE = new Long(1L);
    private static final Float FLOAT_ZERO = new Float(0.0f);
    private static final Float FLOAT_ONE = new Float(1.0f);
    private static final Double DOUBLE_ZERO = new Double(0.0);
    private static final Double DOUBLE_ONE = new Double(1.0);
    private static final BigDecimal BIGDECIMAL_ZERO = new BigDecimal(0.0);
    private static final BigDecimal BIGDECIMAL_ONE = new BigDecimal(1.0);

    public static final DataType getDataType(Object obj) {
        if (obj instanceof String) {
            return DataType.STRING;
        }
        if (obj instanceof Boolean) {
            return DataType.BOOLEAN;
        }
        if (obj instanceof Byte) {
            return DataType.BYTE;
        }
        if (obj instanceof Short) {
            return DataType.SHORT;
        }
        if (obj instanceof Integer) {
            return DataType.INTEGER;
        }
        if (obj instanceof Long) {
            return DataType.LONG;
        }
        if (obj instanceof Float) {
            return DataType.FLOAT;
        }
        if (obj instanceof Double) {
            return DataType.DOUBLE;
        }
        if (obj instanceof BigDecimal) {
            return DataType.DECIMAL;
        }
        if (obj instanceof Time || obj instanceof Date || obj instanceof Timestamp) {
            return DataType.DATETIME;
        }
        if (obj instanceof byte[]) {
            return DataType.BINARY;
        }
        if (obj instanceof Clob) {
            return DataType.CLOB;
        }
        if (obj instanceof Blob) {
            return DataType.BLOB;
        }
        return null;
    }

    public static final Object convertData(Object data, DataType targetType) throws DataConvertException {
        DataType originalType = DataConvertHelper.getDataType(data);
        return DataConvertHelper.convertData(data, originalType, targetType);
    }

    public static final Object convertData(Object data, DataType originalType, DataType targetType) throws DataConvertException {
        if (data == null) {
            switch (targetType.intValue()) {
                case 0: {
                    return Boolean.FALSE;
                }
                case 1: {
                    return BYTE_ZERO;
                }
                case 2: {
                    return SHORT_ZERO;
                }
                case 3: {
                    return INTEGER_ZERO;
                }
                case 4: {
                    return LONG_ZERO;
                }
                case 6: {
                    return FLOAT_ZERO;
                }
                case 7: {
                    return DOUBLE_ZERO;
                }
                case 5: {
                    return BIGDECIMAL_ZERO;
                }
            }
            return null;
        }
        switch (originalType.convertableType(targetType)) {
            case 0: {
                throw new DataConvertException("Unsupport convert from " + originalType.toString() + " to " + targetType);
            }
            case 2: {
                return data;
            }
            case 1: {
                try {
                    switch (targetType.intValue()) {
                        case 8: {
                            switch (originalType.intValue()) {
                                case 10: 
                                case 11: {
                                    break;
                                }
                                case 0: {
                                    return data.equals(Boolean.TRUE) ? "1" : "0";
                                }
                                case 12: {
                                    return new String((byte[])data);
                                }
                                default: {
                                    return data.toString();
                                }
                            }
                        }
                        case 0: {
                            switch (originalType.intValue()) {
                                case 8: {
                                    String s = ((String)data).trim().toLowerCase();
                                    if ("true".equals(s) || "1".equals(s)) {
                                        return Boolean.TRUE;
                                    }
                                    if ("false".equals(s) || "0".equals(s)) {
                                        return Boolean.FALSE;
                                    }
                                    throw new NumberFormatException();
                                }
                            }
                            return data.equals(DOUBLE_ZERO) ? Boolean.FALSE : Boolean.TRUE;
                        }
                        case 1: {
                            switch (originalType.intValue()) {
                                case 0: {
                                    return data.equals(Boolean.TRUE) ? BYTE_ONE : BYTE_ZERO;
                                }
                            }
                            return Byte.valueOf((String)data);
                        }
                        case 2: {
                            switch (originalType.intValue()) {
                                case 0: {
                                    return data.equals(Boolean.TRUE) ? SHORT_ONE : SHORT_ZERO;
                                }
                            }
                            return Short.valueOf((String)data);
                        }
                        case 3: {
                            switch (originalType.intValue()) {
                                case 0: {
                                    return data.equals(Boolean.TRUE) ? INTEGER_ONE : INTEGER_ZERO;
                                }
                            }
                            return Integer.valueOf((String)data);
                        }
                        case 4: {
                            switch (originalType.intValue()) {
                                case 0: {
                                    return data.equals(Boolean.TRUE) ? LONG_ONE : LONG_ZERO;
                                }
                            }
                            return Long.valueOf((String)data);
                        }
                        case 6: {
                            switch (originalType.intValue()) {
                                case 0: {
                                    return data.equals(Boolean.TRUE) ? FLOAT_ONE : FLOAT_ZERO;
                                }
                            }
                            return Float.valueOf((String)data);
                        }
                        case 7: {
                            switch (originalType.intValue()) {
                                case 0: {
                                    return data.equals(Boolean.TRUE) ? DOUBLE_ONE : DOUBLE_ZERO;
                                }
                            }
                            return Double.valueOf((String)data);
                        }
                        case 5: {
                            switch (originalType.intValue()) {
                                case 0: {
                                    return data.equals(Boolean.TRUE) ? BIGDECIMAL_ONE : BIGDECIMAL_ZERO;
                                }
                            }
                            return new BigDecimal((String)data);
                        }
                        case 12: {
                            switch (originalType.intValue()) {
                                case 8: {
                                    return ((String)data).getBytes();
                                }
                            }
                            return null;
                        }
                        case 10: {
                            return null;
                        }
                        case 11: {
                            return null;
                        }
                        case 9: {
                            DateFormat df = DateFormat.getDateInstance();
                            return new Timestamp(df.parse(data.toString()).getTime());
                        }
                    }
                    return null;
                }
                catch (NumberFormatException e) {
                    throw new DataConvertException("Error converting the " + originalType + " '" + data + "' to " + targetType);
                }
                catch (IllegalArgumentException e) {
                    throw new DataConvertException("Value can not be converted to requested type.");
                }
                catch (ParseException e) {
                    throw new DataConvertException("Value can not be converted to requested type.");
                }
            }
        }
        return null;
    }

    public static final Object str2data(String strVal, DataType targetType) {
        try {
            switch (targetType.intValue()) {
                case 1: {
                    return Byte.valueOf(strVal);
                }
                case 2: {
                    return Short.valueOf(strVal);
                }
                case 3: {
                    return Integer.valueOf(strVal);
                }
                case 4: {
                    return Long.valueOf(strVal);
                }
                case 6: {
                    return Float.valueOf(strVal);
                }
                case 7: {
                    return Double.valueOf(strVal);
                }
                case 5: {
                    return new BigDecimal(strVal);
                }
                case 0: {
                    return Boolean.valueOf(strVal);
                }
                case 8: {
                    return strVal;
                }
                case 12: {
                    return strVal.getBytes();
                }
                case 10: {
                    return null;
                }
                case 11: {
                    return null;
                }
                case 9: {
                    DateFormat df = DateFormat.getDateInstance();
                    return new Timestamp(df.parse(strVal).getTime());
                }
            }
            return null;
        }
        catch (Exception ex) {
            log.error((Object)"\u6570\u636e\u8f6c\u6362\u9519\u8bef", (Throwable)ex);
            return null;
        }
    }

    public static class DataConvertException
    extends Exception {
        public DataConvertException() {
        }

        public DataConvertException(String message, Throwable cause) {
            super(message, cause);
        }

        public DataConvertException(String message) {
            super(message);
        }

        public DataConvertException(Throwable cause) {
            super(cause);
        }
    }
}

