/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.process.dataset.group;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.SimpleQueue;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.BasicResultSet;
import com.kingdee.bos.ctrl.reportone.data.engine.resultset.SimpleResultSetMetaData;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.aggregate.IAggregate;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.GroupTotalDef;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.GroupTotalDefs;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.SimpleGroupsDef;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.resultset.IGroupTotalResultSet;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.groupx.GroupXHelper;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SimpleGroupTotal {
    public static ResultSet groupTotal(ResultSet rs, int[] groupBy, GroupTotalDefs gtDefs, String groupTagName) throws SQLException {
        return new VirtualGTResultSet(rs, groupBy, gtDefs, groupTagName);
    }

    public static ResultSet groupTotal(ResultSet rs, SimpleGroupsDef gdefs, GroupTotalDefs gtDefs, String groupTagName) throws SQLException {
        int[] groupBy = new int[gdefs.levels()];
        for (int i = 0; i < groupBy.length; ++i) {
            groupBy[i] = gdefs.getColumn(i + 1);
        }
        return SimpleGroupTotal.groupTotal(rs, groupBy, gtDefs, groupTagName);
    }

    public static ResultSet groupTotal(ResultSet rs, String[] groupByNames, GroupTotalDefs gtDefs, String groupTagName) throws SQLException {
        int[] groupBy = new int[groupByNames.length];
        for (int i = 0; i < groupBy.length; ++i) {
            groupBy[i] = rs.findColumn(groupByNames[i]);
        }
        return new VirtualGTResultSet(rs, groupBy, gtDefs, groupTagName);
    }

    private static class VirtualGTResultSet
    extends BasicResultSet
    implements IGroupTotalResultSet {
        private ResultSetMetaData rsmd;
        private ResultSet rs;
        private int[] groupBy;
        private GroupTotalDefs gtDefs;
        private int gtLevels;
        private int columnCount;
        private Object[] targetRow;
        private SimpleQueue rowQueue;
        private IAggregate[][] funcObjss;
        private int[] groupTags;
        private Object[] lastReadRow;

        public VirtualGTResultSet(ResultSet rs, int[] groupBy, GroupTotalDefs gtDefs, String groupTagName) throws SQLException {
            this.rsmd = this.createMetaData(rs, "groupTotalTAG");
            this.rs = rs;
            this.groupBy = groupBy;
            this.gtDefs = gtDefs;
            this.columnCount = rs.getMetaData().getColumnCount() + 1;
            this.rowQueue = new SimpleQueue();
            this.gtDefs.solveGroupTotalDef(rs);
        }

        private ResultSetMetaData createMetaData(ResultSet rs, String groupTagName) throws SQLException {
            SimpleResultSetMetaData temp = new SimpleResultSetMetaData(rs.getMetaData());
            temp.addColumn(temp.getColumnCount() + 1, groupTagName, DataType.toJdbcType((DataType)DataType.STRING));
            return temp;
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            super.checkCursor(false);
            return this.rsmd;
        }

        @Override
        public Object getObject(int i) throws SQLException {
            super.getObject(i);
            return this.targetRow[i - 1];
        }

        private IAggregate[][] createAggregates() {
            IAggregate[][] funcObjss = new IAggregate[this.gtDefs.levels() + 1][];
            for (int level = 0; level < funcObjss.length; ++level) {
                funcObjss[level] = this.gtDefs.getGroupTotalDef(level).createAggregates(-1);
            }
            return funcObjss;
        }

        @Override
        public boolean next() throws SQLException {
            super.next();
            this.rowQueue.dequeue();
            if (this.rowQueue.isEmpty() && !this.computeRows()) {
                this.funcObjss = null;
                this.rowQueue = null;
                this.lastReadRow = null;
                this.targetRow = null;
                this.groupTags = null;
                this.cursorStatus = -2;
                return false;
            }
            this.targetRow = (Object[])this.rowQueue.front();
            return true;
        }

        protected void peekGroup(IAggregate[] aggregates, Object[] rowData, GroupTotalDef gtDef) {
            int totals = gtDef.totals();
            for (int totalIdx = 0; totalIdx < totals; ++totalIdx) {
                aggregates[totalIdx].peekData(rowData[gtDef.getTotalDef(totalIdx).getTotalCol() - 1]);
            }
        }

        private final void endSingleGroup(IAggregate[] funcObjs, int groupLevel, int[] tags) {
            GroupTotalDef gtDef = this.gtDefs.getGroupTotalDef(groupLevel);
            int totals = gtDef.totals();
            if (totals == 0) {
                return;
            }
            Object[] rowData = new Object[this.columnCount];
            for (int totalIdx = 0; totalIdx < totals; ++totalIdx) {
                int compCol = gtDef.getTotalDef(totalIdx).getTotalCol();
                rowData[compCol - 1] = funcObjs[totalIdx].getValue();
                funcObjs[totalIdx].reset();
            }
            rowData[this.columnCount - 1] = GroupXHelper.makeGroupTagString(tags, groupLevel, true);
            this.rowQueue.enqueue((Object)rowData);
            int n = groupLevel;
            tags[n] = tags[n] + 1;
        }

        private void endGroup(IAggregate[][] funcObjss, int level, int[] tags, Object[] lastRowData) {
            for (int endLevel = this.gtLevels; endLevel >= level; --endLevel) {
                this.endSingleGroup(funcObjss[endLevel], endLevel, tags);
            }
            ++level;
            while (level <= this.gtLevels) {
                tags[level] = 1;
                ++level;
            }
        }

        private boolean computeRows() throws SQLException {
            if (!this.rs.next()) {
                if (this.lastReadRow != null) {
                    this.endGroup(this.funcObjss, 0, this.groupTags, this.lastReadRow);
                    this.lastReadRow = null;
                    return true;
                }
                return false;
            }
            Object[] readRow = new Object[this.columnCount];
            CtrlUtil.DB.readRow((ResultSet)this.rs, (Object[])readRow, (int)(this.columnCount - 1));
            if (this.lastReadRow == null) {
                this.gtLevels = this.gtDefs.levels();
                this.groupTags = new int[this.gtLevels + 1];
                this.funcObjss = this.createAggregates();
                for (int i = 0; i < this.groupTags.length; ++i) {
                    this.groupTags[i] = 1;
                }
                this.lastReadRow = readRow;
            }
            if (this.gtDefs.getRootTotalDef().totals() > 0) {
                this.peekGroup(this.funcObjss[0], readRow, this.gtDefs.getRootTotalDef());
            }
            for (int level = 1; level <= this.gtLevels; ++level) {
                int colIdx = this.groupBy[level - 1] - 1;
                if (CtrlUtil.Obj.equals((Object)readRow[colIdx], (Object)this.lastReadRow[colIdx])) {
                    this.peekGroup(this.funcObjss[level], readRow, this.gtDefs.getGroupTotalDef(level));
                    continue;
                }
                this.endGroup(this.funcObjss, level, this.groupTags, this.lastReadRow);
                this.lastReadRow = readRow;
                --level;
            }
            this.lastReadRow = readRow;
            this.rowQueue.enqueue((Object)readRow);
            return true;
        }

        @Override
        public void close() throws SQLException {
            super.close();
            this.rsmd = null;
            CtrlUtil.DB.closeResultSet((ResultSet)this.rs);
        }

        public Object getObject(int columnIndex, Class type) throws SQLException {
            return null;
        }

        public Object getObject(String columnLabel, Class type) throws SQLException {
            return null;
        }
    }
}

