/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.process.dataset.groupx;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.IDataSetProcess;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.aggregate.IAggregate;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.GroupTotalDef;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.group.defs.GroupTotalDefs;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.groupx.GroupNodeX;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.groupx.GroupTotal4RelativeField;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.groupx.GroupTreeX;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.groupx.GroupXHelper;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.groupx.IRowsAppender;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class GroupTotalX
extends GroupTotal4RelativeField
implements IDataSetProcess {
    private int[] prefixGroups;
    private GroupTotalDefs prefixGroupToalDefs;
    private String tagColName = "GROUPTAGCOL";
    private ResultSet rs;
    private int columnCount;
    private IRowsAppender rowsAppender;
    private int normalLevels = 0;

    public final int[] getPrefixGroups() {
        return this.prefixGroups;
    }

    public final void setPrefixGroups(int[] prefixGroups, GroupTotalDefs prefixGroupToalDefs) {
        this.prefixGroups = prefixGroups;
        this.prefixGroupToalDefs = prefixGroupToalDefs;
        this.normalLevels = prefixGroups == null ? 0 : prefixGroups.length;
    }

    public final GroupTotalDefs getPrefixGroupToalDefs() {
        return this.prefixGroupToalDefs;
    }

    public final String getTagColName() {
        return this.tagColName;
    }

    public final void setTagColName(String tagColName) {
        this.tagColName = tagColName;
    }

    public final void setResultSet(ResultSet rs) {
        this.rs = rs;
    }

    public final ResultSet getResultSet() {
        return this.rs;
    }

    public final IRowsAppender getRowsAppender() {
        return this.rowsAppender;
    }

    public final void setRowsAppender(IRowsAppender rowsAppender) {
        this.rowsAppender = rowsAppender;
    }

    private final void endSinglePrefixGroup(IAggregate[] funcObjs, int groupLevel, int[] tags) throws Exception {
        GroupTotalDef gtDef = this.prefixGroupToalDefs.getGroupTotalDef(groupLevel);
        int totals = gtDef.totals();
        if (totals == 0) {
            return;
        }
        Object[] rowData = new Object[this.columnCount];
        for (int totalIdx = 0; totalIdx < totals; ++totalIdx) {
            int compCol = gtDef.getTotalDef(totalIdx).getTotalCol();
            rowData[compCol - 1] = funcObjs[totalIdx].getValue();
            funcObjs[totalIdx].reset();
        }
        rowData[this.columnCount - 1] = GroupXHelper.makeGroupTagString(tags, groupLevel, true);
        this.rowsAppender.appendRow(rowData);
        int n = groupLevel;
        tags[n] = tags[n] + 1;
    }

    private void endPrefixGroup(IAggregate[][] funcObjss, int level, ArrayList associatedBlock, int[] tags, Object[] lastRowData) throws IOException, Exception {
        if (this.rField > 0) {
            this.setRows(associatedBlock);
            GroupTreeX treeX = (GroupTreeX)super.compute();
            treeX.depthFirstWalk(new NodeXWalker4MakeRow(associatedBlock, lastRowData, GroupXHelper.makeGroupTagString(tags, this.normalLevels, false)));
        }
        for (int endLevel = this.normalLevels; endLevel >= level; --endLevel) {
            this.endSinglePrefixGroup(funcObjss[endLevel], endLevel, tags);
        }
        ++level;
        while (level < this.normalLevels) {
            tags[level] = 1;
            ++level;
        }
    }

    private final IAggregate[][] createPrefixAggregates() {
        IAggregate[][] funcObjss = new IAggregate[this.normalLevels + 1][];
        for (int level = 0; level < funcObjss.length; ++level) {
            funcObjss[level] = this.prefixGroupToalDefs.getGroupTotalDef(level).createAggregates(-1);
        }
        return funcObjss;
    }

    @Override
    public Object compute() throws SQLException, Exception {
        boolean hasRootTotal;
        this.columnCount = this.rs.getMetaData().getColumnCount() + 1;
        ArrayList<Object[]> associatedBlock = new ArrayList<Object[]>();
        IAggregate[][] funcObjss = this.createPrefixAggregates();
        Object[] lastRowData = null;
        int[] groupTags = null;
        boolean bl = hasRootTotal = this.prefixGroupToalDefs.getRootTotalDef().totals() > 0;
        while (this.rs.next()) {
            Object[] rowData = CtrlUtil.DB.readRow((ResultSet)this.rs);
            if (lastRowData == null) {
                lastRowData = rowData;
                groupTags = new int[this.normalLevels + 1];
                for (int i = 0; i < groupTags.length; ++i) {
                    groupTags[i] = 1;
                }
            }
            if (hasRootTotal) {
                this.peekGroup(funcObjss[0], rowData, this.prefixGroupToalDefs.getRootTotalDef());
            }
            if (this.prefixGroups != null) {
                for (int level = 1; level <= this.normalLevels; ++level) {
                    if (CtrlUtil.Obj.equals((Object)rowData[this.prefixGroups[level - 1] - 1], (Object)lastRowData[this.prefixGroups[level - 1] - 1])) {
                        this.peekGroup(funcObjss[level], rowData, this.prefixGroupToalDefs.getGroupTotalDef(level));
                        continue;
                    }
                    this.endPrefixGroup(funcObjss, level, associatedBlock, groupTags, lastRowData);
                    associatedBlock.clear();
                    lastRowData = rowData;
                    --level;
                }
            }
            if (this.rField > 0) {
                associatedBlock.add(rowData);
                continue;
            }
            Object[] newRowData = new Object[this.columnCount];
            System.arraycopy(rowData, 0, newRowData, 0, rowData.length);
            newRowData[this.columnCount - 1] = GroupXHelper.makeGroupTagString(groupTags, this.normalLevels, false);
            this.rowsAppender.appendRow(newRowData);
        }
        this.endPrefixGroup(funcObjss, 0, associatedBlock, groupTags, lastRowData);
        this.rowsAppender.finishAll();
        return this.rowsAppender;
    }

    @Override
    public Object call() throws Exception {
        return this.compute();
    }

    class NodeXWalker4MakeRow
    implements GroupNodeX.INodeXWalker {
        private Object[] lastRowData;
        private String prefixTag;
        private List rows;
        public static final int MAX_DEPTH = 128;
        int[] tags = new int[128];
        int[] needEat = new int[128];
        int curLevel = 0;

        public NodeXWalker4MakeRow(List rows, Object[] lastRowData, String prefixTag) {
            this.rows = rows;
            this.lastRowData = lastRowData;
            this.prefixTag = prefixTag.length() > 0 ? prefixTag + "." : "";
            this.needEat[0] = 1;
        }

        private Object[] createTotalRow(IAggregate[] aggregates, GroupTotalDef gtDef) {
            Object[] newRowData = new Object[GroupTotalX.this.columnCount];
            for (int i = 0; i < GroupTotalX.this.normalLevels; ++i) {
                newRowData[((GroupTotalX)GroupTotalX.this).prefixGroups[i] - 1] = this.lastRowData[GroupTotalX.this.prefixGroups[i] - 1];
            }
            for (int totalIdx = 0; totalIdx < aggregates.length; ++totalIdx) {
                newRowData[gtDef.getTotalDef((int)totalIdx).getTotalCol() - 1] = aggregates[totalIdx].getValue();
            }
            return newRowData;
        }

        @Override
        public void walk(GroupNodeX node) throws Exception {
            int n = this.curLevel;
            this.tags[n] = this.tags[n] + 1;
            node.setGroupPath(GroupXHelper.makeGroupTagString(this.tags, this.curLevel, false));
            if (node.getParent() != null) {
                IAggregate[] aggregates;
                int index;
                HashMap branches = node.getBranches(false);
                String tempTag = this.prefixTag + "[" + node.getGroupPath() + "].";
                if (branches != null) {
                    Iterator keys = branches.keySet().iterator();
                    Iterator vals = branches.values().iterator();
                    while (keys.hasNext()) {
                        Object[] newRowData = this.createTotalRow((IAggregate[])vals.next(), GroupTotalX.this.agtDef);
                        newRowData[GroupTotalX.this.rField - 1] = node.getData();
                        newRowData[GroupTotalX.this.aField - 1] = keys.next();
                        newRowData[((GroupTotalX)GroupTotalX.this).columnCount - 1] = tempTag + index + ".t";
                        GroupTotalX.this.rowsAppender.appendRow(newRowData);
                    }
                } else if (node.getSubGroups() == null) {
                    int row = node.getRecordFrom();
                    int records = node.getRecords();
                    for (index = 1; index <= records; ++index) {
                        Object[] rowData = (Object[])this.rows.get(row);
                        Object[] newRowData = new Object[GroupTotalX.this.columnCount];
                        System.arraycopy(rowData, 0, newRowData, 0, rowData.length);
                        newRowData[((GroupTotalX)GroupTotalX.this).columnCount - 1] = tempTag + index;
                        GroupTotalX.this.rowsAppender.appendRow(newRowData);
                        ++row;
                    }
                }
                if ((aggregates = (IAggregate[])node.getTotalResult()) != null) {
                    Object[] newRowData = this.createTotalRow(aggregates, GroupTotalX.this.rgtDef);
                    newRowData[GroupTotalX.this.rField - 1] = node.getData();
                    newRowData[((GroupTotalX)GroupTotalX.this).columnCount - 1] = tempTag + "t";
                    GroupTotalX.this.rowsAppender.appendRow(newRowData);
                }
            }
            int n2 = this.curLevel;
            this.needEat[n2] = this.needEat[n2] - 1;
            if (node.getSubGroups() != null) {
                this.needEat[this.curLevel + 1] = node.getSubGroups().size();
                ++this.curLevel;
            }
            if (this.needEat[this.curLevel] == 0) {
                --this.curLevel;
            }
        }
    }
}

