/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.process.dataset.rowset;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.ITempTableManager;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.rowset.SimpleUnitRows;
import com.kingdee.bos.ctrl.reportone.data.process.dataset.rowset.SqlUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class SimpleUnitRows2
extends SimpleUnitRows {
    public static final Logger log = LogUtil.getPackageLogger(SimpleUnitRows2.class);
    protected String joinMethod;
    public static String LEFT_JOIN = "LEFT JOIN";
    public static String JOIN = "JOIN";
    public static String RIGHT_JOIN = "RIGHT JOIN";
    public static String CROSS_JOIN = "CROSS JOIN";
    public static String FULL_JOIN = "FULL JOIN";
    public static String[] joinTypes = new String[]{JOIN, LEFT_JOIN, RIGHT_JOIN, FULL_JOIN, CROSS_JOIN};
    protected String table0;
    protected String table1;
    protected Connection conn;
    protected ITempTableManager tempTableManager;

    public final void setJoinMethod(String joinMethod) {
        this.joinMethod = joinMethod;
    }

    private StringBuffer makeSql_join(String t0, String t1, String joinMethod) throws SQLException {
        int i;
        if (FULL_JOIN.equals(joinMethod)) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.makeSql_join(t0, t1, LEFT_JOIN));
            sb.append(" UNION ");
            sb.append(this.makeSql_join(t0, t1, RIGHT_JOIN));
            return sb;
        }
        StringBuffer sb = new StringBuffer("SELECT ");
        String[] prefixs = new String[]{this.getPrefix0(), this.getPrefix1()};
        ResultSetMetaData[] metas = new ResultSetMetaData[]{this.rs0.getMetaData(), this.rs1.getMetaData()};
        for (i = 0; i < metas.length; ++i) {
            int count = metas[i].getColumnCount();
            for (int j = 0; j < count; ++j) {
                String colName = metas[i].getColumnName(j + 1);
                sb.append(prefixs[i]).append(".").append(colName);
                if (i != 0) {
                    sb.append(" AS \"").append(prefixs[i]).append(".").append(colName).append("\"");
                }
                sb.append(",");
            }
        }
        sb.setLength(sb.length() - 1);
        sb.append(" FROM ");
        if (!CROSS_JOIN.equals(joinMethod)) {
            sb.append(t0).append(" ").append(this.getPrefix0());
            sb.append(" ").append(joinMethod);
            sb.append(" ").append(t1).append(" ").append(this.getPrefix1());
            sb.append(" ON ");
            for (i = 0; i < this.pks0.length; ++i) {
                sb.append(this.getPrefix0()).append(".").append(this.pks0[i]);
                sb.append("=");
                sb.append(this.getPrefix1()).append(".").append(this.pks1[i]);
                if (i == this.pks0.length - 1) continue;
                sb.append(" AND ");
            }
        } else {
            sb.append(t0).append(" ").append(super.getPrefix0());
            sb.append(",");
            sb.append(t1).append(" ").append(super.getPrefix1());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sb.toString());
        }
        return sb;
    }

    @Override
    public Object call() throws Exception {
        boolean success = true;
        this.conn = this.openDBConnection();
        try {
            this.tempTableManager = this.getTempTableManager();
            this.table0 = this.tempTableManager.allocateTemp();
            this.table1 = this.tempTableManager.allocateTemp();
            SqlUtil.makeTable(this.rs0, this.table0, null, this.conn);
            SqlUtil.makeTable(this.rs1, this.table1, null, this.conn);
            StringBuffer sql = this.makeSql_join(this.table0, this.table1, this.joinMethod);
            ResultSet rs = this.conn.createStatement().executeQuery(sql.toString());
            ResultSet resultSet = (ResultSet)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new ResultSetHandler(rs));
            return resultSet;
        }
        catch (Exception ex) {
            success = false;
            throw ex;
        }
        finally {
            CtrlUtil.DB.closeResultSet((ResultSet)this.rs0);
            CtrlUtil.DB.closeResultSet((ResultSet)this.rs1);
            if (!success) {
                this.freeConnection();
            }
        }
    }

    private void freeConnection() {
        if (this.tempTableManager != null) {
            this.tempTableManager.freeTemp(this.table0);
            this.tempTableManager.freeTemp(this.table1);
        }
        CtrlUtil.DB.closeDBConn((Connection)this.conn);
    }

    class ResultSetHandler
    implements InvocationHandler {
        private ResultSet rs;

        ResultSetHandler(ResultSet rs) {
            this.rs = rs;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object obj;
            block3: {
                obj = null;
                try {
                    obj = method.invoke((Object)this.rs, args);
                }
                catch (Exception ex) {
                    if (!(ex instanceof InvocationTargetException)) break block3;
                    throw ((InvocationTargetException)ex).getTargetException();
                }
            }
            if (method.getName().equals("close")) {
                SimpleUnitRows2.this.freeConnection();
            }
            return obj;
        }
    }
}

