/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.common;

import com.kingdee.bos.ctrl.common.ui.ListView;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.AbstractListViewSelector;
import com.kingdee.bos.ctrl.swing.KDList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;

public class ListViewSelector
extends AbstractListViewSelector {
    protected ListView rightView;

    public ListViewSelector() {
        this.getSupply().setEnableMoveItem(false);
        this.rightView = new ListView();
        this.setCtrl((JComponent)this.rightView, false, false);
    }

    public ListView getSelected() {
        return this.rightView;
    }

    public void setSupplyList(List list) {
        KDList kdList = this.getSupply().getList();
        kdList.removeAllElements();
        this.onDeleteAll();
        if (list != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                kdList.addElement(i.next());
            }
            if (kdList.getElementCount() > 0) {
                kdList.setSelectedIndex(0);
            }
        }
        this.onSelectAll();
    }

    public void setSelectElements(List list) {
        this.onDeleteAll();
        if (list != null) {
            KDList kdList = this.rightView.getList();
            Iterator i = list.iterator();
            while (i.hasNext()) {
                kdList.addElement(i.next());
            }
            if (kdList.getElementCount() > 0) {
                kdList.setSelectedIndex(0);
            }
        }
        this.refreshBTs();
    }

    public List getSelectedElements() {
        KDList kdList = this.rightView.getList();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < kdList.getElementCount(); ++i) {
            list.add(kdList.getElement(i));
        }
        return list;
    }

    @Override
    protected void onSelect() {
        this.addLeftToRight(false);
    }

    @Override
    protected void onSelectAll() {
        this.addLeftToRight(true);
    }

    private void addLeftToRight(boolean addAll) {
        List cols = this.getSelectedElements();
        KDList rightList = this.rightView.getList();
        int count = rightList.getElementCount();
        KDList leftList = this.getSupply().getList();
        if (addAll) {
            for (int i = 0; i < leftList.getElementCount(); ++i) {
                Object selObj = leftList.getElement(i);
                if (cols.indexOf(selObj) != -1) continue;
                rightList.addElement(selObj);
            }
        } else {
            int[] sels = leftList.getSelectedIndices();
            if (sels == null || sels.length == 0) {
                return;
            }
            for (int i = 0; i < sels.length; ++i) {
                Object selObj = leftList.getElement(sels[i]);
                if (cols.indexOf(selObj) != -1) continue;
                rightList.addElement(selObj);
            }
            leftList.setSelectedIndex(sels[sels.length - 1]);
        }
        if (count < rightList.getElementCount()) {
            rightList.setSelectedIndex(rightList.getElementCount() - 1);
        }
        this.refreshBTs();
    }

    @Override
    protected void onDelete() {
        KDList list = this.rightView.getList();
        Object[] objs = list.getSelectedValues();
        if (objs == null || objs.length == 0) {
            return;
        }
        for (int i = 0; i < objs.length; ++i) {
            list.removeElement(objs[i]);
        }
        if (list.getElementCount() > 0) {
            list.setSelectedIndex(0);
        }
        this.refreshBTs();
    }

    @Override
    protected void onDeleteAll() {
        this.rightView.getList().removeAllElements();
        this.refreshBTs();
    }

    protected void refreshBTs() {
        boolean bR = this.rightView.getList().getElementCount() > 0;
        this.enableDelete(bR);
        this.enableDeleteAll(bR);
    }

    public void setSelectAll() {
        this.onSelectAll();
    }
}

