/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.process.crosstab;

import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.reportone.data.modal.types.TypesUtil;
import com.kingdee.bos.ctrl.reportone.data.modal.types.crosstab.CrosstabDef;
import com.kingdee.bos.ctrl.reportone.data.modal.types.grouping.Total;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumn;
import com.kingdee.bos.ctrl.reportone.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.reportone.data.process.IDataProcessModel;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.AbstractModelEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.Process2Resource;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.crosstab.CrosstabColumnsPanel;
import com.kingdee.bos.ctrl.reportone.data.wizard.process.crosstab.CrosstabModel;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CrosstabEditor
extends AbstractModelEditor {
    private KDPanel leftPanel;
    private KDPanel rightPanel;
    private KDList columnsSupply;
    private CrosstabColumnsPanel xAxisPanel;
    private CrosstabColumnsPanel yAxisPanel;
    private CrosstabColumnsPanel crossColPanel;
    private KDWorkButton btnSelectColumn;
    private KDWorkButton btnDeleteColumn;
    private KDWorkButton btnSelectRow;
    private KDWorkButton btnDeleteRow;
    private KDWorkButton btnSelectCalculate;
    private KDWorkButton btnDeleteCalculate;

    public CrosstabEditor() {
        this.init();
    }

    protected void init() {
        this.initLeftPanel();
        this.initRightPanel();
        TableLayout tl = TableLayout.split((int)1, (int)2);
        tl.colStyle(0).setWidth(-30);
        tl.colStyle(1).setWidth(-70);
        tl.colStyle(1).setMarginLeft(8);
        this.setLayout((LayoutManager)tl);
        this.add((Component)this.leftPanel, tl.cell(0));
        this.add((Component)this.rightPanel, tl.cell(1));
        this.installListener();
        this.syncSelectButton();
        this.syncDeleteButton(0);
        this.syncDeleteButton(1);
        this.syncDeleteButton(2);
    }

    private void initLeftPanel() {
        this.columnsSupply = new KDList();
        this.columnsSupply.setSelectionMode(2);
        TableLayout tl = TableLayout.split((int)2, (int)1);
        tl.rowStyle(0).setHeight(20);
        tl.rowStyle(0).setMarginBottom(3);
        tl.rowStyle(1).setPriY(1);
        Table row0 = tl.cell(0).split(1, 2);
        row0.colStyle(0).setPriX(1);
        row0.colStyle(1).setMarginRight(3);
        this.leftPanel = new KDPanel((LayoutManager)tl);
        this.leftPanel.add((Component)new KDLabel(Process2Resource.getString("res_19")), (Object)row0.cell(0));
        this.leftPanel.add((Component)new KDScrollPane((Component)this.columnsSupply), (Object)tl.cell(1));
    }

    private void initRightPanel() {
        this.xAxisPanel = new CrosstabColumnsPanel(true);
        this.yAxisPanel = new CrosstabColumnsPanel(true);
        this.crossColPanel = new CrosstabColumnsPanel(false);
        this.xAxisPanel.setTitle(Process2Resource.getString("res_20"));
        this.yAxisPanel.setTitle(Process2Resource.getString("res_21"));
        this.crossColPanel.setTitle(Process2Resource.getString("res_22"));
        this.btnSelectColumn = new KDWorkButton((Icon)Resource.ICON_MOVE_LEFT);
        this.btnDeleteColumn = new KDWorkButton((Icon)Resource.ICON_MOVE_RIGHT);
        this.btnSelectRow = new KDWorkButton((Icon)Resource.ICON_MOVE_LEFT);
        this.btnDeleteRow = new KDWorkButton((Icon)Resource.ICON_MOVE_RIGHT);
        this.btnSelectCalculate = new KDWorkButton((Icon)Resource.ICON_MOVE_LEFT);
        this.btnDeleteCalculate = new KDWorkButton((Icon)Resource.ICON_MOVE_RIGHT);
        TableLayout tl = TableLayout.split((int)2, (int)4);
        tl.colStyle(0).setWidth(28);
        tl.colStyle(0).setMargin(8, 0, 3, 0);
        tl.colStyle(1).setWidth(150);
        tl.colStyle(1).setPriX(1);
        tl.colStyle(2).setMargin(3, 0, 3, 0);
        tl.colStyle(2).setWidth(28);
        tl.colStyle(3).setWidth(150);
        tl.colStyle(3).setPriX(1);
        tl.colStyle(3).setMarginRight(8);
        tl.rowStyle(0).setMarginTop(15);
        tl.rowStyle(1).setMargin(0, 8, 0, 8);
        Table btnArea1 = tl.cell(0, 2).split(4, 1);
        btnArea1.rowStyle(0).setPriY(1);
        btnArea1.rowStyle(1).setHeight(21);
        btnArea1.rowStyle(1).setMarginBottom(3);
        btnArea1.rowStyle(2).setHeight(21);
        btnArea1.rowStyle(2).setMarginBottom(3);
        btnArea1.rowStyle(3).setPriY(1);
        Table btnArea2 = tl.cell(1, 0).split(4, 1);
        btnArea2.rowStyle(0).setPriY(1);
        btnArea2.rowStyle(1).setHeight(21);
        btnArea2.rowStyle(1).setMarginBottom(3);
        btnArea2.rowStyle(2).setHeight(21);
        btnArea2.rowStyle(2).setMarginBottom(3);
        btnArea2.rowStyle(3).setPriY(1);
        Table btnArea3 = tl.cell(1, 2).split(4, 1);
        btnArea3.rowStyle(0).setPriY(1);
        btnArea3.rowStyle(1).setHeight(21);
        btnArea3.rowStyle(1).setMarginBottom(3);
        btnArea3.rowStyle(2).setHeight(21);
        btnArea3.rowStyle(2).setMarginBottom(3);
        btnArea3.rowStyle(3).setPriY(1);
        this.rightPanel = new KDPanel((LayoutManager)tl);
        this.rightPanel.setBorder((Border)BorderFactory.createTitledBorder(Process2Resource.getString("res_23")));
        this.rightPanel.add((Component)this.btnSelectColumn, (Object)btnArea1.cell(1));
        this.rightPanel.add((Component)this.btnDeleteColumn, (Object)btnArea1.cell(2));
        this.rightPanel.add((Component)((Object)this.xAxisPanel), (Object)tl.cell(0, 3));
        this.rightPanel.add((Component)this.btnSelectRow, (Object)btnArea2.cell(1));
        this.rightPanel.add((Component)this.btnDeleteRow, (Object)btnArea2.cell(2));
        this.rightPanel.add((Component)((Object)this.yAxisPanel), (Object)tl.cell(1, 1));
        this.rightPanel.add((Component)this.btnSelectCalculate, (Object)btnArea3.cell(1));
        this.rightPanel.add((Component)this.btnDeleteCalculate, (Object)btnArea3.cell(2));
        this.rightPanel.add((Component)((Object)this.crossColPanel), (Object)tl.cell(1, 3));
    }

    private void installListener() {
        this.columnsSupply.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CrosstabEditor.this.syncSelectButton();
            }
        });
        this.xAxisPanel.getList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CrosstabEditor.this.syncDeleteButton(0);
            }
        });
        this.yAxisPanel.getList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CrosstabEditor.this.syncDeleteButton(1);
            }
        });
        this.crossColPanel.getList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CrosstabEditor.this.syncDeleteButton(2);
            }
        });
        ActionHandler actionHandler = new ActionHandler();
        this.btnSelectColumn.addActionListener((ActionListener)actionHandler);
        this.btnDeleteColumn.addActionListener((ActionListener)actionHandler);
        this.btnSelectRow.addActionListener((ActionListener)actionHandler);
        this.btnDeleteRow.addActionListener((ActionListener)actionHandler);
        this.btnSelectCalculate.addActionListener((ActionListener)actionHandler);
        this.btnDeleteCalculate.addActionListener((ActionListener)actionHandler);
    }

    private void syncSelectButton() {
        if (this.columnsSupply.getSelectedValues() != null && this.columnsSupply.getSelectedValues().length > 0) {
            this.btnSelectColumn.setEnabled(true);
            this.btnSelectRow.setEnabled(true);
            this.btnSelectCalculate.setEnabled(true);
        } else {
            this.btnSelectColumn.setEnabled(false);
            this.btnSelectRow.setEnabled(false);
            this.btnSelectCalculate.setEnabled(false);
        }
    }

    private void syncDeleteButton(int type) {
        switch (type) {
            case 0: {
                if (this.xAxisPanel.getList().getSelectedIndex() == -1) {
                    this.btnDeleteColumn.setEnabled(false);
                    break;
                }
                this.btnDeleteColumn.setEnabled(true);
                break;
            }
            case 1: {
                if (this.yAxisPanel.getList().getSelectedIndex() == -1) {
                    this.btnDeleteRow.setEnabled(false);
                    break;
                }
                this.btnDeleteRow.setEnabled(true);
                break;
            }
            case 2: {
                if (this.crossColPanel.getList().getSelectedIndex() == -1) {
                    this.btnDeleteCalculate.setEnabled(false);
                    break;
                }
                this.btnDeleteCalculate.setEnabled(true);
                break;
            }
        }
    }

    private void onAddColumn(CrosstabColumnsPanel panel) {
        OutputColumn oc = (OutputColumn)((Object)this.columnsSupply.getSelectedValue());
        panel.addColumn(oc);
    }

    private void onRemoveColumn(CrosstabColumnsPanel panel) {
        panel.removeCurrentColumn();
    }

    public void setSupplyColumns(List columns) {
        for (int i = 0; i < columns.size(); ++i) {
            this.columnsSupply.addElement(columns.get(i));
        }
    }

    private void setCrosstabDef(CrosstabDef cTable, OutputColumns supplyOCs) {
        this.xAxisPanel.setAxisDef(cTable.getXAxis());
        this.yAxisPanel.setAxisDef(cTable.getYAxis());
        this.crossColPanel.setCrossColumns(cTable.getCrossCols(), supplyOCs);
    }

    @Override
    public void onLostEditor() {
        OutputColumn oc;
        int i;
        CrosstabModel model = this.myModel();
        List xCols = this.xAxisPanel.getSelectedAsCols();
        String[] xCol_names = new String[xCols.size()];
        String[] xCol_orders = new String[xCols.size()];
        for (i = 0; i < xCol_names.length; ++i) {
            oc = (OutputColumn)((Object)xCols.get(i));
            xCol_names[i] = oc.getName();
            xCol_orders[i] = TypesUtil.orderAscToString(oc.getOrderAsc());
        }
        model.setXColOrders(xCol_orders);
        model.setXCols(xCol_names);
        List yCols = this.yAxisPanel.getSelectedAsCols();
        String[] yCol_names = new String[yCols.size()];
        String[] yCol_orders = new String[yCols.size()];
        for (i = 0; i < yCol_names.length; ++i) {
            oc = (OutputColumn)((Object)yCols.get(i));
            yCol_names[i] = oc.getName();
            yCol_orders[i] = TypesUtil.orderAscToString(oc.getOrderAsc());
        }
        model.setYColOrders(yCol_orders);
        model.setYCols(yCol_names);
        List crossList = this.crossColPanel.getSelectedAsCrossCols();
        String[] cross_names = new String[crossList.size()];
        String[] cross_methods = new String[crossList.size()];
        for (i = 0; i < cross_names.length; ++i) {
            Total total = (Total)crossList.get(i);
            cross_names[i] = total.getColumn();
            cross_methods[i] = total.getFunction();
        }
        model.setCrossFields(cross_names);
        model.setTotalMethods(cross_methods);
        model.setPutTotalColsToX(this.crossColPanel.isPutCrossFieldToX());
        model.setTotalAllX(true);
        model.setTotalAllY(true);
    }

    @Override
    public void setModel(IDataProcessModel model) {
        super.setModel(model);
        OutputColumns supplyOCs = (OutputColumns)model.getInput();
        this.setCrosstabDef((CrosstabDef)this.myModel().getOutput(), supplyOCs);
        this.crossColPanel.setPutCrossFieldX(this.myModel().isPutTotalColsToX());
        this.setSupplyColumns(supplyOCs);
    }

    CrosstabModel myModel() {
        return (CrosstabModel)super.getModel();
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == CrosstabEditor.this.btnSelectColumn) {
                CrosstabEditor.this.onAddColumn(CrosstabEditor.this.xAxisPanel);
            } else if (source == CrosstabEditor.this.btnSelectRow) {
                CrosstabEditor.this.onAddColumn(CrosstabEditor.this.yAxisPanel);
            } else if (source == CrosstabEditor.this.btnSelectCalculate) {
                CrosstabEditor.this.onAddColumn(CrosstabEditor.this.crossColPanel);
            } else if (source == CrosstabEditor.this.btnDeleteColumn) {
                CrosstabEditor.this.onRemoveColumn(CrosstabEditor.this.xAxisPanel);
                CrosstabEditor.this.syncDeleteButton(0);
            } else if (source == CrosstabEditor.this.btnDeleteRow) {
                CrosstabEditor.this.onRemoveColumn(CrosstabEditor.this.yAxisPanel);
                CrosstabEditor.this.syncDeleteButton(1);
            } else if (source == CrosstabEditor.this.btnDeleteCalculate) {
                CrosstabEditor.this.onRemoveColumn(CrosstabEditor.this.crossColPanel);
                CrosstabEditor.this.syncDeleteButton(2);
            }
            CrosstabEditor.this.syncSelectButton();
        }
    }
}

