/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas.maintenance;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;

public class Policies {
    Map policies = new HashMap();

    public void load(Element e) {
        List lst = e.getChildren();
        for (int i = 0; i < lst.size(); ++i) {
            Element eChild = (Element)lst.get(i);
            String categories = eChild.getAttributeValue("categories");
            String execusiveAttrs = eChild.getChild("Attributes").getAttributeValue("excludes");
            String flowStr = eChild.getChild("Data").getAttributeValue("methods");
            Policy policy = new Policy();
            policy.setExclusiveAttrs(execusiveAttrs);
            policy.setFlow(new Policy.Flow(flowStr));
            if ("*".equals(categories)) {
                this.policies.put("*", policy);
                continue;
            }
            String[] szCategories = categories.split(",");
            for (int j = 0; j < szCategories.length; ++j) {
                try {
                    this.policies.put(szCategories[j], policy.clone());
                    continue;
                }
                catch (CloneNotSupportedException ex) {
                    throw new Error();
                }
            }
        }
    }

    public Policy getPolicy(String category) {
        Policy policy = (Policy)this.policies.get(category);
        Policy base_policy = (Policy)this.policies.get("*");
        if (policy == null) {
            policy = base_policy;
        } else if (base_policy != null) {
            policy.appendExclusiveAttrs(base_policy.getExclusiveAttrs());
        }
        return policy;
    }

    public static class Policy
    implements Cloneable {
        String exclusiveAttrs;
        String ext;
        Flow flow;

        public void appendExclusiveAttrs(String ext) {
            this.ext = ext;
        }

        public final String getExclusiveAttrs() {
            if (this.ext != null) {
                return this.exclusiveAttrs + "," + this.ext;
            }
            return this.exclusiveAttrs;
        }

        public final void setExclusiveAttrs(String exclusiveAttrs) {
            this.exclusiveAttrs = exclusiveAttrs;
        }

        public final Flow getFlow() {
            return this.flow;
        }

        public final void setFlow(Flow flow) {
            this.flow = flow;
        }

        protected Object clone() throws CloneNotSupportedException {
            Policy policy2 = (Policy)super.clone();
            policy2.flow = (Flow)this.flow.clone();
            policy2.exclusiveAttrs = this.exclusiveAttrs;
            return policy2;
        }

        public static class Flow
        implements Cloneable {
            String[] methods;

            Flow(String flowStr) {
                this.methods = CtrlUtil.Str.isEmptyString((String)flowStr) ? null : flowStr.split(",");
            }

            int getSteps() {
                return this.methods != null ? this.methods.length : 0;
            }

            String getReadMethod(int step) {
                return this.methods[step].substring(0, this.methods[step].indexOf("/"));
            }

            String getWriteMethod(int step) {
                return this.methods[step].substring(this.methods[step].indexOf("/") + 1);
            }

            protected Object clone() throws CloneNotSupportedException {
                Flow flow = (Flow)super.clone();
                if (this.methods != null) {
                    String[] methods2 = new String[this.methods.length];
                    System.arraycopy(this.methods, 0, methods2, 0, this.methods.length);
                    flow.methods = methods2;
                }
                return flow;
            }
        }
    }
}

