/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas.perm;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AccessDeniedException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import org.apache.log4j.Logger;

public class ReportPermissionUtil {
    private static Logger log = LogUtil.getPackageLogger(ReportPermissionUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkViewRptPermission(String permissionItem) throws AccessDeniedException {
        ObjectUuidPK orgPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentOrgUnit().getId());
        ObjectUuidPK userPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentUserInfo().getId());
        long l0 = System.currentTimeMillis();
        try {
            IPermission permission = PermissionFactory.getRemoteInstance();
            permission.checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, permissionItem);
        }
        catch (Exception e) {
            PermissionException t = ReportPermissionUtil.processPermissionException(e);
            if (t != null) {
                throw new AccessDeniedException("Access denied!", (Throwable)t);
            }
            log.error((Object)"", (Throwable)e);
        }
        finally {
            long l2 = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.info((Object)("token:" + (l2 - l0)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkViewRptPermission(String rptId, OrgType orgType) throws AccessDeniedException {
        long l0 = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("rptId:" + rptId + ",orgType:" + orgType));
        }
        String permission_item = "rpts_report_view_report_" + orgType.getName();
        ObjectUuidPK orgPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentOrgUnit().getId());
        ObjectUuidPK userPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK rptPk = new ObjectUuidPK("id", BOSUuid.create((String)"59CB05C6"));
        rptPk.setKeyValue("id", (Object)rptId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("will check data-permission: orgPk=" + orgPk + ",userPk=" + userPk + ",permission_item=" + permission_item + ",rptPk=" + rptPk));
        }
        try {
            IPermission permission = PermissionFactory.getRemoteInstance();
            permission.checkDataPermission((IObjectPK)userPk, (IObjectPK)orgPk, permission_item, (IObjectPK)rptPk);
        }
        catch (Exception e) {
            PermissionException t = ReportPermissionUtil.processPermissionException(e);
            if (t != null) {
                throw new AccessDeniedException("Access denied!", (Throwable)t);
            }
            log.error((Object)"", (Throwable)e);
        }
        finally {
            long l2 = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.info((Object)("token:" + (l2 - l0)));
            }
        }
    }

    public static PermissionException processPermissionException(Throwable exc) {
        Throwable cause = exc;
        do {
            if (!(cause instanceof PermissionException)) continue;
            return (PermissionException)cause;
        } while ((cause = cause.getCause()) != null);
        return null;
    }
}

