/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.actions;

import com.kingdee.bos.ctrl.common.restype.def.ActionDef;
import com.kingdee.bos.ctrl.common.ui.RenameDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.restree.ResNodeAction;
import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.MapUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.ClientResource;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.actions.AbstractStorageResActionHandler;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyExistsException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

public class ActionRename
extends AbstractStorageResActionHandler {
    public static final String[] GET_ATTRS = new String[]{"name", "alias.zh_CN", "alias.zh_TW", "alias.en", "type"};

    public boolean onAction() throws KDRSException {
        String pathText = this.getResNode().getResPath();
        HashMap atts = this.getBizStorage().getAttributes(pathText, GET_ATTRS);
        String oldName = (String)atts.get("name");
        HashMap oldAlias = new HashMap();
        MapUtil.subKeyPrefix((Map)atts, (String)"alias.", oldAlias);
        RenameDialog dlg = (RenameDialog)WindowUtil.createWindow(RenameDialog.class, (Component)this.getTreeUI());
        String extend_types = (String)this.getActionDef().getActionExecutorDef().getArg("extend-names");
        if (!StringUtil.isEmptyString((String)extend_types)) {
            dlg.setHideExtNames(extend_types.split(","));
        }
        dlg.setOldName(oldName);
        dlg.setOldAlias(oldAlias);
        if (dlg.showDialog()) {
            ResObjectNode tn = this.getResNode();
            boolean needRefresh = false;
            String newName = dlg.getNewName();
            if (!StringUtil.equals((String)newName, (String)oldName)) {
                try {
                    this.getBizStorage().rename(pathText, newName);
                    needRefresh = true;
                }
                catch (AlreadyExistsException ex) {
                    WindowUtil.msgboxWarning((Object)ClientResource.getString("res_136"), (String)ResNodeAction.getDisplayName((ActionDef)this.getActionDef()), (Component)dlg);
                    return false;
                }
                tn.setName(newName);
            }
            String newPath = PathUtil.makeSiblingPath((String)pathText, (String)newName);
            HashMap newAlias = dlg.getNewAlias();
            if (!MapUtil.equals((Map)newAlias, oldAlias)) {
                String alias = LangUtil.getMultiLanguage((Map)newAlias, null);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("alias", "#1");
                MapUtil.addKeyPrefix((Map)newAlias, (String)"alias.", map);
                this.getBizStorage().setAttributes(newPath, map);
                tn.setAlias(alias);
                needRefresh = true;
            }
            if (needRefresh) {
                this.refreshNode(tn);
            }
        }
        return false;
    }

    protected void refreshNode(ResObjectNode tn) {
        this.getTreeUI().nodeChanged((TreeUINode)tn);
    }
}

