/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.common.ui.tree.INodeFilter;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.ClientResource;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.CommonBizStorageTreeCtrl;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport.AImportExportStoragePane;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport.ImportExportUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport.model.ExportToFileModel;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport.model.ICopyBetweenStorage;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class ExportToFileStep
implements IWizardStep {
    private AImportExportStoragePane _pane;
    private TreeUINode _sourceRootNode;
    private WizardDialog.StepsManager _manager;

    public ExportToFileStep(ICopyBetweenStorage context, TreeUINode sourceRootNode) {
        this._pane = new ExportToFilePane(context);
        this._sourceRootNode = sourceRootNode;
    }

    public JComponent getContent() {
        return this._pane;
    }

    public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
        this._manager.setFinishEnabled(true);
    }

    public IWizardStep outThisStep(boolean isOppose) {
        if (isOppose) {
            return null;
        }
        String toPath = this._pane.getModel().getToPath();
        this._pane.getModel().setToPath("/");
        boolean result = ImportExportUtil.exportWithUI(this._pane.getModel(), this._sourceRootNode, (Component)((Object)this._pane));
        if (result) {
            return null;
        }
        this._pane.getModel().setToPath(toPath);
        return this;
    }

    public boolean isReturnable() {
        return false;
    }

    public void initStep(WizardDialog.StepsManager manager) {
        this._manager = manager;
    }

    public void destroy(boolean isFinished) {
    }

    class ExportToFilePane
    extends AImportExportStoragePane {
        private ExportToFileModel model;

        public ExportToFilePane(ICopyBetweenStorage context) {
            super(context);
            this.remove((Component)this._panSto);
        }

        @Override
        protected ICopyBetweenStorage getModel() {
            if (this.model == null) {
                this.model = new ExportToFileModel();
            }
            return this.model;
        }

        @Override
        protected CommonBizStorageTreeCtrl createBizStorageTreeCtrl(ICopyBetweenStorage model) {
            final CommonBizStorageTreeCtrl ctrl = new CommonBizStorageTreeCtrl(this.getModel().getToStorage());
            ctrl.setNodeFitler((INodeFilter)ImportExportUtil.getInvisibleFileFilter());
            ctrl.getTreeUI().expandRoot();
            ctrl.getTreeUI().getTree().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent evt) {
                    ExportToFilePane.this._txtPath.setText(ctrl.getTreeUI().getSelectionPathText());
                }
            });
            return ctrl;
        }

        @Override
        protected String getPathTitle() {
            return ExportToFilePane.getMLS("TODO", ClientResource.getString("res_140"));
        }

        @Override
        protected void updateModel2UI() {
            this._stoCtrl.getTreeUI().setSelectionPathText(this.getModel().getToPath());
            this._txtPath.setText(this.getModel().getToPath());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void onBrowse() {
            KDFileChooser chooser = new KDFileChooser(System.getProperty("User.dir"));
            chooser.setDialogTitle(ClientResource.getString("res_141"));
            chooser.setFileSelectionMode(1);
            chooser.setDragEnabled(false);
            chooser.setFileHidingEnabled(true);
            chooser.isFileSelectionEnabled();
            int returnVal = chooser.showOpenDialog((Component)((Object)this));
            if (returnVal == 0) {
                String toFilePath = chooser.getSelectedFile().getPath();
                File temp = new File(toFilePath);
                if (!temp.isDirectory()) {
                    if (WindowUtil.msgboxYesNo((Component)((Object)this), (Object)ClientResource.getString("res_142"), (String)ClientResource.getString("res_143"))) {
                        if (!temp.mkdir()) {
                            WindowUtil.msgboxInfo((Object)ClientResource.getString("res_144"), (String)ClientResource.getString("res_145"), (Component)((Object)this));
                            toFilePath = this.getModel().getToPath();
                            return;
                        }
                        toFilePath = temp.getPath();
                    } else {
                        toFilePath = "C:\\";
                    }
                }
                chooser.setCurrentDirectory(new File(toFilePath));
                this.model.createFSStorage(toFilePath);
                this.model.setToPath(toFilePath);
                this.replaceStorageUI();
                this.updateModel2UI();
                System.setProperty("User.dir", toFilePath);
            }
        }

        @Override
        protected boolean isBrowseEnabled() {
            return true;
        }
    }
}

