/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz;

import com.kingdee.bos.ctrl.reportone.kdrs.biz.IBizContext;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.security.IBizSecurity;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.system.IBizSystem;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.IKdrsEngine;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.ISession;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;

public abstract class AbstractBizContext
implements IBizContext {
    public static final String CTX_ORG = "Org";
    public static final String CTX_USER = "User";
    public static final String CTX_LANG = "Lang";
    public static final String CTX_STORAGE = "Storage";
    private ISession session = null;

    protected abstract IKdrsEngine getKdrsEngine();

    protected abstract ISession doLogin(String var1, String var2, String var3, String var4, String var5) throws KDRSException;

    @Override
    public void login(String url, String org, String user, String pwd, String lang) throws KDRSException {
        this.session = this.doLogin(url, org, user, pwd, lang);
    }

    @Override
    public void logout() throws KDRSException {
        this.getKdrsEngine().logout(this.session);
    }

    @Override
    public IBizContent getBizContent() throws KDRSException {
        return (IBizContent)this.getKdrsEngine().getBizObject(IBizContent.class, this.session);
    }

    @Override
    public IBizSecurity getBizSecurity() throws KDRSException {
        return (IBizSecurity)this.getKdrsEngine().getBizObject(IBizSecurity.class, this.session);
    }

    @Override
    public IBizStorage getBizStorage() throws KDRSException {
        return (IBizStorage)this.getKdrsEngine().getBizObject(IBizStorage.class, this.session);
    }

    @Override
    public IBizSystem getBizSystem() throws KDRSException {
        return (IBizSystem)this.getKdrsEngine().getBizObject(IBizSystem.class, this.session);
    }

    @Override
    public Object put(Object key, Object val) {
        if (this.session == null) {
            return null;
        }
        return this.session.setProperty(key, val);
    }

    @Override
    public Object remove(Object key) {
        if (this.session == null) {
            return null;
        }
        return this.session.removeProperty(key);
    }

    @Override
    public Object get(Object key) {
        if (this.session == null) {
            return null;
        }
        return this.session.getProperty(key);
    }

    public ISession getSesstion() {
        return this.session;
    }
}

