/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.service;

import com.kingdee.bos.ctrl.common.util.ExceptionUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.server.IServerSideEngine;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.AbstractKdrsBosEngine;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.KdrsBosServerEngine;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.common.IBosSystem;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.AbstractService;
import org.apache.log4j.Logger;

public class BosSystemService
extends AbstractService
implements IBosSystem {
    public static final Logger log = LogUtil.getLogger(BosSystemService.class);

    @Override
    public String login(String ais, String lang) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ais=" + ais + ",lang=" + lang));
        }
        try {
            String sid = ((AbstractKdrsBosEngine)((Object)this.getEngine())).login(ais, lang).getSid();
            log.info((Object)("return session-id:'" + sid + "'"));
            return sid;
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
    }

    @Override
    public void logout(String sid) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sid=" + sid));
        }
        try {
            ((AbstractKdrsBosEngine)((Object)this.getEngine())).logout(this.checkSession(sid));
            log.info((Object)("session:'" + sid + "' logout!"));
        }
        catch (Exception ex) {
            log.error((Object)ExceptionUtil.findMessage((Throwable)ex), (Throwable)ex);
            throw KDRSException.makeException(ex);
        }
    }

    @Override
    public IServerSideEngine getEngine() throws KDRSException {
        if (this.serverEngine == null) {
            this.serverEngine = KdrsBosServerEngine.getInstance();
        }
        return super.getEngine();
    }
}

