/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.InputSource;

public class KdrsDBStorageConfigure {
    private DBInfo dbInfo;

    public KdrsDBStorageConfigure(Element e) {
        String dbId = e.getAttributeValue("db-id");
        DBConfig dbCnf = DBConnection.instance().getDBConfig();
        this.setDbInfo(dbCnf.getDBInfo(dbId));
    }

    public void setDbInfo(DBInfo dbInfo) {
        this.dbInfo = dbInfo;
    }

    public DBInfo getDbInfo() {
        return this.dbInfo;
    }

    public static class DBConfig {
        private File configFile;
        private Document doc;
        private Element root;
        private HashMap infoMap;
        private DBInfo[] dbis;
        public static final String SAX_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";

        public DBConfig(String fileName) {
            this.configFile = new File(fileName);
            if (!this.configFile.exists()) {
                throw new RuntimeException("Can not find Config file: " + fileName);
            }
            this.loadFile();
        }

        public DBInfo getDBInfo(String id) {
            return (DBInfo)this.infoMap.get(id);
        }

        public DBInfo getDBInfo(int idx) {
            if (this.dbis == null) {
                this.dbis = this.infoMap.values().toArray(new DBInfo[0]);
            }
            if (idx < 0 || idx >= this.dbis.length) {
                return null;
            }
            return this.dbis[idx];
        }

        public int getDBInfoSize() {
            return this.infoMap.size();
        }

        private void loadFile() {
            try {
                SAXBuilder builder = new SAXBuilder(SAX_PARSER_NAME);
                this.doc = builder.build(new InputSource(new FileInputStream(this.configFile)));
            }
            catch (JDOMException err) {
                throw new RuntimeException("Error on analysis XML file, info: " + err.getMessage());
            }
            catch (IOException err) {
                throw new RuntimeException("Failed loading file");
            }
            this.root = this.doc.getRootElement();
            this.infoMap = new HashMap();
            List dbconns = this.root.getChildren("DBConnection");
            if (dbconns.size() > 0) {
                for (int i = 0; i < dbconns.size(); ++i) {
                    Element ele = (Element)dbconns.get(i);
                    DBInfo dbi = new DBInfo();
                    dbi.id = ele.getAttributeValue("id");
                    dbi.connection = ele.getChildText("Connection");
                    dbi.dbType = ele.getChildText("DBType");
                    dbi.driver = ele.getChildText("Driver");
                    dbi.user = ele.getChildText("User");
                    dbi.pwd = ele.getChildText("Password");
                    this.infoMap.put(dbi.id, dbi);
                }
            } else {
                DBInfo dbi = new DBInfo();
                dbi.id = "default";
                dbi.connection = this.root.getChildText("Connection");
                dbi.dbType = this.root.getChildText("DBType");
                dbi.driver = this.root.getChildText("Driver");
                dbi.user = this.root.getChildText("User");
                dbi.pwd = this.root.getChildText("Password");
                this.infoMap.put(dbi.id, dbi);
            }
        }
    }

    public static class DBInfo {
        public String id;
        public String dbType;
        public String driver;
        public String connection;
        public String user;
        public String pwd;
        public static final Namespace NS_COMMON = Namespace.getNamespace((String)"c", (String)"http://www.kingdee.com/Common");
        private static final DBInfo[] DBIZ = new DBInfo[0];

        public Element writeToNode() {
            Element elem = new Element("DBConnection", NS_COMMON);
            elem.setAttribute("id", this.id == null ? "" : this.id);
            Element e1 = new Element("DBType", NS_COMMON);
            e1.setText(this.dbType);
            Element e2 = new Element("Driver", NS_COMMON);
            e2.setText(this.driver);
            Element e3 = new Element("Connection", NS_COMMON);
            e3.setText(this.connection);
            Element e4 = new Element("User", NS_COMMON);
            e4.setText(this.user);
            Element e5 = new Element("Password", NS_COMMON);
            e5.setText(this.pwd);
            elem.addContent((Content)e1);
            elem.addContent((Content)e2);
            elem.addContent((Content)e3);
            elem.addContent((Content)e4);
            elem.addContent((Content)e5);
            return elem;
        }

        public static DBInfo[] parse(Element elem) {
            if (elem != null) {
                ArrayList<DBInfo> al = new ArrayList<DBInfo>();
                if ("DBConnections".equals(elem.getName().trim())) {
                    for (Element ele : elem.getChildren("DBConnection", NS_COMMON)) {
                        DBInfo dbi = new DBInfo();
                        dbi.id = ele.getAttributeValue("id");
                        dbi.connection = ele.getChildText("Connection", ele.getNamespace());
                        dbi.dbType = ele.getChildText("DBType", ele.getNamespace());
                        dbi.driver = ele.getChildText("Driver", ele.getNamespace());
                        dbi.user = ele.getChildText("User", ele.getNamespace());
                        dbi.pwd = ele.getChildText("Password", ele.getNamespace());
                        al.add(dbi);
                    }
                } else if ("DBConnection".equals(elem.getName().trim())) {
                    DBInfo dbi = new DBInfo();
                    dbi.id = elem.getAttributeValue("id");
                    dbi.connection = elem.getChildText("Connection", elem.getNamespace());
                    dbi.dbType = elem.getChildText("DBType", elem.getNamespace());
                    dbi.driver = elem.getChildText("Driver", elem.getNamespace());
                    dbi.user = elem.getChildText("User", elem.getNamespace());
                    dbi.pwd = elem.getChildText("Password", elem.getNamespace());
                    al.add(dbi);
                }
                return al.toArray(new DBInfo[0]);
            }
            return DBIZ;
        }
    }

    public static class DBConnection {
        private static DBConnection instance;
        private DBConfig dbcfg;

        private DBConnection(DBConfig cfg) {
            this.dbcfg = cfg;
        }

        public DBConfig getDBConfig() {
            return this.dbcfg;
        }

        public static DBConnection instance() {
            if (instance == null) {
                File mFile = GlobalLocator.getInstance().locateResourceFile("/server/DBConfig.xml");
                DBConfig dbcfg = new DBConfig(mFile.getPath());
                instance = new DBConnection(dbcfg);
            }
            return instance;
        }
    }
}

