/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.frameworks.standard.rpc.client;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PrintMessageHelper;
import com.kingdee.bos.ctrl.reportone.kdrs.engine.ISession;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.log4j.Logger;

public class RpcBizObjectFactory {
    public static final Logger log = LogUtil.getLogger(RpcBizObjectFactory.class);

    public static Object createBizObject(ISession session, Object serviceObject, Class bizClass) {
        RpcBizObjectInvoker handler = new RpcBizObjectInvoker(serviceObject, session.getSid());
        return Proxy.newProxyInstance(bizClass.getClassLoader(), new Class[]{bizClass}, (InvocationHandler)handler);
    }

    static class RpcBizObjectInvoker
    implements InvocationHandler {
        private static final Logger log = LogUtil.getPackageLogger(RpcBizObjectInvoker.class);
        private Object wsStub;
        private String sid;
        private int invoke_times = 0;

        public RpcBizObjectInvoker(Object wsStub, String sid) {
            this.wsStub = wsStub;
            this.sid = sid;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws KDRSException {
            long l0 = 0L;
            if (log.isDebugEnabled()) {
                l0 = System.currentTimeMillis();
                log.debug((Object)("RpcBizObject invoke[" + this.invoke_times + "]:" + PrintMessageHelper.makeInvokeInfo((Method)method, (Object[])args)));
                ++this.invoke_times;
            }
            Object rv = null;
            Method realMethod = null;
            try {
                Class<?>[] argTypes = method.getParameterTypes();
                Class[] realArgTypes = new Class[argTypes.length + 1];
                System.arraycopy(argTypes, 0, realArgTypes, 1, argTypes.length);
                realArgTypes[0] = String.class;
                realMethod = this.wsStub.getClass().getMethod(method.getName(), realArgTypes);
                Object[] realArgs = new Object[args.length + 1];
                System.arraycopy(args, 0, realArgs, 1, realArgs.length - 1);
                realArgs[0] = this.sid;
                rv = realMethod.invoke(this.wsStub, realArgs);
            }
            catch (Exception ex) {
                KDRSException ex_kdrs = KDRSException.makeException("", ex);
                log.error((Object)"Romote exception[Begin]:", (Throwable)ex_kdrs);
                log.error((Object)"Romote exception[End]:");
                log.error((Object)"Invoke:\n");
                log.error((Object)("Method:" + method + "\n"));
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        log.error((Object)("Arg" + i + ":" + args[i] + "\n"));
                    }
                }
                ex_kdrs.fillInStackTrace();
                throw ex_kdrs;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("RpcBizObject return:" + rv + ",token:" + (System.currentTimeMillis() - l0) + " ms!"));
            }
            return rv;
        }
    }
}

