/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.objectx;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.InvalidParameterException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.AbstractContainerObject;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.AbstractSingleObject;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.AbstractStoredObject;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.IStoredObject;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.TypesConfigure;
import com.kingdee.bos.ctrl.reportone.kdrs.objectx.UnsupportInterfaceException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class StoredObjectFactory {
    public static final Logger log = LogUtil.getPackageLogger(StoredObjectFactory.class);
    private static final Class[] folderObjInitArgTypes = new Class[]{IStorage.class, Path.class, String.class, StoredObjectFactory.class};
    private static final Class[] singleObjInitArgTypes = new Class[]{IStorage.class, Path.class, String.class};
    private IStorage storage;
    private TypesConfigure typesConf;
    private String typeKey;
    private HashMap constructor_map;

    public StoredObjectFactory(IStorage storage, TypesConfigure tc, String typeKey) {
        this.storage = storage;
        this.typesConf = tc;
        this.typeKey = typeKey;
        this.constructor_map = new HashMap();
    }

    public TypesConfigure getTypesConf() {
        return this.typesConf;
    }

    public String getTypeKey() {
        return this.typeKey;
    }

    private Constructor getConstructor(Class implCls, Class[] args) throws Exception {
        Constructor c = (Constructor)this.constructor_map.get(implCls);
        if (c == null) {
            c = implCls.getConstructor(args);
            this.constructor_map.put(implCls, c);
        }
        return c;
    }

    public String checkType(HashMap attrs) throws KDRSException {
        if (attrs == null) {
            throw new InvalidParameterException();
        }
        String type = (String)attrs.get(this.typeKey);
        if (type == null && (type = (String)attrs.get("objectType")) == null) {
            type = (String)attrs.get("type");
            if (type != null) {
                type = "File".equals(type) ? "file" : ("Folder".equals(type) ? "folder" : null);
            }
            if (type == null) {
                throw new InvalidParameterException("Couldn't find any type info.");
            }
        }
        return type;
    }

    public IStoredObject load(Path path) throws KDRSException {
        return this.load(path, null);
    }

    public String checkType(Path path, HashMap attrs) throws KDRSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("path:" + path));
            log.debug((Object)("attributes:" + attrs));
        }
        try {
            String type = this.checkType(attrs);
            if (type != null && attrs.get(this.typeKey) == null) {
                this.storage.setAttribute(path, this.typeKey, type);
            }
            return type;
        }
        catch (InvalidParameterException e) {
            if (!path.isRoot()) {
                log.error((Object)("[Resource attrs error]:Path=" + path + ",attributes=" + attrs));
                throw e;
            }
            return "folder";
        }
    }

    public IStoredObject load(Path path, TypesConfigure.TypeMapping typeM) throws KDRSException {
        Class implCls;
        String type;
        HashMap attrs = null;
        if (typeM == null) {
            attrs = this.storage.getAttributes(path);
            type = this.checkType(path, attrs);
            typeM = this.typesConf.findByType(type);
            if (typeM == null) {
                throw new UnsupportInterfaceException("Unknow object type:" + type + ",path=" + path);
            }
        } else {
            type = typeM.getType();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("type=" + type));
        }
        Class clazz = implCls = typeM == null ? null : typeM.getTypeImpl();
        if (implCls == null) {
            throw new UnsupportInterfaceException("Unsupport create target resource:" + typeM.getType() + ",path=" + path);
        }
        try {
            AbstractStoredObject storedObj = null;
            if (AbstractContainerObject.class.isAssignableFrom(implCls)) {
                Constructor c = this.getConstructor(implCls, folderObjInitArgTypes);
                storedObj = (AbstractContainerObject)c.newInstance(this.storage, path, type, this);
            } else if (AbstractSingleObject.class.isAssignableFrom(implCls)) {
                Constructor c = this.getConstructor(implCls, singleObjInitArgTypes);
                storedObj = (AbstractSingleObject)c.newInstance(this.storage, path, type);
            }
            if (storedObj != null) {
                storedObj.preSetAttributesCache(attrs);
                return storedObj;
            }
        }
        catch (Exception ex) {
            throw KDRSException.makeException("", ex);
        }
        throw new UnsupportInterfaceException("Maybe implCls is bad:" + implCls);
    }
}

