/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage;

import com.kingdee.bos.ctrl.reportone.kdrs.storage.IRandomAccessStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class BasicRandomAccessStream
implements IRandomAccessStream {
    private boolean closed = false;
    protected RandomInputStream inputStream = null;
    protected RandomOutputStream outputStream = null;

    protected BasicRandomAccessStream() {
    }

    protected void checkStatus() throws IOException {
        if (this.closed) {
            throw new IOException("Stream was already closed.");
        }
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void setClosed() {
        this.closed = true;
    }

    @Override
    public void close() throws IOException {
        this.checkStatus();
        this.closed = true;
        this.inputStream = null;
        this.outputStream = null;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.checkStatus();
        if (this.inputStream == null) {
            this.inputStream = new RandomInputStream(this);
        }
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.checkStatus();
        if (this.outputStream == null) {
            this.outputStream = new RandomOutputStream(this);
        }
        return this.outputStream;
    }

    protected class RandomOutputStream
    extends OutputStream {
        private IRandomAccessStream stream;

        RandomOutputStream(IRandomAccessStream stream) {
            this.stream = stream;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }
    }

    protected class RandomInputStream
    extends InputStream {
        private IRandomAccessStream stream;

        public RandomInputStream(IRandomAccessStream stream) {
            this.stream = stream;
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            long pos = this.stream.position();
            this.stream.seek(pos + n);
            return this.stream.position() - pos;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }
    }
}

