/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.storage.meta;

import com.kingdee.bos.ctrl.common.NullValue;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IRandomAccessStream;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ISpaceProvider;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.BasicMetas;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.ILazyFolderMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.IResourceMeta;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.meta.MetaIO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class PersistentMetas
extends BasicMetas {
    public static final Logger log = LogUtil.getPackageLogger(PersistentMetas.class);
    public static final String META_FILE = ".meta";
    private static final String ROOT_META_FILE = ".root.meta";
    public static final Path ROOTMETA_PATH = Path.ROOT.getChild(".root.meta");
    private ISpaceProvider space;

    public PersistentMetas(ISpaceProvider space) throws KDRSException {
        this.space = space;
        this.initRootMeta(this.space);
    }

    private void initRootMeta(ISpaceProvider space) throws KDRSException {
        int type = space.exist(ROOTMETA_PATH);
        if (type == 0) {
            this.rootMeta = (ILazyFolderMeta)this.createResourceMeta("", ResourceType.FOLDER);
            this.updateRootMeta();
        } else if (type == 1) {
            this.rootMeta = this.loadRootMeta();
        } else if (type == 2) {
            throw new NotFoundException("Couldn't find root meta file: '" + ROOTMETA_PATH + "'");
        }
        this.rootMeta.setName(Path.ROOT.getName());
    }

    private void updateRootMeta() throws KDRSException {
        Object[] array = new Object[]{this.rootMeta};
        this.saveResourcesMeta(ROOTMETA_PATH, Arrays.asList(array).iterator());
    }

    private ILazyFolderMeta loadRootMeta() throws KDRSException {
        Iterator i = this.loadResourcesMeta(ROOTMETA_PATH);
        return (ILazyFolderMeta)i.next();
    }

    @Override
    public void updateMeta(Path resPath, IResourceMeta meta) throws KDRSException {
        if (resPath.isRoot()) {
            this.updateRootMeta();
            return;
        }
        this.saveResourcesMeta(resPath.getBrother(META_FILE), meta.getParent().getChildren());
    }

    @Override
    protected final Iterator loadChildren(Path folderPath) {
        try {
            return this.loadResourcesMeta(folderPath.getChild(META_FILE));
        }
        catch (NotFoundException e) {
            return NullValue.NULL_ITERATOR;
        }
        catch (KDRSException e) {
            log.error(null, (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateFolderMeta(Path folderPath, ILazyFolderMeta folderMeta) throws KDRSException {
        this.saveResourcesMeta(folderPath.getChild(META_FILE), folderMeta.getChildren());
    }

    protected void saveResourcesMeta(Path metaPath, Iterator children) throws KDRSException {
        OutputStream stream;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save meta file:" + metaPath));
        }
        IRandomAccessStream ras = this.space.openStream(metaPath, true, true, false);
        try {
            stream = ras.getOutputStream();
        }
        catch (IOException ex) {
            try {
                ras.close();
            }
            catch (IOException ex2) {
                log.error((Object)("Close resource meta file faield:" + ex2));
            }
            throw KDRSException.makeException("Preapare write resource meta file failed:" + metaPath, ex);
        }
        Element xmlMeta = MetaIO.makeMeta(children);
        try {
            XmlUtil.saveXmlStream((OutputStream)stream, (Element)xmlMeta);
        }
        catch (IOException ex) {
            throw KDRSException.makeException("Invalid resource meta file format!!!" + metaPath, ex);
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Iterator loadResourcesMeta(Path metaPath) throws KDRSException {
        Element xmlMeta;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Load resource meta file:" + metaPath));
        }
        IRandomAccessStream ras = this.space.openStream(metaPath, false, false, true);
        InputStream stream = null;
        try {
            stream = ras.getInputStream();
            xmlMeta = XmlUtil.loadXmlStream((InputStream)stream);
        }
        catch (IOException ex) {
            try {
                ras.close();
            }
            catch (IOException ex2) {
                log.error((Object)("Close resource meta file faield failed:" + ex2));
            }
            throw KDRSException.makeException("Preapare read resource meta file faield failed:" + metaPath, ex);
        }
        catch (Exception ex) {
            throw KDRSException.makeException("Invalid resource meta file format, not a XML file!!!" + metaPath, ex);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        Iterator itr = MetaIO.parseMeta(xmlMeta);
        if (itr == null) {
            throw new KDRSException("Invalid resource meta file format!!!" + metaPath);
        }
        return itr;
    }

    @Override
    public boolean isReservedPath(Path path) {
        return path.getName().endsWith(META_FILE) || path.equals(ROOTMETA_PATH);
    }
}

