/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.grid;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.AbstractOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.group.R1DataGridGroup;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.DataGridUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class AbstractGroupManageOperate
extends AbstractOperate {
    @Override
    public boolean isNeedShowUI() {
        return true;
    }

    @Override
    public boolean operate() {
        ElementPath elePath = this.getSelected();
        Object objSelected = elePath.getRootPathComponent();
        AbstractDataGrid dataGrid = (AbstractDataGrid)objSelected;
        String dsName = dataGrid.getDataSource().getDs();
        Object data = this.getCore().getModel().getDataManager().getObject(dsName);
        if (data == null) {
            WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("grid.AbstractGroupManageOperate.warning", ""), (String)this.getPromptTitle(), (Component)this.getParentCtrl());
            return false;
        }
        IManageDialog manager = this.createManageDialog();
        manager.setSupplyData((MetaClass)data);
        R1DataGridGroup[] groups = DataGridUtil.getGroups(dataGrid);
        manager.setGroups(groups);
        if (manager.showDialog()) {
            this.getCore().storeUndoState(MultiLanguageUtil.getMLS("grid.AbstractGroupManageOperate.goupManage", ""));
            groups = manager.getGroups();
            this.validResult(groups, dataGrid);
            this.getCore().updateTreeNode(dataGrid);
            this.getCore().getModel().setDirty(true);
            Object eleSelected = elePath.getLastPathComponent();
            if (eleSelected != dataGrid && !dataGrid.isContains(eleSelected)) {
                this.getCore().getSelectionModel().remove(elePath);
                this.getCore().getSelectionModel().add(new ElementPath(objSelected));
            }
            this.getCore().getPageContainer().repaint();
            return true;
        }
        return false;
    }

    protected abstract IManageDialog createManageDialog();

    private void validResult(R1DataGridGroup[] groups, AbstractDataGrid dataGrid) {
        HashMap mapTemps = this.storeOldGroupRow(groups, dataGrid);
        for (int i = dataGrid.getRowsCount() - 1; i >= 0; --i) {
            AbstractRow row = dataGrid.getRow(i);
            if (!(row instanceof AbstractGroupRow)) continue;
            dataGrid.removeRow(row);
        }
        this.addGroupRow(groups, dataGrid, mapTemps);
    }

    private void addGroupRow(R1DataGridGroup[] groups, AbstractDataGrid dataGrid, HashMap mapTempGroups) {
        for (int i = 0; i < groups.length; ++i) {
            int[] x1x2 = dataGrid.locateDetailRow();
            TemporaryGroup tg = (TemporaryGroup)mapTempGroups.get(groups[i]);
            AbstractGroupRow[] rows = tg.getRowsAfterDetail();
            this.insertRows(groups[i], rows, dataGrid, x1x2[1], tg.getMergeBlocksAfterDetail());
            rows = tg.getRowsBeforeDetail();
            this.insertRows(groups[i], rows, dataGrid, x1x2[0], tg.getMergeBlocksBeforeDetail());
        }
    }

    private void insertRows(R1DataGridGroup group, AbstractGroupRow[] rows, AbstractDataGrid dataGrid, int idx, MergeBlock[] mbs) {
        int oldRowsSize = rows.length;
        if (oldRowsSize == 0) {
            AbstractRow row = dataGrid.insertRow(3, idx);
            ((AbstractGroupRow)row).setGroup(group);
            this.getCore().getModel().allotSubElementId(dataGrid, row);
        } else {
            int i;
            for (i = 0; i < oldRowsSize; ++i) {
                dataGrid.insertRow(rows[i], idx + i);
            }
            for (i = 0; i < mbs.length; ++i) {
                MergeBlock bridgeMb = mbs[i];
                int left = bridgeMb.getLeft();
                int right = bridgeMb.getRight();
                int top = bridgeMb.getTop() + idx;
                int bottom = bridgeMb.getBottom() + idx;
                MergeBlock mb = MergeBlock.create(left, right, top, bottom);
                for (int rowIdx = top; rowIdx <= bottom; ++rowIdx) {
                    AbstractRow tempRow = dataGrid.getRow(rowIdx);
                    for (int colIdx = left; colIdx <= right; ++colIdx) {
                        tempRow.getCell(colIdx).setMergeBlock(mb);
                    }
                }
            }
        }
    }

    private HashMap storeOldGroupRow(R1DataGridGroup[] groups, AbstractDataGrid dataGrid) {
        HashMap<R1DataGridGroup, TemporaryGroup> mapTempGroups = new HashMap<R1DataGridGroup, TemporaryGroup>();
        for (int i = 0; i < groups.length; ++i) {
            R1DataGridGroup group = groups[i];
            TemporaryGroup tg = new TemporaryGroup(group);
            tg.storeRowsBeforeDetail(dataGrid);
            tg.storeRowsAfterDetail(dataGrid);
            mapTempGroups.put(group, tg);
        }
        return mapTempGroups;
    }

    protected static interface IManageDialog {
        public void setSupplyData(MetaClass var1);

        public void setGroups(R1DataGridGroup[] var1);

        public R1DataGridGroup[] getGroups();

        public boolean showDialog();
    }

    private static class TemporaryGroup {
        private R1DataGridGroup group;
        private ArrayList rowsBeforeDetail = new ArrayList();
        private ArrayList rowsAfterDetail = new ArrayList();
        private ArrayList mergeBlocksBeforeDetail = new ArrayList();
        private ArrayList mergeBlocksAfterDetail = new ArrayList();

        public TemporaryGroup(R1DataGridGroup g) {
            this.group = g;
        }

        public void storeRowsBeforeDetail(AbstractDataGrid grid) {
            AbstractRow row;
            int groupStartRowIdx = -1;
            int c = grid.getRowsCount();
            for (int i = 0; i < c && !((row = grid.getRow(i)) instanceof AbstractDetailRow); ++i) {
                R1DataGridGroup rowGroup;
                if (!(row instanceof AbstractGroupRow) || !R1DataGridGroup.equals(this.group, rowGroup = ((AbstractGroupRow)row).getGroup())) continue;
                if (groupStartRowIdx == -1) {
                    groupStartRowIdx = i;
                }
                this.rowsBeforeDetail.add(row);
                this.storeMergeBlocks(grid, (AbstractGroupRow)row, i, groupStartRowIdx, this.mergeBlocksBeforeDetail);
            }
        }

        public AbstractGroupRow[] getRowsBeforeDetail() {
            return this.rowsBeforeDetail.toArray(new AbstractGroupRow[0]);
        }

        public MergeBlock[] getMergeBlocksBeforeDetail() {
            return this.mergeBlocksBeforeDetail.toArray(new MergeBlock[0]);
        }

        private void storeMergeBlocks(AbstractDataGrid grid, AbstractGroupRow row, int rowIdx, int groupStartRowIdx, ArrayList mergeBlocks) {
            int jc = row.getCellCount();
            for (int j = 0; j < jc; ++j) {
                AbstractCell cell = row.getCell(j);
                MergeBlock mb = cell.getMergeBlock();
                if (mb == null || !mb.isFirstCell(rowIdx, j)) continue;
                boolean inSameGroup = true;
                for (int idx = mb.getTop() + 1; idx <= mb.getBottom(); ++idx) {
                    AbstractRow compareRow = grid.getRow(idx);
                    if (compareRow instanceof AbstractGroupRow) {
                        R1DataGridGroup compGroup;
                        R1DataGridGroup rowGroup = row.getGroup();
                        if (R1DataGridGroup.equals(rowGroup, compGroup = ((AbstractGroupRow)compareRow).getGroup())) continue;
                        inSameGroup = false;
                        break;
                    }
                    inSameGroup = false;
                    break;
                }
                if (!inSameGroup) continue;
                MergeBlock bridgeMb = MergeBlock.create(mb.getLeft(), mb.getRight(), mb.getTop() - groupStartRowIdx, mb.getBottom() - groupStartRowIdx);
                mergeBlocks.add(bridgeMb);
            }
        }

        public void storeRowsAfterDetail(AbstractDataGrid grid) {
            int idxAfterDetail;
            int groupStartRowIdx = -1;
            int c = grid.getRowsCount();
            for (int i = idxAfterDetail = grid.locateDetailRow()[1]; i < c; ++i) {
                R1DataGridGroup rowGroup;
                AbstractRow row = grid.getRow(i);
                if (!(row instanceof AbstractGroupRow) || !R1DataGridGroup.equals(this.group, rowGroup = ((AbstractGroupRow)row).getGroup())) continue;
                if (groupStartRowIdx == -1) {
                    groupStartRowIdx = i;
                }
                this.rowsAfterDetail.add(row);
                this.storeMergeBlocks(grid, (AbstractGroupRow)row, i, groupStartRowIdx, this.mergeBlocksAfterDetail);
            }
        }

        public AbstractGroupRow[] getRowsAfterDetail() {
            return this.rowsAfterDetail.toArray(new AbstractGroupRow[0]);
        }

        public MergeBlock[] getMergeBlocksAfterDetail() {
            return this.mergeBlocksAfterDetail.toArray(new MergeBlock[0]);
        }
    }
}

