/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui;

import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.exception.R1DesignerRuntimeException;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.AbstractR1Designer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.IReportUI;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.State;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mdi.DesignerMdiDesktopPane;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mdi.DesignerMdiFrame;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mdi.DesignerMenuBar;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mdi.MdiState;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.owner.IR1DesignerOwner;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyVetoException;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.jdom2.Element;

public abstract class AbstractR1MdiDesigner
extends AbstractR1Designer {
    private DesignerMenuBar _mdiMenuBar;
    private DesignerMdiDesktopPane _mdiDesktop;

    public AbstractR1MdiDesigner(IR1DesignerOwner owner) {
        super(owner);
    }

    @Override
    public void init() {
        super.init();
        this.getState().setStateMark(4096L, false);
        this.fireStateChangedEvent(this.getState());
        this.installListener();
    }

    private void installListener() {
        final DesignerMdiDesktopPane mdiDesktop = (DesignerMdiDesktopPane)((Object)this.getTopPane());
        mdiDesktop.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
                AbstractR1MdiDesigner.this.getState().setStateMark(4096L, this.isMdiFrameExist());
                AbstractR1MdiDesigner.this.fireStateChangedEvent(AbstractR1MdiDesigner.this.getState());
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                AbstractR1MdiDesigner.this.getState().setStateMark(4096L, this.isMdiFrameExist());
                AbstractR1MdiDesigner.this.fireStateChangedEvent(AbstractR1MdiDesigner.this.getState());
            }

            private boolean isMdiFrameExist() {
                return mdiDesktop.getAllFrames().length > 0;
            }
        });
    }

    @Override
    protected KDMenuBar getMenuBar() {
        if (this._mdiMenuBar == null) {
            this._mdiMenuBar = new DesignerMenuBar();
        }
        return this._mdiMenuBar;
    }

    @Override
    protected Container getTopPane() {
        if (this._mdiDesktop == null) {
            this._mdiDesktop = new DesignerMdiDesktopPane();
        }
        return this._mdiDesktop;
    }

    @Override
    protected State getState() {
        if (this._state == null) {
            this._state = new MdiState();
        }
        return this._state;
    }

    @Override
    public ComboPanel getCore() {
        return this.getCurrentFrame().getCore();
    }

    public DesignerMdiFrame getCurrentFrame() {
        DesignerMdiDesktopPane mdiDesktop = (DesignerMdiDesktopPane)((Object)this.getTopPane());
        if (mdiDesktop.getSelectedFrame() != null && mdiDesktop.getSelectedFrame() instanceof DesignerMdiFrame) {
            return (DesignerMdiFrame)((Object)mdiDesktop.getSelectedFrame());
        }
        throw new R1DesignerRuntimeException("There's no MDIFrame selected.");
    }

    public IReportUI newReport(Object data) {
        IR1Page page = this.createXmlReaderWriterFactory().createXmlReader().createPage();
        IR1DataManager dm = this.createDataManager();
        ReportModel model = ReportModel.createModel(page, dm);
        DesignerMdiFrame ui = this.createMdiFrame();
        ui.getCore().setModel(model);
        return ui;
    }

    @Override
    public IReportUI loadReport(Element root) throws R1Exception {
        DesignerMdiFrame ui = this.createMdiFrame();
        ReportModel model = ui.getCore().createXmlReader().fromXml(root, this.getDataXmlTrans());
        ui.getCore().setModel(model);
        return ui;
    }

    private DesignerMdiFrame createMdiFrame() {
        DesignerMdiFrame frame = new DesignerMdiFrame(this.getToolboxConfigCreator());
        frame.addSelectionChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractR1MdiDesigner.this.fireStateChangedEvent(e);
            }
        });
        this._mdiDesktop.add((Component)((Object)frame), JLayeredPane.DEFAULT_LAYER);
        this._mdiDesktop.getDesktopManager().activateFrame((JInternalFrame)((Object)frame));
        frame.setVisible(true);
        frame.setMenu((DesignerMenuBar)this.getMenuBar());
        try {
            frame.setMaximum(true);
            frame.setSelected(true);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        return frame;
    }

    @Override
    public void removeReport() {
    }
}

