/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.common;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.border.Border;

public class RadioButtonGroup {
    private CustomButtonGroup _group = new CustomButtonGroup();

    public void add(KDRadioButton btn) {
        this._group.add((AbstractButton)btn);
    }

    public void add(KDRadioButton btn, Object userObject) {
        btn.setUserObject(userObject);
        this.add(btn);
    }

    public Enumeration getButtons() {
        return this._group.getElements();
    }

    public KDRadioButton getSelected() {
        Enumeration<AbstractButton> enumeration = this._group.getElements();
        while (enumeration.hasMoreElements()) {
            KDRadioButton btn = (KDRadioButton)enumeration.nextElement();
            if (!btn.isSelected()) continue;
            return btn;
        }
        return null;
    }

    public void setSelectedValue(Object value) {
        Enumeration enumeration = this.getButtons();
        while (enumeration.hasMoreElements()) {
            KDRadioButton btn = (KDRadioButton)enumeration.nextElement();
            if (!value.equals(btn.getUserObject())) continue;
            btn.setSelected(true);
            return;
        }
    }

    public void setSelectedValueUnsure() {
        this._group.clearSelected();
    }

    public Object getSelectedValue() {
        KDRadioButton btn = this.getSelected();
        if (btn == null) {
            return null;
        }
        return this.getSelected().getUserObject();
    }

    public KDPanel createTitlePane(String title, boolean isHorizontal) {
        int c = this._group.getButtonCount();
        return this.createTitlePane(title, isHorizontal ? 1 : c, isHorizontal ? c : 1);
    }

    public KDPanel createTitlePane(String title, int row, int col) {
        TableLayout tl = TableLayout.split((int)(row + 1), (int)col);
        tl.style().setMargin(10, 20, 10, 10);
        tl.defaultStyle().setMarginBottom(3);
        tl.rowStyle(row).setPriY(1);
        KDPanel pan = new KDPanel((LayoutManager)tl);
        pan.setBorder((Border)BorderFactory.createTitledBorder(title));
        Enumeration<AbstractButton> enumeration = this._group.getElements();
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                if (enumeration.hasMoreElements()) {
                    pan.add((Component)((KDRadioButton)enumeration.nextElement()), (Object)tl.cell(i, j));
                    continue;
                }
                pan.add((Component)new KDLabel(), (Object)tl.cell(i, j));
            }
        }
        return pan;
    }

    static class CustomButtonGroup
    extends ButtonGroup {
        CustomButtonGroup() {
        }

        public void clearSelected() {
            int c = this.buttons.size();
            for (int i = 0; i < c; ++i) {
                KDRadioButton btn = (KDRadioButton)this.buttons.get(0);
                this.remove((AbstractButton)btn);
                btn.setSelected(false);
                this.add((AbstractButton)btn);
            }
        }
    }
}

