/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.ReportObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.event.MouseStateEvent;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.event.MouseStateListener;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ToolboxGroup;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.MouseOperateState;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.toolbox.IToolboxItem;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ActiveTabbedUI;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDToggleButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.ChangeListener;

public class Toolbox {
    private KDPanel _panel;
    private ActiveTabbedUI _ui;
    private ChangeListener _changeListener;
    private final MousesStateHandler _mousesStateHandler = new MousesStateHandler();
    private ReportObjectFactory _objectFactory;

    public Toolbox(ReportObjectFactory factory) {
        this._objectFactory = factory;
        this._ui = new ActiveTabbedUI();
        this._ui.addGroupChangedListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ToolboxGroup oldGroup = (ToolboxGroup)evt.getOldValue();
                oldGroup.setArrowSelected();
                ToolboxGroup newGroup = (ToolboxGroup)evt.getOldValue();
                newGroup.setArrowSelected();
            }
        });
    }

    public KDPanel getPanel() {
        if (this._panel == null) {
            this._panel = new KDPanel((LayoutManager)new BorderLayout());
        }
        return this._panel;
    }

    public void validateContent() {
        this.getPanel().add((Component)this._ui.createPanel(), (Object)"Center");
    }

    ReportObjectFactory getReportObjectFactory() {
        return this._objectFactory;
    }

    private ToolboxGroup getCurrentGroup() {
        return (ToolboxGroup)this._ui.getCurrentGroup();
    }

    public void addGroup(ToolboxGroup group) {
        this._ui.addGroup(group);
        if (this._changeListener != null) {
            group.setButtonSelectedChangeListener(this._changeListener);
        }
    }

    public void setButtonSelectedChangeListener(ChangeListener l) {
        this._changeListener = l;
        if (this._ui.getGroups().size() > 0) {
            this.passListener(l);
        }
    }

    private void passListener(ChangeListener l) {
        for (ToolboxGroup group : this._ui.getGroups()) {
            group.setButtonSelectedChangeListener(l);
        }
    }

    public void updateMouseOperateState(MouseOperateState state) {
        ToolboxGroup group = this.getCurrentGroup();
        if (group.isArrowSelected()) {
            state.setOperate(0);
            state.removeMouseStateListener(this._mousesStateHandler);
        } else {
            KDToggleButton btn = group.getSelectedButton();
            String type = ((IToolboxItem)btn.getUserObject()).getKey();
            state.setOperate(3);
            state.setCreateType(type);
            state.addMouseStateListener(this._mousesStateHandler);
        }
    }

    class MousesStateHandler
    implements MouseStateListener {
        MousesStateHandler() {
        }

        @Override
        public void afterCreated(MouseStateEvent evt) {
            Toolbox.this.getCurrentGroup().setArrowSelected();
        }
    }
}

