/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.undo;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.undo.Memo;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IDataXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlReader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.LimitedSizeStack;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class UndoHelper {
    private static final Logger log = LogUtil.getPackageLogger(UndoHelper.class);
    private LimitedSizeStack _undoStack = new LimitedSizeStack(10);
    private LimitedSizeStack _redoStack = new LimitedSizeStack(10);
    private ComboPanel _core;
    private Memo _backupCurrent;
    private IDataXmlTrans _dataXmlTrans;

    public UndoHelper(ComboPanel core) {
        this._core = core;
    }

    public void store(String prompt) {
        try {
            Memo memo = this.createCurrentMemo();
            memo.setPrompt(prompt);
            this._undoStack.push(memo);
        }
        catch (Exception e) {
            log.error((Object)"\u8bb0\u5f55Undo\u72b6\u6001\u65f6\u51fa\u5f02\u5e38\u3002", (Throwable)e);
        }
        this._redoStack.clear();
        this._backupCurrent = null;
    }

    private Memo createCurrentMemo() {
        Element root = this._core.createXmlWriter().toXml(this._core.getModel(), this._dataXmlTrans);
        return new Memo(root, this._core.getSelectionModel().getAll());
    }

    public void undo() {
        if (this.isCanUndo()) {
            Memo temp = (Memo)this._undoStack.pop();
            if (this._backupCurrent == null) {
                this._backupCurrent = this.createCurrentMemo();
            }
            this._backupCurrent.setPrompt(temp.getPrompt());
            this._redoStack.push(this._backupCurrent);
            this._backupCurrent = temp;
            this.updateCore(this._backupCurrent);
        }
    }

    public void redo() {
        if (this.isCanRedo()) {
            Memo temp = (Memo)this._redoStack.pop();
            if (this._backupCurrent == null) {
                this._backupCurrent = this.createCurrentMemo();
            }
            this._backupCurrent.setPrompt(temp.getPrompt());
            this._undoStack.push(this._backupCurrent);
            this._backupCurrent = temp;
            this.updateCore(this._backupCurrent);
        }
    }

    private void updateCore(Memo meno) {
        ReportModel model;
        try {
            IR1XmlReader xmlReader = this._core.createXmlReader();
            xmlReader.setUpgradable(false);
            model = xmlReader.fromXml(meno.getReportXml(), this._dataXmlTrans);
        }
        catch (R1Exception e) {
            log.error((Object)"\u6062\u590d\u72b6\u6001\u65f6\u51fa\u5f02\u5e38\u3002", (Throwable)e);
            return;
        }
        this._core.setModel(model);
        this._core.setSelection(meno.getSelection(model));
    }

    public boolean isCanUndo() {
        return !this._undoStack.isEmpty();
    }

    public boolean isCanRedo() {
        return !this._redoStack.isEmpty();
    }

    public void setDataXmlTrans(IDataXmlTrans dataXmlTrans) {
        this._dataXmlTrans = dataXmlTrans;
    }
}

