/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io;

import com.kingdee.bos.ctrl.data.modal.io.ParameterIO;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.exception.InvalidDataException;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportSelectionModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IDataXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlReader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlRecursiveReader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.StyleCache;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.upgrade.IR1XmlUpgradeChain;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.upgrade.IR1XmlUpgrader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.xmltrans.IObjectXmlTrans;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Element;

public abstract class AbstractR1XmlReader
implements IR1XmlRecursiveReader,
IR1XmlReader {
    private StyleCache _styleCache = new StyleCache();
    private List _xmlTransChain;
    private String _readingWarning;
    private boolean _upgradable = true;

    protected StyleCache getStyleCache() {
        return this._styleCache;
    }

    @Override
    public void setXmlTransChain(List list) {
        this._xmlTransChain = list;
    }

    @Override
    public ReportSelectionModel selectionFromXml(Element root) throws R1Exception {
        if (root != null) {
            int i;
            this.getStyleCache().cacheStyleFromXml(root);
            ReportSelectionModel model = new ReportSelectionModel();
            Element nodeSelections = root.getChild("Selections");
            String strIds = nodeSelections.getText();
            String[] strsIds = strIds.split(",");
            HashMap<String, IElement> id2Obj = new HashMap<String, IElement>();
            Element nodeObjects = root.getChild("Objects");
            List list = nodeObjects.getChildren();
            ICompositeObject compositeObject = null;
            for (i = 0; i < list.size(); ++i) {
                IReportObject ro = this.parseObject(this, (Element)list.get(i), this.getStyleCache());
                id2Obj.put(ro.getId(), ro);
                if (!(ro instanceof ICompositeObject)) continue;
                compositeObject = (ICompositeObject)((Object)ro);
                IElement[] eles = compositeObject.getAllSubElements();
                for (int k = 0; k < eles.length; ++k) {
                    id2Obj.put(eles[k].getId(), eles[k]);
                }
            }
            for (i = 0; i < strsIds.length; ++i) {
                IElement ele = (IElement)id2Obj.get(strsIds[i]);
                ElementPath path = ele instanceof IReportObject ? new ElementPath(ele) : compositeObject.makeElementPath(ele);
                model.add(path);
            }
            return model;
        }
        return null;
    }

    private void upgrade(Element root) {
        if (this._upgradable) {
            IR1XmlUpgradeChain chain = this.createUpgradeChain();
            if (chain == null) {
                return;
            }
            for (IR1XmlUpgrader upgrader : chain.getUpgraders()) {
                String nodeName = upgrader.applicableNode();
                Element node = root.getChild(nodeName);
                if (node == null || !upgrader.checkVersion(node)) continue;
                upgrader.upgrade(node);
            }
        }
    }

    @Override
    public ReportModel fromXml(Element root, IDataXmlTrans dataXmlTrans) throws R1Exception {
        this._readingWarning = null;
        if (root != null) {
            this.upgrade(root);
            this.getStyleCache().cacheStyleFromXml(root);
            ReportModel model = new ReportModel(this.createDataManager());
            model.setParams(ParameterIO.parseParameters((Element)root.getChild("Parameters")));
            Element nodeDatas = root.getChild("DataSources");
            try {
                dataXmlTrans.fromXml(nodeDatas, model.getDataManager());
            }
            catch (InvalidDataException e) {
                this._readingWarning = e.getMessage();
            }
            this.parseModel(root, model);
            this.parseOthers(model, root);
            return model;
        }
        return null;
    }

    protected abstract void parseModel(Element var1, ReportModel var2) throws R1Exception;

    protected abstract void parseOthers(ReportModel var1, Element var2) throws R1Exception;

    @Override
    public IReportObject parseObject(IR1XmlRecursiveReader reader, Element node, StyleCache styleCache) throws R1Exception {
        if (this._xmlTransChain == null) {
            return null;
        }
        for (Object objTrans : this._xmlTransChain) {
            IObjectXmlTrans trans;
            IReportObject ro;
            if (!(objTrans instanceof IObjectXmlTrans) || (ro = (trans = (IObjectXmlTrans)objTrans).fromXml(reader, node, styleCache)) == null) continue;
            return ro;
        }
        return null;
    }

    @Override
    public String getWarning() {
        return this._readingWarning;
    }

    @Override
    public void setUpgradable(boolean upgradable) {
        this._upgradable = upgradable;
    }

    @Override
    public String checkVersionTooMordern(Element root) {
        return null;
    }
}

