/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.operate;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;

public class GridLineAdjustRenderer {
    private static Color operRectColor = Color.DARK_GRAY;
    private static Stroke operLine = new BasicStroke(2.0f);

    public void draw(Graphics g, Rectangle oldRect, Rectangle newRect, boolean isHorizontalAdjust, int objMax) {
        Graphics2D g2d = (Graphics2D)g;
        Color oriColor = g.getColor();
        Stroke oriStroke = g2d.getStroke();
        g2d.setStroke(operLine);
        g.setColor(Color.WHITE);
        g.setXORMode(operRectColor);
        if (oldRect != null) {
            this.drawing(g, oldRect, isHorizontalAdjust, objMax);
        }
        if (newRect != null) {
            this.drawing(g, newRect, isHorizontalAdjust, objMax);
        }
        g.setColor(oriColor);
        g2d.setStroke(oriStroke);
    }

    private void drawing(Graphics g, Rectangle rect, boolean isHorizontalAdjust, int objMax) {
        g.drawRect(rect.x, rect.y, rect.width, rect.height);
        if (isHorizontalAdjust) {
            if (rect.x > objMax) {
                g.drawLine(objMax, rect.y, rect.x, rect.y);
                g.drawLine(objMax, rect.y + rect.height, rect.x, rect.y + rect.height);
            }
        } else if (rect.y > objMax) {
            g.drawLine(rect.x, objMax, rect.x, rect.y);
            g.drawLine(rect.x + rect.width, objMax, rect.x + rect.width, rect.y);
        }
    }
}

