/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.util;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import java.awt.Point;

public class ContainerUtil {
    public static Point getPointAtPage(IReportObject reportObject) {
        if (reportObject instanceof IR1Page) {
            return new Point(0, 0);
        }
        Point ptRect = new Point(reportObject.getXLom(), reportObject.getYLom());
        Util.lom2Pixel(ptRect);
        ElementPath parentPath = reportObject.getParent();
        IContainer eleParent = (IContainer)parentPath.getLastPathComponent();
        while (!(eleParent instanceof IR1Page)) {
            IReportObject roParent = (IReportObject)parentPath.getRootPathComponent();
            Point ptTemp = new Point(roParent.getXLom(), roParent.getYLom());
            ptTemp.translate(eleParent.getInsetsXLom(), eleParent.getInsetsYLom());
            Util.lom2Pixel(ptTemp);
            if (roParent instanceof ICompositeObject) {
                ICompositeObject co = (ICompositeObject)((Object)roParent);
                Point relaToRo = co.getRelativePosition((IElement)((Object)eleParent));
                ptTemp.translate(relaToRo.x, relaToRo.y);
            }
            ptRect.translate(ptTemp.x, ptTemp.y);
            parentPath = roParent.getParent();
            eleParent = (IContainer)parentPath.getLastPathComponent();
        }
        if (eleParent instanceof IR1Page) {
            IR1Page page = (IR1Page)eleParent;
            ptRect.translate(Util.lom2Pixel(page.getInsetsXLom()), Util.lom2Pixel(page.getInsetsYLom()));
        }
        return ptRect;
    }

    public static int searchChildrenMaxRight(IContainer ctn) {
        int max = 0;
        if (ctn.getChildrenCount() > 0) {
            for (IReportObject ro : ctn.getChildren()) {
                int right;
                if (ro.isHorizontalFill() || (right = ro.getXLom() + ro.getWidthLom()) <= max) continue;
                max = right;
            }
        }
        return max;
    }

    public static int searchChildrenMaxBottom(IContainer ctn) {
        int max = 0;
        if (ctn.getChildrenCount() > 0) {
            for (IReportObject ro : ctn.getChildren()) {
                int bottom;
                if (ro.isVerticalFill() || (bottom = ro.getYLom() + ro.getHeightLom()) <= max) continue;
                max = bottom;
            }
        }
        return max;
    }

    public static void layoutChildren(IReportObject ro) {
        ro.afterAdjusted();
        if (ro instanceof IContainer) {
            ((IContainer)((Object)ro)).layout();
        } else if (ro instanceof ICompositeContainer) {
            ((ICompositeContainer)((Object)ro)).layoutAllSubContainer();
        }
    }
}

