/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.wizard.datagrid;

import com.kingdee.bos.ctrl.common.ui.NormalSelector;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.wizard.datagrid.AbstractGridCreatorStep;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.wizard.datagrid.GroupObject;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.wizard.datagrid.ListGroupStatRenderer;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.wizard.datagrid.MultiColorField;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.wizard.datagrid.MultiColorRenderer;
import com.kingdee.bos.ctrl.swing.KDList;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;

class StepSelectGroup
extends AbstractGridCreatorStep {
    private GroupSelector _selector;

    StepSelectGroup() {
    }

    private GroupSelector getSelector() {
        if (this._selector == null) {
            this._selector = new GroupSelector();
        }
        return this._selector;
    }

    @Override
    protected JComponent getRealContent() {
        return this.getSelector();
    }

    @Override
    protected String getPromptText() {
        return "\u9009\u4e2d\u5de6\u8fb9\u7684\u5b57\u6bb5\uff0c\u6dfb\u52a0\u5230\u53f3\u8fb9\uff0c\u5c06\u521b\u5efa\u8be5\u5b57\u6bb5\u7684\u5206\u7ec4\u3002\u53f3\u8fb9\u7684\u5df2\u521b\u5efa\u5206\u7ec4\uff0c\u4ece\u4e0a\u5230\u4e0b\uff0c\u5bf9\u5e94\u4ece\u5916\u5c42\u5230\u91cc\u5c42\u3002";
    }

    public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
        if (!isOppose) {
            this.prepareSupply();
            this.getSelector().setGroupObjects(this.getModel().getGroups());
        }
    }

    public IWizardStep outThisStep(boolean isOppose) {
        this.getModel().setGroups(this.getSelector().getGroupObject());
        return null;
    }

    public boolean isReturnable() {
        return true;
    }

    public void initStep(WizardDialog.StepsManager manager) {
    }

    private void prepareSupply() {
        KDList list = this.getSelector().getSupplyCtrl();
        list.setCellRenderer((ListCellRenderer)((Object)new MultiColorRenderer()));
        list.removeAllElements();
        Iterator it = this.getModel().getSelectedDataSource().getFields().iterator();
        int insertIndex = 0;
        while (it.hasNext()) {
            MetaField mf = (MetaField)it.next();
            MultiColorField field = MultiColorField.create(mf);
            if (this.getModel().isFieldSelected(field)) {
                list.insertElement((Object)field, insertIndex++);
                field.setForeground(Color.BLUE);
                continue;
            }
            list.addElement((Object)field);
        }
        this.getSelector().getSupplyCtrl().setSelectedIndex(0);
        this.getSelector().syncButton();
    }

    public void destroy(boolean isFinished) {
    }

    private String getStepName() {
        return "\u521b\u5efa\u5206\u7ec4";
    }

    class GroupSelector
    extends NormalSelector {
        private KDList lstSupply;

        public GroupSelector() {
            this.init();
        }

        private void init() {
            this.lstSupply = new KDList();
            this.lstSupply.setSelectionMode(0);
            this.setSupplyCtrl((JComponent)this.lstSupply);
            this.setSupplyTitle("\u5907\u9009\u5b57\u6bb5");
            this.setSelectedTitle("\u521b\u5efa\u5206\u7ec4");
            this.enableSelectAll(false);
            this.getSelectedList().setCellRenderer((ListCellRenderer)new ListGroupStatRenderer());
        }

        public KDList getSupplyCtrl() {
            return this.lstSupply;
        }

        public void syncButton() {
            this.syncListViewButton();
        }

        protected void onSelect() {
            int currentSupplyIdx;
            Object objToSelect = this.getSupplyCtrl().getSelectedValue();
            if (objToSelect != null) {
                Field mf = (Field)objToSelect;
                int currectIdx = this.getSelectedList().getSelectedIndex();
                if (this.selectedContains(mf)) {
                    StringBuffer sbExist = new StringBuffer();
                    sbExist.append(mf);
                    sbExist.append("\u5df2\u521b\u5efa\u5206\u7ec4\u3002");
                    WindowUtil.msgboxWarning((Object)sbExist.toString(), (String)StepSelectGroup.this.getStepName(), (Component)((Object)this));
                } else {
                    GroupObject groupObject = new GroupObject(mf.getName(), mf.getAlias());
                    this.getSelectedList().insertElement((Object)groupObject, currectIdx + 1);
                    this.getSelectedList().setSelectedValue((Object)groupObject, true);
                }
            }
            if ((currentSupplyIdx = this.getSupplyCtrl().getSelectedIndex()) + 1 < this.getSupplyCtrl().getElementCount()) {
                this.getSupplyCtrl().setSelectedValue(this.getSupplyCtrl().getElement(currentSupplyIdx + 1), true);
            }
        }

        private boolean selectedContains(Field mf) {
            int c = this.getSelectedList().getElementCount();
            for (int i = 0; i < c; ++i) {
                GroupObject go = (GroupObject)this.getSelectedList().getElement(i);
                if (!mf.getName().equals(go.getGroup().getAccording())) continue;
                return true;
            }
            return false;
        }

        private GroupObject[] getGroupObject() {
            ArrayList<Object> result = new ArrayList<Object>();
            KDList listCtrl = this.getSelectedList();
            for (int i = 0; i < listCtrl.getElementCount(); ++i) {
                result.add(listCtrl.getElement(i));
            }
            return result.toArray(new GroupObject[0]);
        }

        private void setGroupObjects(GroupObject[] groupObjects) {
            KDList listCtrl = this.getSelectedList();
            listCtrl.removeAllElements();
            if (groupObjects != null) {
                for (int i = 0; i < groupObjects.length; ++i) {
                    listCtrl.addElement((Object)groupObjects[i]);
                }
            }
        }
    }
}

