/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.model.io;

import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.AbstractR1XmlReader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlRecursiveReader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.upgrade.IR1XmlUpgradeChain;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.R1FormPage;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.data.R1FormDataManager;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.model.upgrade.R1FormXmlUpgradeChain;
import org.jdom2.Element;

public class R1FormXmlReader
extends AbstractR1XmlReader {
    @Override
    public IR1Page createPage() {
        R1FormPage page = new R1FormPage();
        page.setWidthLom(Util.pixel2Lom(800));
        page.setHeightLom(Util.pixel2Lom(600));
        return page;
    }

    @Override
    public IR1DataManager createDataManager() {
        return new R1FormDataManager();
    }

    @Override
    protected void parseModel(Element xmlRoot, ReportModel model) throws R1Exception {
        Element nodeReport = xmlRoot.getChild("Report");
        String type = nodeReport.getAttributeValue("type");
        if (type != null && !type.equals("r1-form")) {
            throw new R1Exception("\u6a21\u677f\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        Element nodePage = nodeReport.getChild("Page");
        model.setPage(this.parsePage(nodePage));
    }

    private IR1Page parsePage(Element nodePage) throws R1Exception {
        IR1Page page = this.createPage();
        page.setId(nodePage.getAttributeValue("id"));
        page.setWidthLom(Integer.parseInt(nodePage.getAttributeValue("width")));
        page.setHeightLom(Integer.parseInt(nodePage.getAttributeValue("height")));
        String styleKey = nodePage.getAttributeValue("styleId");
        StyleAttributes sa = this.getStyleCache().getStyle(styleKey);
        if (sa != null) {
            page.setStyleAttribute(sa);
        }
        this.loadContainer(this, nodePage, null, page);
        return page;
    }

    @Override
    protected void parseOthers(ReportModel model, Element xmlRoot) throws R1Exception {
    }

    @Override
    public void loadContainer(IR1XmlRecursiveReader reader, Element node, ICompositeContainer compositeContainer, IContainer container) throws R1Exception {
        Element nodeSubs = node.getChild("Sub-objects");
        if (nodeSubs != null) {
            for (Element nodeChild : nodeSubs.getChildren()) {
                IReportObject ro = this.parseObject(reader, nodeChild, this.getStyleCache());
                if (ro == null) continue;
                if (compositeContainer == null) {
                    container.addChild(ro, null);
                    continue;
                }
                compositeContainer.addChild(container, ro);
            }
        }
    }

    @Override
    public IR1XmlUpgradeChain createUpgradeChain() {
        return new R1FormXmlUpgradeChain();
    }
}

