/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.form.view;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.CellField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.Text;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.groupingcollect.GroupingCollectCell;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.groupingcollect.GroupingCollectGrid;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.AModel;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.MvcEvent;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.ASwingView;
import com.kingdee.bos.ctrl.reportone.reportimpl.r1form.R1TableModel_st;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComponent;

public class R1FGroupingCollectView
extends ASwingView {
    private GroupingCollectGrid groupingCollectGrid;
    private String[] columnNames = null;

    public R1FGroupingCollectView() {
        super((JComponent)new KDTable());
    }

    @Override
    protected JComponent init(JComponent c) {
        return c;
    }

    public KDTable getMainView() {
        return (KDTable)this.getComponent();
    }

    @Override
    protected void update(MvcEvent mvc) {
        R1TableModel_st model = (R1TableModel_st)mvc.getSource();
        KDTable table = this.getMainView();
        table.checkParsed();
        table.getDataRequestManager().setDataRequestMode(1);
        table.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)new MyDataRequestListener(model));
        table.setEditable(false);
        table.addColumns(this.groupingCollectGrid.getColumnsCount());
        int headCount = this.groupingCollectGrid.getHeadRowCount();
        HashSet<MergeBlock> mbs = new HashSet<MergeBlock>();
        for (int i = 0; i < headCount; ++i) {
            AbstractRow row = this.groupingCollectGrid.getRow(i);
            IRow tableRow = table.addHeadRow();
            for (int j = 0; j < row.getCellCount(); ++j) {
                MergeBlock mb;
                GroupingCollectCell cell = (GroupingCollectCell)row.getCell(j);
                ICellValue cellValue = cell.getValue();
                if (cellValue instanceof Text) {
                    tableRow.getCell(j).setValue((Object)((Text)cellValue).getText());
                }
                if ((mb = row.getCell(j).getMergeBlock()) == null || mbs.contains(mb)) continue;
                table.getHeadMergeManager().mergeBlock(mb.getTop(), mb.getLeft(), mb.getBottom(), mb.getRight());
                mbs.add(mb);
            }
        }
        table.refresh();
    }

    private String[] getColumnNames() {
        if (this.columnNames != null) {
            return this.columnNames;
        }
        int headRowCount = this.groupingCollectGrid.getHeadRowCount();
        AbstractRow dataRow = this.groupingCollectGrid.getRow(headRowCount);
        int colCount = dataRow.getCellCount();
        String[] columnNames = new String[colCount];
        for (int i = 0; i < colCount; ++i) {
            GroupingCollectCell cell = (GroupingCollectCell)dataRow.getCell(i);
            ICellValue cellValue = cell.getValue();
            if (!(cellValue instanceof CellField)) continue;
            columnNames[i] = ((CellField)cellValue).getName();
        }
        return columnNames;
    }

    public GroupingCollectGrid getGroupingCollectGrid() {
        return this.groupingCollectGrid;
    }

    public void setGroupingCollectGrid(GroupingCollectGrid groupingCollectGrid) {
        this.groupingCollectGrid = groupingCollectGrid;
    }

    @Override
    public void setModel(AModel model) {
        if (model instanceof R1TableModel_st) {
            ((R1TableModel_st)model).setRowsModel(false);
        }
        super.setModel(model);
    }

    private class MyDataRequestListener
    implements KDTDataRequestListener {
        R1TableModel_st model;

        public MyDataRequestListener(R1TableModel_st model) {
            this.model = model;
        }

        public void tableDataRequest(KDTDataRequestEvent e) {
            KDTable table = R1FGroupingCollectView.this.getMainView();
            try {
                int from = e.getFirstRow();
                int len = e.getLastRow() - from + 1;
                boolean first = from == 0;
                HashMap<String, String[]> params = new HashMap<String, String[]>(1);
                if (first) {
                    params.put("columnNames", R1FGroupingCollectView.this.getColumnNames());
                }
                RptParams rptParams = this.model.executeQuery(first, from, len, params);
                if (first) {
                    int rowCount = rptParams.getInt("rowCount");
                    table.setRowCount(rowCount);
                    if (rowCount == 0) {
                        return;
                    }
                }
                RptRowSet rs = (RptRowSet)rptParams.getObject("rowset");
                KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)table);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

