/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.AutoGrowList;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.IGrid;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AutoGrowGrid
implements IGrid {
    private int colCount = 0;
    private AutoGrowList cols = new AutoGrowList();
    private AutoGrowList rows = new AutoGrowList();

    @Override
    public int getColCount() {
        return this.cols.size();
    }

    @Override
    public void setColCount(int x) {
        if (this.rows.size() > 0) {
            throw new IllegalStateException("\u884c\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u6539\u53d8\u5217\u6570\uff01");
        }
        this.colCount = x;
        this.cols.setSize(x);
    }

    @Override
    public Object getCol(int colIdx) {
        return this.cols.get(colIdx);
    }

    @Override
    public void setCol(int colIdx, Object col) {
        this.cols.set(colIdx, col);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public void setRowCount(int x) {
        this.ensureCells(x - 1);
    }

    private void checkColIndex(int colIdx) {
        if (colIdx >= this.colCount) {
            throw new IndexOutOfBoundsException("Column Index: " + colIdx + ", Size: " + this.colCount);
        }
    }

    private Object[] getCells(int rowIdx) {
        return (Object[])this.rows.get(rowIdx);
    }

    private Object[] ensureCells(int rowIdx) {
        int z = this.rows.size();
        if (rowIdx >= z) {
            for (int i = z; i <= rowIdx; ++i) {
                this.rows.add(new Object[this.colCount + 1]);
            }
        }
        return (Object[])this.rows.get(rowIdx);
    }

    @Override
    public Object getRow(int rowIdx) {
        return this.getCells(rowIdx)[this.colCount];
    }

    public Object getSureRow(int rowIdx) {
        return this.ensureCells(rowIdx)[this.colCount];
    }

    @Override
    public void setRow(int rowIdx, Object obj) {
        this.ensureCells((int)rowIdx)[this.colCount] = obj;
    }

    @Override
    public int addRow(Object obj) {
        Object[] cells = new Object[this.colCount + 1];
        cells[this.colCount] = obj;
        this.rows.add(cells);
        return this.rows.size() - 1;
    }

    @Override
    public Object getCell(int rowIdx, int colIdx) {
        this.checkColIndex(colIdx);
        return this.getCells(rowIdx)[colIdx];
    }

    public Object getSureCell(int rowIdx, int colIdx) {
        this.checkColIndex(colIdx);
        return this.ensureCells(rowIdx)[colIdx];
    }

    @Override
    public void setCell(int rowIdx, int colIdx, Object obj) {
        this.checkColIndex(colIdx);
        this.ensureCells((int)rowIdx)[colIdx] = obj;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int rowCount = this.getRowCount();
        int colCount = this.getColCount();
        sb.append("GRID: ");
        sb.append(rowCount);
        sb.append("rows, ");
        sb.append(colCount);
        sb.append("cols\r\n");
        sb.append("COLUMNS: \t");
        for (int j = 0; j < colCount; ++j) {
            sb.append("[");
            sb.append(j);
            sb.append("]=");
            Object col = this.getCol(j);
            if (col != null) {
                sb.append(col);
            } else {
                sb.append("_");
                sb.append(j);
                sb.append("_");
            }
            sb.append("\t");
        }
        sb.append("\r\n");
        for (int i = 0; i < rowCount; ++i) {
            sb.append("[");
            sb.append(i);
            sb.append("]=");
            sb.append(this.getRow(i));
            sb.append(":");
            for (int j = 0; j < colCount; ++j) {
                sb.append("\t|");
                sb.append(j);
                sb.append("| ");
                Object cell = this.getCell(i, j);
                if (cell == null) continue;
                sb.append(cell);
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public Iterator iterateRows() {
        return new RowsIterator();
    }

    public Iterator iterateCols() {
        return this.cols.iterator();
    }

    public CellsIterator iterateCells() {
        return new CellsIterator();
    }

    protected class CellsIterator
    implements Iterator {
        protected int rowIdx = 0;
        protected int colIdx = -1;

        CellsIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.rowIdx < AutoGrowGrid.this.getRowCount() && (this.rowIdx + 1 != AutoGrowGrid.this.getRowCount() || this.colIdx + 1 != AutoGrowGrid.this.getColCount());
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.colIdx;
            if (this.colIdx == AutoGrowGrid.this.getColCount()) {
                ++this.rowIdx;
                this.colIdx = 0;
            }
            return AutoGrowGrid.this.getCell(this.rowIdx, this.colIdx);
        }

        @Override
        public void remove() {
            if (this.colIdx == -1) {
                throw new IllegalStateException();
            }
            try {
                AutoGrowGrid.this.setCell(this.rowIdx, this.colIdx, null);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        public final int getColIndex() {
            return this.colIdx;
        }

        public final int getRowIndex() {
            return this.rowIdx;
        }
    }

    private class RowsIterator
    implements Iterator {
        private int rowIdx = -1;

        RowsIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.rowIdx + 1 < AutoGrowGrid.this.rows.size();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.rowIdx;
            return AutoGrowGrid.this.getRow(this.rowIdx);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

