/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.ui;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.ui.ADialog;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.ui.XYGridLayout;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.xygrid.XYCell;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.xygrid.XYGrid;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSeparator;

public class SimpleDialog
extends ADialog {
    private XYGrid xyGrid;
    private JComponent component;
    private JButton[] buttons;
    private JButton okButton;
    private JButton cancelButton;
    private ActionListener actionHandler;

    public SimpleDialog() throws HeadlessException {
        this.init();
    }

    public SimpleDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public SimpleDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (this.okButton == src) {
            this.onOK();
        } else if (this.cancelButton == src) {
            this.onCancel();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.buttons = new JButton[2];
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        this.buttons[0] = this.okButton;
        this.buttons[1] = this.cancelButton;
        this.actionHandler = new ActionHandler();
        this.xyGrid = new XYGrid();
        this.xyGrid.init(3, 5);
        this.xyGrid.merge(0, 0, 1, 5);
        this.xyGrid.merge(1, 0, 1, 5);
        Container cp = this.getContentPane();
        cp.setLayout(new XYGridLayout(this.xyGrid));
        this.xyGrid.rowXYInfo(0).setLevel(1);
        this.xyGrid.colXYInfo(0).setLevel(1);
        this.xyGrid.rowXYInfo(1).setPrefCxy(12);
        this.xyGrid.rowXYInfo(1).style().setPaddingTop(5);
        cp.add((Component)new JSeparator(), this.xyGrid.cellXY(1, 0));
        this.initButtons();
    }

    private void initButtons() {
        Dimension maxPref = null;
        for (int i = 0; i < this.buttons.length; ++i) {
            JButton btn = this.buttons[i];
            Dimension sz = btn.getPreferredSize();
            if (maxPref != null && maxPref.width >= sz.width) continue;
            maxPref = sz;
        }
        Container cp = this.getContentPane();
        int rowIdx = this.xyGrid.getRowCount() - 1;
        int colIdx = this.xyGrid.getColCount() - 1;
        int i = this.buttons.length - 1;
        while (i >= 0) {
            JButton btn = this.buttons[i];
            btn.setPreferredSize(maxPref);
            btn.setMaximumSize(maxPref);
            btn.setMinimumSize(maxPref);
            btn.addActionListener(this.actionHandler);
            XYCell xyCell = this.xyGrid.cellXY(rowIdx, colIdx);
            xyCell.style().setMarginRight(8);
            xyCell.style().setMarginBottom(8);
            cp.add((Component)btn, xyCell);
            --i;
            --colIdx;
        }
    }

    public final JComponent getComponent() {
        return this.component;
    }

    public final void setComponent(JComponent x) {
        this.component = x;
        XYCell xyCell = this.xyGrid.cellXY(0, 0);
        xyCell.style().setMargin(8);
        xyCell.style().setMarginBottom(0);
        this.getContentPane().add((Component)x, xyCell);
    }

    protected final ActionListener getActionHandler() {
        return this.actionHandler;
    }

    protected void onCancel() {
        this.result = false;
        this.dispose();
    }

    protected void onOK() {
        this.result = true;
        this.dispose();
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleDialog.this.actionPerformed(e);
        }
    }
}

