/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.xygrid;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.xygrid.XYInfo;
import java.util.Iterator;
import java.util.LinkedList;

public class XYArrange {
    public static final int ARRANGE_SINGLE = 0;
    public static final int ARRANGE_LEVEL = 1;
    private int policy = 1;
    private int count;
    private long maxCxy;
    private long minCxy;
    private long prefCxy;
    private XYInfo[] infos;

    public final int getPolicy() {
        return this.policy;
    }

    public final void setPolicy(int policy) {
        this.policy = policy;
    }

    public void init(int count, Iterator i) {
        LinkedList<XYInfo> list = new LinkedList<XYInfo>();
        this.minCxy = 0L;
        this.maxCxy = 0L;
        this.prefCxy = 0L;
        this.count = count;
        while (i.hasNext()) {
            int j;
            XYInfo info = (XYInfo)i.next();
            this.minCxy += (long)info.getMinCxy();
            this.maxCxy += (long)info.getMaxCxy();
            this.prefCxy += (long)info.getPrefCxy();
            int level = info.getLevel();
            int z = list.size();
            for (j = 0; j < z && level <= ((XYInfo)list.get(j)).getLevel(); ++j) {
            }
            list.add(j, info);
        }
        this.infos = new XYInfo[this.count];
        list.toArray(this.infos);
    }

    public void arrange(int cxy) {
        if ((long)cxy <= this.minCxy) {
            this.toMinCxy(0, this.count - 1);
        } else if ((long)cxy >= this.maxCxy) {
            this.toMaxCxy(0, this.count - 1);
        } else if ((long)cxy == this.prefCxy) {
            this.toPrefCxy(0, this.count - 1);
        } else {
            this.arrangeCxy(cxy);
        }
    }

    private void toMaxCxy(int i, int i2) {
        while (i <= i2) {
            XYInfo info = this.infos[i];
            info.setCxy(info.getMaxCxy());
            ++i;
        }
    }

    private void toMinCxy(int i, int i2) {
        while (i <= i2) {
            XYInfo info = this.infos[i];
            info.setCxy(info.getMinCxy());
            ++i;
        }
    }

    private void toPrefCxy(int i, int i2) {
        while (i <= i2) {
            XYInfo info = this.infos[i];
            info.setCxy(info.getPrefCxy());
            ++i;
        }
    }

    private void arrangeCxy(int cxy) {
        int remainIdx;
        boolean toMax = (long)cxy > this.prefCxy;
        long remainCxy = toMax ? (long)cxy - this.prefCxy : this.prefCxy - (long)cxy;
        for (remainIdx = 0; remainIdx < this.count; ++remainIdx) {
            int dxy;
            XYInfo info = this.infos[remainIdx];
            int n = dxy = toMax ? info.getMaxCxy() - info.getPrefCxy() : info.getPrefCxy() - info.getMinCxy();
            if (remainCxy <= (long)dxy) break;
            remainCxy -= (long)dxy;
        }
        switch (this.policy) {
            case 1: {
                this.arrangeLevelCxy(toMax, remainIdx, remainCxy);
                break;
            }
            case 0: {
                this.arrangeSingleCxy(toMax, remainIdx, remainCxy);
            }
        }
    }

    private void arrangeSingleCxy(boolean toMax, int remainIdx, long remainCxy) {
        XYInfo info = this.infos[remainIdx];
        if (toMax) {
            this.toMaxCxy(0, remainIdx - 1);
            info.setCxy((int)((long)info.getPrefCxy() + remainCxy));
        } else {
            this.toMinCxy(0, remainIdx - 1);
            info.setCxy((int)((long)info.getPrefCxy() - remainCxy));
        }
        this.toPrefCxy(remainIdx + 1, this.count - 1);
    }

    private void arrangeLevelCxy(boolean toMax, int remainIdx, long remainCxy) {
        int idx2;
        XYInfo info;
        int idx1;
        int level = this.infos[remainIdx].getLevel();
        for (idx1 = remainIdx - 1; idx1 >= 0 && level == (info = this.infos[idx1]).getLevel(); --idx1) {
            int dxy = toMax ? info.getMaxCxy() - info.getPrefCxy() : info.getPrefCxy() - info.getMinCxy();
            remainCxy += (long)dxy;
        }
        ++idx1;
        for (idx2 = remainIdx + 1; idx2 < this.count && level == this.infos[idx2].getLevel(); ++idx2) {
        }
        int cnt = --idx2 - idx1 + 1;
        if (toMax) {
            this.toMaxCxy(0, idx1 - 1);
            this.avgCxy(idx1, idx2, cnt, remainCxy);
        } else {
            this.toMinCxy(0, idx1 - 1);
            this.avgCxy(idx1, idx2, cnt, -remainCxy);
        }
        this.toPrefCxy(idx2 + 1, this.count - 1);
    }

    private void avgCxy(int idx1, int idx2, int count, long remainCxy) {
        int i;
        for (i = idx1; i <= idx2; ++i) {
            XYInfo info = this.infos[i];
            info.setCxy(info.getPrefCxy());
        }
        block1: while (count > 0 && remainCxy != 0L) {
            int stepCxy = (int)(remainCxy / (long)count);
            if (stepCxy == 0) {
                stepCxy = remainCxy > 0L ? 1 : -1;
            }
            for (int i2 = idx1; i2 <= idx2; ++i2) {
                XYInfo info = this.infos[i2];
                if (info.getCxy() < 0) continue;
                int cxy = info.getCxy() + stepCxy;
                if (cxy > info.getMaxCxy()) {
                    remainCxy += (long)(info.getCxy() - info.getMaxCxy());
                    --count;
                    info.setCxy(-info.getMaxCxy());
                } else if (cxy < info.getMinCxy()) {
                    remainCxy += (long)(info.getCxy() - info.getMinCxy());
                    --count;
                    info.setCxy(-info.getMinCxy());
                } else {
                    remainCxy -= (long)stepCxy;
                    info.setCxy(cxy);
                }
                if (remainCxy == 0L) continue block1;
            }
        }
        for (i = idx1; i <= idx2; ++i) {
            XYInfo info = this.infos[i];
            if (info.getCxy() >= 0) continue;
            info.setCxy(-info.getCxy());
        }
    }
}

